/*
 * Decompiled with CFR 0.152.
 */
import com.denova.JExpress.JExpressConstants;
import com.denova.io.Log;
import com.denova.ui.GridBagControl;
import com.denova.ui.WizardPanel;
import com.denova.util.PropertyList;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class PicardComponentSelectionPanel
extends WizardPanel
implements JExpressConstants {
    public PicardComponentSelectionPanel(PropertyList propertyList, Log log) {
        super(propertyList, log);
        this.layoutScreen();
    }

    public void layoutScreen() {
        EmptyBorder emptyBorder = new EmptyBorder(20, 20, 20, 20);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(emptyBorder);
        GridBagConstraints gridBagConstraints = GridBagControl.getDefaultConstraints();
        gridBagConstraints.anchor = 10;
        GridBagConstraints gridBagConstraints2 = GridBagControl.getDefaultConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        GridBagConstraints gridBagConstraints3 = GridBagControl.getDefaultConstraints();
        gridBagConstraints3.fill = 2;
        JPanel jPanel = new JPanel();
        GridBagControl gridBagControl = new GridBagControl(jPanel);
        JLabel jLabel = new JLabel(PicardResources.ComponentSelectionPanelTitle);
        jLabel.setFont(new Font("Bold", 1, 12));
        JLabel jLabel2 = new JLabel(PicardResources.ComponentSelectionDescriptionMsg01);
        JLabel jLabel3 = new JLabel(PicardResources.ComponentSelectionDescriptionMsg02);
        JLabel jLabel4 = new JLabel(PicardResources.ComponentSelectionNoComponents);
        gridBagControl.addCentered(jLabel);
        gridBagControl.addVerticalSpace();
        gridBagControl.addCentered(jLabel2);
        gridBagControl.addCentered(jLabel3);
        gridBagControl.addVerticalSpace();
        gridBagControl.addCentered(jLabel4);
        gridBagControl.addVerticalSpace();
        this.add(jPanel);
        this.setPreferredSize(new Dimension(300, 300));
    }

    public void setActive(boolean bl) {
        if (bl) {
            this.selectDefaultOptions();
            this.showNextPanel();
        }
    }

    public String getName() {
        return "PicardComponentSelectionPanel";
    }

    public boolean isOk() {
        this.saveSelectedChoices();
        this.CheckVersions();
        boolean bl = true;
        if (this.MissingDependency()) {
            bl = false;
        }
        if (this.NoDiskSpace()) {
            bl = false;
        }
        return bl;
    }

    private void selectDefaultOptions() {
    }

    private void saveSelectedChoices() {
        Enumeration enumeration = PicardInstaller.componentManager.enumerateAllComponents();
        PicardInstaller.componentManager.clearSelection();
        while (enumeration.hasMoreElements()) {
            PicardInstallableComponent picardInstallableComponent = (PicardInstallableComponent)enumeration.nextElement();
            if (!picardInstallableComponent.isRequiredComponent()) continue;
            PicardInstaller.componentManager.addSelection(picardInstallableComponent);
        }
    }

    private boolean MissingDependency() {
        boolean bl = false;
        Enumeration enumeration = PicardInstaller.componentManager.enumerateSelectedComponents();
        while (enumeration.hasMoreElements()) {
            PicardInstallableComponent picardInstallableComponent = (PicardInstallableComponent)enumeration.nextElement();
            Vector vector = picardInstallableComponent.getRequiredComponents();
            int n = 0;
            while (n < vector.size()) {
                PicardInstallableComponent picardInstallableComponent2 = PicardInstaller.componentManager.findComponent((String)vector.elementAt(n));
                if (!PicardInstaller.componentManager.isSelected(picardInstallableComponent2)) {
                    bl = true;
                    this.note(picardInstallableComponent.getTitle() + " " + PicardResources.MsgComponentRequires + " " + picardInstallableComponent2.getTitle());
                }
                ++n;
            }
        }
        return bl;
    }

    private boolean NoDiskSpace() {
        long l = 0L;
        Enumeration enumeration = PicardInstaller.componentManager.enumerateSelectedComponents();
        while (enumeration.hasMoreElements()) {
            PicardInstallableComponent picardInstallableComponent = (PicardInstallableComponent)enumeration.nextElement();
            l += (long)picardInstallableComponent.getSize();
        }
        String string = this.getPropertyList().getProperty("applicationDirectory");
        long l2 = PicardInstaller.platform.getDiskSpace(string) / 1024L;
        if (l2 == -1L) {
            this.note(PicardResources.MsgUnknownDiskSpace);
            return false;
        }
        if (l > l2) {
            long l3 = l - l2;
            this.note(PicardResources.MsgNoDiskSpace + " " + l3 + " " + PicardResources.MsgNoDiskSpaceUnits);
            return true;
        }
        return false;
    }

    public void CheckVersions() {
        Enumeration enumeration = PicardInstaller.componentManager.enumerateSelectedComponents();
        while (enumeration.hasMoreElements()) {
            PicardInstallableComponent picardInstallableComponent = (PicardInstallableComponent)enumeration.nextElement();
            if (picardInstallableComponent.getVersion() >= PicardInstaller.configuration.getVersion(picardInstallableComponent.getName()) || !this.ask(PicardResources.MsgComponentExist1 + " " + picardInstallableComponent.getTitle() + " " + PicardResources.MsgComponentExist2, PicardResources.MsgComponentExist3, PicardResources.MsgComponentExist4, PicardResources.MsgComponentExist5)) continue;
            PicardInstaller.componentManager.removeSelection(picardInstallableComponent);
        }
    }

    private boolean getSelectedState(String string) {
        PicardInstallableComponent picardInstallableComponent = PicardInstaller.componentManager.findComponent(string);
        boolean bl = picardInstallableComponent.isSelectedByDefault();
        if (PicardInstaller.silentConfiguration.isSilentInstall()) {
            bl = PicardInstaller.silentConfiguration.installComponent(string, bl);
        }
        return bl;
    }
}

