/*
 * Decompiled with CFR 0.152.
 */
import com.denova.JExpress.JExpressConstants;
import com.denova.io.Log;
import com.denova.runtime.WindowsOS;
import com.denova.ui.GridBagControl;
import com.denova.ui.WizardPanel;
import com.denova.util.PropertyList;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class PicardCheckRequirementsPanel
extends WizardPanel
implements JExpressConstants {
    private JLabel theTitle;
    private JLabel theDescription01;
    private JLabel theDescription02;

    public PicardCheckRequirementsPanel(PropertyList propertyList, Log log) {
        super(propertyList, log);
        this.layoutScreen();
    }

    public void layoutScreen() {
        EmptyBorder emptyBorder = new EmptyBorder(20, 20, 20, 20);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(emptyBorder);
        JPanel jPanel = new JPanel();
        GridBagControl gridBagControl = new GridBagControl(jPanel);
        this.theTitle = new JLabel(PicardResources.CheckingRequirementsPanelTitle);
        this.theTitle.setFont(new Font("Bold", 1, 12));
        this.theDescription01 = new JLabel(PicardResources.CheckingRequirementsDescriptionMsg01);
        this.theDescription02 = new JLabel(PicardResources.CheckingRequirementsDescriptionMsg02);
        gridBagControl.addCentered(this.theTitle);
        gridBagControl.addVerticalSpace();
        gridBagControl.addCentered(this.theDescription01);
        gridBagControl.addCentered(this.theDescription02);
        gridBagControl.addVerticalSpace();
        this.add(jPanel);
        this.setPreferredSize(new Dimension(200, 200));
    }

    public void setActive(boolean bl) {
        if (bl) {
            this.theDescription01.setText(PicardResources.CheckingRequirementsDescriptionMsg01);
            this.theDescription02.setText(PicardResources.CheckingRequirementsDescriptionMsg02);
            if (!this.SetupNativeCode()) {
                this.theTitle.setText(PicardResources.WrongPlatformPanelTitle);
                this.theDescription01.setText(PicardResources.WrongPlatformDescriptionMsg01);
                this.theDescription02.setText(PicardResources.WrongPlatformDescriptionMsg02);
                this.getNextButton().setEnabled(false);
            }
            if (this.isPowerChutePlusInstalled()) {
                this.theTitle.setText(PicardResources.PowerChuteInstalledPanelTitle);
                this.theDescription01.setText(PicardResources.PowerChuteInstalledDescriptionMsg01);
                this.theDescription02.setText(PicardResources.PowerChuteInstalledDescriptionMsg02);
                this.getNextButton().setEnabled(false);
            } else if (!this.permissionsOK()) {
                if (this.isLinux() || this.isNetware() || this.isSolaris()) {
                    this.theTitle.setText(PicardResources.NotRootPanelTitle);
                    this.theDescription01.setText(PicardResources.NotRootDescriptionMsg01);
                    this.theDescription02.setText(PicardResources.NotRootDescriptionMsg02);
                } else {
                    this.theTitle.setText(PicardResources.NotAdministratorPanelTitle);
                    this.theDescription01.setText(PicardResources.NotAdministratorDescriptionMsg01);
                    this.theDescription02.setText(PicardResources.NotAdministratorDescriptionMsg02);
                }
                this.getNextButton().setEnabled(false);
            } else if (this.isUpsManagerInstalled()) {
                this.theTitle.setText(PicardResources.UpsManagerInstalledPanelTitle);
                this.theDescription01.setText(PicardResources.UpsManagerInstalledDescriptionMsg01);
                this.theDescription02.setText(PicardResources.UpsManagerInstalledDescriptionMsg02);
            } else {
                this.showNextPanel();
            }
        }
    }

    public String getName() {
        return "PicardCheckRequirementsPanel";
    }

    private boolean permissionsOK() {
        return PicardInstaller.platform.isRoot();
    }

    private boolean correctPlatform() {
        boolean bl;
        if (PicardNative.isWinPackage()) {
            WindowsOS windowsOS;
            String string;
            boolean bl2 = bl = this.isWindowsNT() || this.isWindows2000();
            if (bl && (string = (windowsOS = new WindowsOS()).queryWindowsRegistry("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "CurrentVersion")) != null && (double)Float.parseFloat(string) < 4.0) {
                bl = false;
            }
        } else {
            bl = this.isLinux();
            if (!bl) {
                bl = this.isNetware();
            }
            if (!bl) {
                bl = this.isSolaris();
            }
        }
        return bl;
    }

    private boolean SetupNativeCode() {
        PicardNative.extractNativeCode();
        boolean bl = this.correctPlatform();
        if (bl) {
            this.getPropertyList().setBooleanProperty("Linux", this.isLinux());
            this.getPropertyList().setBooleanProperty("Netware", this.isNetware());
            this.getPropertyList().setBooleanProperty("Solaris", this.isSolaris());
            PicardInstaller.platform = this.isLinux() ? new PicardLinuxPlatform(this.getPropertyList()) : (this.isNetware() ? new PicardNetwarePlatform(this.getPropertyList()) : (this.isSolaris() ? new PicardSolarisPlatform(this.getPropertyList()) : new PicardWindowsPlatform(this.getPropertyList())));
        }
        return bl;
    }

    private boolean isPowerChutePlusInstalled() {
        boolean bl = false;
        if (this.isWindows()) {
            File file;
            WindowsOS windowsOS = new WindowsOS();
            String string = windowsOS.queryWindowsRegistry("HKEY_LOCAL_MACHINE\\Software\\APC\\PowerChute plus\\CurrentVersion", "ImagePath");
            if (string != null && (file = new File(string)) != null) {
                bl = file.exists();
            }
        } else if (this.isLinux() || this.isSolaris()) {
            File file = new File("/etc/apc_repository");
            if (file != null) {
                bl = file.exists();
            }
        } else if (this.isNetware()) {
            File file = new File("SYS:\\System\\Autoexec.ncf");
            String string = "LOAD PWRCHUTE";
            if (file != null) {
                try {
                    FileReader fileReader = new FileReader(file);
                    Long l = new Long(file.length());
                    if (l.intValue() > 0) {
                        char[] cArray = new char[l.intValue()];
                        fileReader.read(cArray, 0, l.intValue());
                        String string2 = new String(cArray);
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
                        while (stringTokenizer.hasMoreTokens() && !bl) {
                            String string3 = stringTokenizer.nextToken().trim().toUpperCase();
                            if (!string3.startsWith(string)) continue;
                            bl = true;
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isUpsManagerInstalled() {
        boolean bl;
        block11: {
            block13: {
                block12: {
                    File file;
                    bl = false;
                    if (!this.isWindows()) break block12;
                    WindowsOS windowsOS = new WindowsOS();
                    String string = windowsOS.queryWindowsRegistry("HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\PowerChuteUpsManager\\Parameters", "AppDirectory");
                    if (string != null && (file = new File(string)) != null) {
                        bl = file.exists();
                    }
                    break block11;
                }
                if (!this.isNetware()) break block13;
                File file = new File("SYS:\\System\\Autoexec.ncf");
                if (file != null) {
                    try {
                        FileReader fileReader = new FileReader(file);
                        Long l = new Long(file.length());
                        if (l.intValue() > 0) {
                            char[] cArray = new char[l.intValue()];
                            fileReader.read(cArray, 0, l.intValue());
                            String string = new String(cArray);
                            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                            while (stringTokenizer.hasMoreTokens() && !bl) {
                                String string2 = stringTokenizer.nextToken().trim();
                                if (!string2.endsWith(PicardNetwarePlatform.thePBEAgentCommand)) continue;
                                bl = true;
                            }
                        }
                        break block11;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {}
                }
                break block11;
            }
            String string = null;
            if (this.isLinux()) {
                string = "/etc/rc.d/init.d/PBEAgent";
            } else if (this.isSolaris()) {
                string = "/etc/rc2.d/S99PBEAgent";
            }
            File file = new File(string);
            if (file != null) {
                bl = file.exists();
            }
        }
        if (!PicardInstaller.RPMBuild()) return bl;
        return false;
    }
}

