/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.ds.services.protocol;

import com.apcc.m11.ds.services.protocol.AgentRequest;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;

public class AgentTransport
implements Serializable {
    private InetAddress theSourceAddress;
    private InetAddress theDestinationAddress;
    private String theConsoleRequestID;
    private int theRequestType;
    private Vector theRequests;

    public AgentTransport(AgentTransport agentTransport) {
        if (agentTransport != null) {
            this.theSourceAddress = agentTransport.getSourceAddress();
            this.theDestinationAddress = agentTransport.getDestinationAddress();
            this.theConsoleRequestID = agentTransport.getConsoleRequestID();
            this.theRequests = (Vector)agentTransport.getRequestList().clone();
        }
    }

    public AgentTransport() {
    }

    public InetAddress getSourceAddress() {
        return this.theSourceAddress;
    }

    public void setSourceAddress(InetAddress inetAddress) {
        this.theSourceAddress = inetAddress;
    }

    public InetAddress getDestinationAddress() {
        return this.theDestinationAddress;
    }

    public void setDestinationAddress(InetAddress inetAddress) {
        this.theDestinationAddress = inetAddress;
    }

    public String getConsoleRequestID() {
        return this.theConsoleRequestID;
    }

    public void setConsoleRequestID(String string) {
        this.theConsoleRequestID = string;
    }

    public int getRequestType() {
        return this.theRequestType;
    }

    public void setRequestType(int n) {
        this.theRequestType = n;
    }

    public Vector getRequestList() {
        return this.theRequests;
    }

    public void setRequestList(Vector vector) {
        this.theRequests = vector;
    }

    public void addRequest(AgentRequest agentRequest) {
        if (this.theRequests == null) {
            this.theRequests = new Vector();
        }
        this.theRequests.add(agentRequest);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Source Address = ");
        if (this.theRequestType == 11) {
            return "Ping...";
        }
        if (this.theRequestType == 12) {
            return "...Pong";
        }
        if (this.theSourceAddress != null) {
            stringBuffer.append(this.theSourceAddress);
        } else {
            stringBuffer.append("[null value]");
        }
        stringBuffer.append("\nDestination Address = ");
        if (this.theDestinationAddress != null) {
            stringBuffer.append(this.theDestinationAddress);
        } else {
            stringBuffer.append("[null value]");
        }
        stringBuffer.append("\nConsole Request ID =" + this.theConsoleRequestID);
        stringBuffer.append("\nThere are ");
        if (this.theRequests != null) {
            stringBuffer.append(this.theRequests.size());
        } else {
            stringBuffer.append("0");
        }
        stringBuffer.append(" requests");
        stringBuffer.append("\n***Request Details: \n***");
        Enumeration enumeration = this.theRequests.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof AgentRequest)) continue;
            AgentRequest agentRequest = (AgentRequest)e;
            stringBuffer.append("  OID: " + agentRequest.getObjectId());
            stringBuffer.append("  VALUE: " + agentRequest.getValue());
            stringBuffer.append("  EXCEPTION: " + agentRequest.getException());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

