/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.ds.services.ShutdownBehavior;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.ds.services.ShutdownBehavior.Group;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class ScheduleShutdown
implements Serializable {
    private static final String kUniqueOid = "2";
    public static final ObjectId kOid = new ObjectId(Group.kOid + "." + "2");
    private boolean theEnable;
    private int thePeriodicity;
    public static final int kWeekly = 2;
    public static final int kDaily = 1;
    public static final int kNever = 0;
    private Date theStartDate;
    private long theLengthMinutes;

    public ScheduleShutdown() {
        this.theEnable = false;
    }

    public ScheduleShutdown(boolean bl, int n, Date date, long l) {
        this.theEnable = bl;
        this.thePeriodicity = n;
        this.theStartDate = date;
        this.theLengthMinutes = l;
    }

    public boolean getEnable() {
        return this.theEnable;
    }

    public int getPeriodicity() {
        return this.thePeriodicity;
    }

    public Date getStartDate() {
        return this.theStartDate;
    }

    public long getLengthMinutes() {
        return this.theLengthMinutes;
    }

    public String toString() {
        String string;
        if (this.theEnable) {
            string = "true|";
            string = this.thePeriodicity == 2 ? string + "weekly|" : (this.thePeriodicity == 1 ? string + "daily|" : string + "never|");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            string = string + simpleDateFormat.format(this.theStartDate) + "|";
            string = string + this.theLengthMinutes;
        } else {
            string = "false";
        }
        return string;
    }
}

