/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.debug;

import com.apcc.m11.debug.LogEntry;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Vector;

public class LogFile {
    private File fFile = null;
    private Vector fGroups;
    private String theLogFileName;
    private Vector fEntries;

    public LogFile() {
    }

    public LogFile(String string) {
        this.setLogFileName(string);
        this.open();
    }

    public void setLogFileName(String string) {
        this.theLogFileName = string;
    }

    public String getLogFileName() {
        return this.theLogFileName;
    }

    public boolean open() {
        boolean bl = false;
        if (this.theLogFileName != null) {
            this.fFile = new File(this.theLogFileName);
            if (this.fFile.exists()) {
                this.readContents();
                bl = true;
            }
        }
        return bl;
    }

    public void close() {
    }

    public Vector getGroups() {
        return (Vector)this.fGroups.clone();
    }

    public Vector getContents() {
        return (Vector)this.fEntries.clone();
    }

    public int getSize() {
        return this.fEntries.size();
    }

    private void readContents() {
        try {
            this.fEntries = new Vector();
            this.fGroups = new Vector();
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.fFile));
            Object object = null;
            LogEntry logEntry = null;
            boolean bl = false;
            while (!bl) {
                try {
                    object = objectInputStream.readObject();
                }
                catch (EOFException eOFException) {
                    bl = true;
                    break;
                }
                if (!(object instanceof LogEntry)) continue;
                logEntry = (LogEntry)object;
                if (this.fGroups.indexOf(logEntry.getGroup()) == -1) {
                    this.fGroups.addElement(logEntry.getGroup());
                }
                this.fEntries.addElement(object);
            }
            objectInputStream.close();
        }
        catch (StreamCorruptedException streamCorruptedException) {
            streamCorruptedException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (OptionalDataException optionalDataException) {
            optionalDataException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

