/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.debug;

import com.apcc.m11.debug.IDebugModel;
import com.apcc.m11.debug.LogEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DEBUG {
    private static boolean gLogging = false;
    private static boolean gTracing = false;
    private static Hashtable gGroups = new Hashtable();
    private static ObjectOutputStream gOutputStream = null;
    private static int gExceptionCount = 0;
    public static final String kLogFileName = "m11.apc";
    private static final String kDefaultGroup = "Default";
    private static final String kPreConditionGroup = "PreCondition";
    private static final String kPostConditionGroup = "PostCondition";

    public static void Log(String string) {
        DEBUG.Log(kDefaultGroup, string, null);
    }

    public static void Log(String string, String string2) {
        DEBUG.Log(string, string2, null);
    }

    public static void Log(String string, String string2, IDebugModel iDebugModel) {
        if (gLogging) {
            LogEntry logEntry = new LogEntry(string, string2, iDebugModel);
            DEBUG.WriteToLog(logEntry);
        }
    }

    public static void PreCondition(boolean bl, String string) {
        if (!bl) {
            DEBUG.Log(kPreConditionGroup, string);
        }
    }

    public static void PostCondition(boolean bl, String string) {
        if (!bl) {
            DEBUG.Log(kPostConditionGroup, string);
        }
    }

    public static void EnableGroup(String string, boolean bl) {
        gGroups.put(string, new Boolean(bl));
    }

    public static void EnableAllGroups(boolean bl) {
        Enumeration enumeration = gGroups.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            DEBUG.EnableGroup(string, bl);
        }
    }

    public static Vector GetGroups() {
        Vector vector = null;
        Hashtable hashtable = gGroups;
        synchronized (hashtable) {
            vector = (Vector)gGroups.clone();
        }
        return vector;
    }

    public static void Trace(String string) {
        if (gTracing) {
            System.out.println(string);
        }
    }

    public static OutputStream CreateFileOutputStream(String string) {
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string);
            fileOutputStream = new FileOutputStream(string, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileOutputStream;
    }

    public static boolean SetOutputStream(OutputStream outputStream) {
        boolean bl = false;
        try {
            if (outputStream != null) {
                gOutputStream = new ObjectOutputStream(outputStream);
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public static void SetLogging(boolean bl) {
        gLogging = bl;
    }

    public static void SetTracing(boolean bl) {
        gTracing = bl;
    }

    public static boolean IsLogging() {
        return gLogging;
    }

    public static boolean IsTracing() {
        return gTracing;
    }

    public static void Break() {
        boolean bl = false;
    }

    public void finalize() {
        if (gOutputStream != null) {
            try {
                gOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("The debugger is slowly dying...");
            }
        }
    }

    private static synchronized void WriteToLog(LogEntry logEntry) {
        try {
            if (gOutputStream == null) {
                FileOutputStream fileOutputStream = new FileOutputStream(kLogFileName);
                gOutputStream = new ObjectOutputStream(fileOutputStream);
                DEBUG.EnableGroup(kDefaultGroup, true);
                DEBUG.EnableGroup(kPreConditionGroup, true);
                DEBUG.EnableGroup(kPostConditionGroup, true);
            }
            gOutputStream.writeObject(logEntry);
            gOutputStream.flush();
        }
        catch (IOException iOException) {
            System.out.println(++gExceptionCount + ": Disabling logging - internal error occurred!");
            gLogging = false;
        }
    }
}

