/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.arch.storage;

import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.StorageEntryException;
import com.apcc.m11.debug.DEBUG;
import com.apcc.m11.debug.util.StackTraceDebugModel;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;

public class PermanentStorage
implements IPermanentStorage {
    private String theConfigFileName;
    public static final String kDebugGroupId = "PermanentStorage";
    private static final String kIdSeparator = ".";
    private Hashtable theStorageEntries;

    public PermanentStorage(String string) {
        this.theConfigFileName = string;
        this.theStorageEntries = new Hashtable();
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.theConfigFileName));
            this.theStorageEntries = (Hashtable)objectInputStream.readObject();
        }
        catch (FileNotFoundException fileNotFoundException) {
            DEBUG.Log(kDebugGroupId, "File not found: " + this.theConfigFileName + " " + fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            DEBUG.Log(kDebugGroupId, iOException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            DEBUG.Log(kDebugGroupId, classNotFoundException.toString());
        }
    }

    public Object readData(ComponentID componentID, String string) throws StorageEntryException {
        String string2 = new String(componentID.getID() + kIdSeparator + string);
        Object v = this.theStorageEntries.get(string2);
        if (v == null) {
            DEBUG.Log(kDebugGroupId, "ConfigEntry not found: " + string2);
            DEBUG.Trace("ConfigEntry not found: " + string2);
            throw new StorageEntryException();
        }
        return v;
    }

    public void writeData(ComponentID componentID, String string, Object object) throws StorageEntryException {
        String string2 = new String(componentID.getID() + kIdSeparator + string);
        this.theStorageEntries.put(string2, object);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.theConfigFileName));
            objectOutputStream.writeObject(this.theStorageEntries);
        }
        catch (IOException iOException) {
            DEBUG.Log(kDebugGroupId, iOException.toString());
            throw new StorageEntryException();
        }
    }

    public void removeData(ComponentID componentID, String string) throws StorageEntryException {
        String string2 = new String(componentID.getID() + kIdSeparator + string);
        Object v = this.theStorageEntries.remove(string2);
        if (v == null) {
            DEBUG.Log(kDebugGroupId, "Error removing item from permanent storage");
            throw new StorageEntryException();
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.theConfigFileName));
            objectOutputStream.writeObject(this.theStorageEntries);
        }
        catch (IOException iOException) {
            DEBUG.Log(kDebugGroupId, iOException.toString());
            throw new StorageEntryException();
        }
    }

    public Hashtable dumpData() {
        Hashtable hashtable = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.theConfigFileName));
            hashtable = (Hashtable)objectInputStream.readObject();
        }
        catch (Exception exception) {
            DEBUG.Log(kDebugGroupId, "dumpData exception", new StackTraceDebugModel(exception));
        }
        return hashtable;
    }
}

