/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.arch.event;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.ObjectIdTree;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.debug.DEBUG;
import com.apcc.m11.debug.util.StackTraceDebugModel;
import com.apcc.m11.ds.events.Group;
import java.util.Enumeration;
import java.util.Vector;

public class EventBus
implements IEventConsumer,
IEventProducer {
    public static final String kEventBusDebugGroup = "EventBus";
    private ObjectIdTree theEventConsumers = new ObjectIdTree();
    private Vector theConsumedEvents = new Vector();
    private Vector theEventProducers = new Vector();

    public void registerEventConsumer(IEventConsumer iEventConsumer) {
        if (iEventConsumer != null) {
            Enumeration enumeration = iEventConsumer.getConsumedEvents();
            while (enumeration.hasMoreElements()) {
                ObjectId objectId = (ObjectId)enumeration.nextElement();
                this.addEventConsumer(objectId, iEventConsumer);
                this.theConsumedEvents.addElement(objectId);
            }
        }
    }

    public void unRegisterEventConsumer(IEventConsumer iEventConsumer) throws RegistrationException {
        if (iEventConsumer != null) {
            Enumeration enumeration = iEventConsumer.getConsumedEvents();
            while (enumeration.hasMoreElements()) {
                ObjectId objectId = (ObjectId)enumeration.nextElement();
                this.removeEventConsumer(objectId, iEventConsumer);
                this.theConsumedEvents.removeElement(objectId);
            }
        }
    }

    public void registerEventProducer(IEventProducer iEventProducer) {
        if (iEventProducer != null) {
            this.theEventProducers.addElement(iEventProducer);
        }
    }

    public void unRegisterEventProducer(IEventProducer iEventProducer) {
        if (iEventProducer != null) {
            this.theEventProducers.removeElement(iEventProducer);
        }
    }

    public Enumeration getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>(1);
        vector.addElement(new ObjectId(Group.kOid));
        return vector.elements();
    }

    public void update(Event event) {
        Enumeration enumeration = this.theEventConsumers.findAllMatches(event.getObjectId());
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                IEventConsumer iEventConsumer = (IEventConsumer)enumeration2.nextElement();
                try {
                    iEventConsumer.update(event);
                }
                catch (Exception exception) {
                    StackTraceDebugModel stackTraceDebugModel = new StackTraceDebugModel(exception);
                    DEBUG.Log(kEventBusDebugGroup, "update failed", stackTraceDebugModel);
                    DEBUG.Trace("Update failed." + exception.toString());
                }
            }
        }
    }

    private void addEventConsumer(ObjectId objectId, IEventConsumer iEventConsumer) {
        Object object = this.theEventConsumers.findNode(objectId);
        if (object == null) {
            Vector<IEventConsumer> vector = new Vector<IEventConsumer>(1);
            vector.addElement(iEventConsumer);
            this.theEventConsumers.addNode(objectId, vector);
        } else {
            Vector vector = (Vector)object;
            Enumeration enumeration = vector.elements();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                if (!((IEventConsumer)enumeration.nextElement()).equals(iEventConsumer)) continue;
                bl = true;
            }
            if (!bl) {
                vector.addElement(iEventConsumer);
            }
        }
    }

    private void removeEventConsumer(ObjectId objectId, IEventConsumer iEventConsumer) throws RegistrationException {
        Object object = this.theEventConsumers.findNode(objectId);
        if (object == null) {
            throw new RegistrationException(2);
        }
        Vector vector = (Vector)object;
        while (vector.removeElement(iEventConsumer)) {
        }
        if (vector.size() == 0) {
            this.theEventConsumers.deleteNode(objectId);
        }
    }
}

