/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.arch.event;

import com.apcc.m11.arch.Formatters.TimestampFormatter;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.VariableBinding;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class Event
implements Serializable {
    private boolean theActiveFlag;
    private ObjectId theObjectId;
    private Vector theVariableBindings;
    private Date theTimestamp;
    private IFormatter theFormatter;
    private IFormatter theTimestampFormatter;

    public Event(ObjectId objectId) {
        this.theObjectId = objectId;
        this.theActiveFlag = true;
        this.theFormatter = null;
        this.initTimestamp();
    }

    public Event(ObjectId objectId, boolean bl) {
        this.theObjectId = objectId;
        this.theActiveFlag = bl;
        this.theFormatter = null;
        this.initTimestamp();
    }

    public Event(ObjectId objectId, IFormatter iFormatter) {
        this.theObjectId = objectId;
        this.theActiveFlag = true;
        this.theFormatter = iFormatter;
        this.initTimestamp();
    }

    public Event(ObjectId objectId, boolean bl, IFormatter iFormatter) {
        this.theObjectId = objectId;
        this.theActiveFlag = bl;
        this.theFormatter = iFormatter;
        this.initTimestamp();
    }

    public void addVariableBinding(VariableBinding variableBinding) {
        if (variableBinding != null) {
            if (this.theVariableBindings == null) {
                this.theVariableBindings = new Vector();
            }
            this.theVariableBindings.add(variableBinding);
        }
    }

    public ObjectId getObjectId() {
        return this.theObjectId;
    }

    public Enumeration getVariableBindings() {
        Enumeration enumeration = this.theVariableBindings != null ? this.theVariableBindings.elements() : new Vector(0, 0).elements();
        return enumeration;
    }

    public Date getTimestamp() {
        return this.theTimestamp;
    }

    public void setTimestamp(Date date) {
        this.theTimestamp = date;
    }

    public IFormatter getTimestampFormatter() {
        return this.theTimestampFormatter;
    }

    public boolean isActive() {
        return this.theActiveFlag;
    }

    public IFormatter getFormatter() {
        return this.theFormatter;
    }

    public String toString() {
        return new String("Event: " + this.theObjectId + " active: " + this.theActiveFlag);
    }

    private void initTimestamp() {
        this.theTimestamp = new Date();
        this.theTimestampFormatter = new TimestampFormatter();
    }
}

