/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.arch.datasource;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.ObjectIdTree;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataBus;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.IDataValidator;
import com.apcc.m11.arch.datasource.SetResult;
import java.util.Enumeration;
import java.util.Vector;

public class DataBus
implements IDataBus,
IDataSource {
    private ObjectIdTree theDataValidators = new ObjectIdTree();
    private Vector theValidatedOids = new Vector();
    private ObjectIdTree theDataSources = new ObjectIdTree();
    private Vector theSupportedOids = new Vector();

    public void registerDataSource(IDataSource iDataSource) throws RegistrationException {
        if (iDataSource != null) {
            Enumeration enumeration = iDataSource.getSupportedOids();
            while (enumeration.hasMoreElements()) {
                ObjectId objectId = (ObjectId)enumeration.nextElement();
                this.theDataSources.addNode(objectId, iDataSource);
                this.theSupportedOids.addElement(objectId);
            }
        }
    }

    public void unRegisterDataSource(IDataSource iDataSource) throws RegistrationException {
        if (iDataSource != null) {
            Enumeration enumeration = iDataSource.getSupportedOids();
            while (enumeration.hasMoreElements()) {
                ObjectId objectId = (ObjectId)enumeration.nextElement();
                this.theDataSources.deleteNode(objectId);
                this.theSupportedOids.removeElement(objectId);
            }
        }
    }

    public void registerDataValidator(IDataValidator iDataValidator) throws RegistrationException {
        if (iDataValidator != null) {
            Enumeration enumeration = iDataValidator.getValidatedOids();
            while (enumeration.hasMoreElements()) {
                ObjectId objectId = (ObjectId)enumeration.nextElement();
                this.theDataValidators.addNode(objectId, iDataValidator);
                this.theValidatedOids.addElement(objectId);
            }
        }
    }

    public void unRegisterDataValidator(IDataValidator iDataValidator) throws RegistrationException {
        if (iDataValidator != null) {
            Enumeration enumeration = iDataValidator.getValidatedOids();
            while (enumeration.hasMoreElements()) {
                ObjectId objectId = (ObjectId)enumeration.nextElement();
                this.theDataValidators.deleteNode(objectId);
                this.theValidatedOids.removeElement(objectId);
            }
        }
    }

    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = null;
        IDataSource iDataSource = this.findSpecificDatasource(objectId);
        if (iDataSource == null) {
            throw new InvalidObjectIdException(2);
        }
        getResult = iDataSource.get(objectId);
        return getResult;
    }

    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = null;
        IDataSource iDataSource = this.findSpecificDatasource(objectId);
        if (iDataSource == null) {
            throw new InvalidObjectIdException(2);
        }
        getResult = iDataSource.get(objectId, n);
        return getResult;
    }

    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        GetResult getResult = null;
        IDataSource iDataSource = this.findSpecificDatasource(objectId);
        if (iDataSource == null) {
            throw new InvalidObjectIdException(2);
        }
        getResult = iDataSource.get(objectId, object);
        return getResult;
    }

    public SetResult set(ObjectId objectId, Object object) throws InvalidValueException, InvalidObjectIdException, CommunicationException {
        Object object2;
        SetResult setResult = null;
        Enumeration enumeration = this.findDataValidators(objectId);
        boolean bl = true;
        while (bl && enumeration.hasMoreElements()) {
            object2 = (IDataValidator)enumeration.nextElement();
            if (object2.validate(objectId, object)) continue;
            bl = false;
        }
        if (bl) {
            object2 = this.findSpecificDatasource(objectId);
            if (object2 == null) {
                throw new InvalidObjectIdException(2);
            }
        } else {
            throw new InvalidValueException();
        }
        setResult = object2.set(objectId, object);
        return setResult;
    }

    public Enumeration getSupportedOids() {
        Enumeration enumeration = this.theDataSources != null ? this.theSupportedOids.elements() : new Vector(0, 0).elements();
        return enumeration;
    }

    private IDataSource findSpecificDatasource(ObjectId objectId) {
        IDataSource iDataSource = (IDataSource)this.theDataSources.findClosestMatch(objectId);
        return iDataSource;
    }

    private Enumeration findDataValidators(ObjectId objectId) {
        return this.theDataValidators.findAllMatches(objectId);
    }
}

