/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.arch;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.RegistrationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ObjectIdTree {
    private static final int kInitialHashtableCapacity = 3;
    private static final float kHashtableLoadFactor = 0.9f;
    private ObjectIdTreeNode theRoot = new ObjectIdTreeNode();

    public void addNode(ObjectId objectId, Object object) {
        ObjectIdTreeNode objectIdTreeNode = this.theRoot;
        Enumeration enumeration = objectId.getValue();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            ObjectIdTreeNode objectIdTreeNode2 = objectIdTreeNode.getChild(n);
            if (objectIdTreeNode2 == null) {
                ObjectIdTreeNode objectIdTreeNode3 = new ObjectIdTreeNode(objectIdTreeNode);
                objectIdTreeNode.addChild(n, objectIdTreeNode3);
                objectIdTreeNode = objectIdTreeNode3;
                continue;
            }
            objectIdTreeNode = objectIdTreeNode2;
        }
        objectIdTreeNode.setNodeValue(object);
    }

    public void deleteNode(ObjectId objectId) throws RegistrationException {
        Object object;
        ObjectIdTreeNode objectIdTreeNode = this.theRoot;
        Enumeration enumeration = objectId.getValue();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            object = (Integer)enumeration.nextElement();
            ObjectIdTreeNode objectIdTreeNode2 = objectIdTreeNode.getChild((Integer)object);
            if (objectIdTreeNode2 == null) {
                bl = true;
                continue;
            }
            objectIdTreeNode = objectIdTreeNode2;
        }
        if (!bl) {
            object = objectIdTreeNode.getParent();
            ((ObjectIdTreeNode)object).removeChild(objectIdTreeNode.getPosition());
            while (((ObjectIdTreeNode)object).numberOfChildren() == 0 && ((ObjectIdTreeNode)object).getNodeValue() == null && ((ObjectIdTreeNode)object).getParent() != null) {
                objectIdTreeNode = ((ObjectIdTreeNode)object).getParent();
                objectIdTreeNode.removeChild(((ObjectIdTreeNode)object).getPosition());
                object = objectIdTreeNode;
            }
        } else {
            throw new RegistrationException(2);
        }
    }

    public Object findNode(ObjectId objectId) {
        Object object = null;
        ObjectIdTreeNode objectIdTreeNode = this.theRoot;
        Enumeration enumeration = objectId.getValue();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            Integer n = (Integer)enumeration.nextElement();
            ObjectIdTreeNode objectIdTreeNode2 = objectIdTreeNode.getChild(n);
            if (objectIdTreeNode2 == null) {
                bl = true;
                continue;
            }
            objectIdTreeNode = objectIdTreeNode2;
        }
        object = !bl ? objectIdTreeNode.getNodeValue() : null;
        return object;
    }

    public Object findClosestMatch(ObjectId objectId) {
        Object object = null;
        ObjectIdTreeNode objectIdTreeNode = this.theRoot;
        if (objectId != null) {
            object = null;
            Enumeration enumeration = objectId.getValue();
            boolean bl = false;
            while (enumeration.hasMoreElements() && !bl) {
                Integer n = (Integer)enumeration.nextElement();
                ObjectIdTreeNode objectIdTreeNode2 = objectIdTreeNode.getChild(n);
                if (objectIdTreeNode2 == null) {
                    bl = true;
                    continue;
                }
                Object object2 = objectIdTreeNode2.getNodeValue();
                if (object2 != null) {
                    object = object2;
                }
                objectIdTreeNode = objectIdTreeNode2;
            }
        }
        return object;
    }

    public Enumeration findAllMatches(ObjectId objectId) {
        Vector<Object> vector = new Vector<Object>();
        ObjectIdTreeNode objectIdTreeNode = this.theRoot;
        if (objectId != null) {
            Object object = objectIdTreeNode.getNodeValue();
            if (object != null) {
                vector.addElement(object);
            }
            Enumeration enumeration = objectId.getValue();
            boolean bl = false;
            while (enumeration.hasMoreElements() && !bl) {
                Integer n = (Integer)enumeration.nextElement();
                ObjectIdTreeNode objectIdTreeNode2 = objectIdTreeNode.getChild(n);
                if (objectIdTreeNode2 == null) {
                    bl = true;
                    continue;
                }
                Object object2 = objectIdTreeNode2.getNodeValue();
                if (object2 != null) {
                    vector.addElement(object2);
                }
                objectIdTreeNode = objectIdTreeNode2;
            }
        }
        return vector.elements();
    }

    class ObjectIdTreeNode {
        private ObjectIdTreeNode theParent;
        private Integer thePosition;
        private Hashtable theChildren;
        private Object theNodeValue;

        public ObjectIdTreeNode() {
            this.theParent = null;
            this.theChildren = new Hashtable(3, 0.9f);
            this.theNodeValue = null;
        }

        public ObjectIdTreeNode(ObjectIdTreeNode objectIdTreeNode) {
            this.theParent = objectIdTreeNode;
            this.theChildren = new Hashtable(3, 0.9f);
            this.theNodeValue = null;
        }

        public ObjectIdTreeNode(ObjectIdTreeNode objectIdTreeNode, Object object) {
            this.theParent = objectIdTreeNode;
            this.theChildren = new Hashtable(3, 0.9f);
            this.theNodeValue = object;
        }

        public void setParent(ObjectIdTreeNode objectIdTreeNode) {
            this.theParent = objectIdTreeNode;
        }

        public ObjectIdTreeNode getParent() {
            return this.theParent;
        }

        public void setPosition(Integer n) {
            this.thePosition = n;
        }

        public Integer getPosition() {
            return this.thePosition;
        }

        public void addChild(Integer n, ObjectIdTreeNode objectIdTreeNode) {
            objectIdTreeNode.setPosition(n);
            this.theChildren.put(n, objectIdTreeNode);
        }

        public void removeChild(Integer n) {
            this.theChildren.remove(n);
        }

        public ObjectIdTreeNode getChild(Integer n) {
            return (ObjectIdTreeNode)this.theChildren.get(n);
        }

        public int numberOfChildren() {
            return this.theChildren.size();
        }

        public void setNodeValue(Object object) {
            this.theNodeValue = object;
        }

        public Object getNodeValue() {
            return this.theNodeValue;
        }
    }
}

