/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public class RC2ParameterSpec
implements AlgorithmParameterSpec {
    private byte[] a;
    private int b;

    public RC2ParameterSpec(int n2) {
        this.b = n2;
    }

    public RC2ParameterSpec(int n2, byte[] byArray) {
        this(n2, byArray, 0);
    }

    public RC2ParameterSpec(int n2, byte[] byArray, int n3) {
        this.b = n2;
        if (byArray == null) {
            throw new IllegalArgumentException("IV missing");
        }
        int n4 = 8;
        if (byArray.length - n3 < n4) {
            throw new IllegalArgumentException("IV too short");
        }
        this.a = new byte[n4];
        System.arraycopy(byArray, n3, this.a, 0, n4);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RC2ParameterSpec)) {
            return false;
        }
        RC2ParameterSpec rC2ParameterSpec = (RC2ParameterSpec)object;
        return this.b == rC2ParameterSpec.b && Arrays.equals(this.a, rC2ParameterSpec.a);
    }

    public int getEffectiveKeyBits() {
        return this.b;
    }

    public byte[] getIV() {
        if (this.a != null) {
            return (byte[])this.a.clone();
        }
        return null;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.a != null) {
            int n3 = 1;
            while (n3 < this.a.length) {
                n2 += this.a[n3] * n3;
                ++n3;
            }
        }
        return n2 += this.b;
    }
}

