DISPLAY OFF
#
#  Ŀ
#                                                                    
#     XA - X10 Command Interpreter for the CP-290 - Version 3.2      
#    Copyright 1991-1996 by Bruce Christensen. All Rights Reserved.  
#                                                                    
#  
#
#
#
#
#    IF NONE OF THIS MAKES SENSE....
#                                   ....READ THE MANUAL (XA_320.TXT)
#
#
#
#
#
# You can pass arguments to a command file and have XA react accordingly. 
# If you pass a non-zero variable and test it with the IF statement, it will 
# result in a TRUE condition. For example:
#       XA f=xa.cmd "override = 1"
# 
# Note that the user-defined variable 'override' has been previously 
# declared in XA.INI. If it wasn't, then an error message would have
# been displayed. 
#
# The following example demonstrates the use of XA's Non-Volatile variables.
# NVOL1 is one of 20 non-volatile variables (a variable whose value is
# remembered from session to session) that is retained in the CP-290 battery-
# backed memory.  We've assigned NVOL1 to reflect the NEXT UPDATE when XA
# should send a new weekly event schedule to the CP-290.  (See XA.INI, 
# DEFINE NEXT_UPDATE NVOL1).
#
# If it's been a week or more since we last sent the contents of this file
# to the CP-290, then update the schedule.  Otherwise, exit this file (STOP).
# We can "override" XA's date calculation by setting "override" to 1 when
# we call XA, as is described above.

DISPLAY ON
IF ((CDATE < NEXT_UPDATE) AND (OVERRIDE == 0) AND NEXT_UPDATE)
  DISPLAY CP-290 DOES NOT NEED TO BE UPDATED.  Exiting...
  STOP
ENDIF
NEXT_UPDATE = CDATE + 7       # Set NVOL1 = NEXT WEEK
DISPLAY OFF
#
#
#
#    Produce a report file listing events for each day. Use REPORT1 to
#    generate a listing events in the order they occur for each day. 
#    Use REPORT2 to list events for each day by module.

REPORT1

#  
#
#
#    The next token (ERASE) will remove all events from the CP-290
#    memory. You are advised to use this when you use the DATE token for
#    programming specific events. This ensures that when the event has
#    passed, it will be deleted. Since every one of your events should
#    be included in this file, there is no need to worry about erasing them
#    now...they will be downloaded automatically.

ERASE

#
#
#
#    Set the X10 clock to the time and date of your PC's internal clock.
#    Use the optional "EXACT" token to wait for the seconds counter to
#    rollover to 0.

SYNCHRONIZE X10 EXACT

#
#
#
#    Set the PC clock to the time of your X10's internal clock.
#    Use the optional "EXACT" token to wait for the seconds counter to
#    rollover to 0.
#
#    Note: There is not enough information from the X10 to set the date.

#SYNCHRONIZE PC EXACT

#
#
#
#    The following are a set of commands that are downloaded weekly. See the
#    documentation for full details - but here's a synopsis:
#    Every Sunday morning at 3:00, the computer is turned on via X10. As
#    DOS executes AUTOEXEC.BAT, a utility supplied with this package,
#    POWERUP.EXE will return an ERRORLEVEL of 1 if the current time is
#    within a range that you specify. This errorlevel can then be used to 
#    invoke XA.EXE to download another weeks worth of events, or you can use
#    it to call other programs as well, for instance: backup programs, 
#    communications, etc. See the documentation for more details.
#    
#    Note the use of the SUNRISE and SUNSET tokens. These tokens will 
#    calculate the exact time of sunrise or sunset for your city assuming 
#    LATITUDE, LONGITUDE, and TIMEZONE were all entered correctly. 
#    This avoids having to constantly enter a new time for your outdoor lights.

DISPLAY ON

# DAILY EVENTS

LR1 FAMILY_ROOM_LAMP     ON  EVERYDAY SUNSET OFFSET -1:00
LR2                      ON  EVERYDAY SUNSET RANDOM   :10 EXPAND
LR1 FAMILY_ROOM_LAMP LR2 OFF SUN MON TUE WED THU    11:30 PM
LR1 FAMILY_ROOM_LAMP LR2 OFF SAT SUN                12:30 AM

FRONT_PORCH DIM 80  EVERYDAY SUNSET EXPAND EXCEPT THANKSGIVING THRU NEW_YEARS_DAY
FRONT_PORCH OFF     EVERYDAY 10:35 PM RANDOM +15 EXPAND

#
# Schedule an 'Artificial Sunrise' around wakeup time but only
# when we wakeup before dawn.
#
IF (WAKEUP_TIME < DAWN)
  BEDROOM_LIGHT BRIGHTEN 1 5:25 WEEKDAYS except DAY_AFTER_BOWLING
  BEDROOM_LIGHT BRIGHTEN 1 5:26 WEEKDAYS except DAY_AFTER_BOWLING
  BEDROOM_LIGHT BRIGHTEN 1 5:27 WEEKDAYS except DAY_AFTER_BOWLING
  BEDROOM_LIGHT BRIGHTEN 1 5:28 WEEKDAYS except DAY_AFTER_BOWLING
  BEDROOM_LIGHT BRIGHTEN 1 5:29 WEEKDAYS except DAY_AFTER_BOWLING
  BEDROOM_LIGHT BRIGHTEN 1 5:30 WEEKDAYS except DAY_AFTER_BOWLING
  BEDROOM_LIGHT BRIGHTEN 1 5:31 WEEKDAYS except DAY_AFTER_BOWLING
  BEDROOM_LIGHT BRIGHTEN 1 5:32 WEEKDAYS except DAY_AFTER_BOWLING
  BEDROOM_LIGHT BRIGHTEN 1 5:33 WEEKDAYS except DAY_AFTER_BOWLING
  BEDROOM_LIGHT BRIGHTEN 1 5:34 WEEKDAYS except DAY_AFTER_BOWLING
ENDIF
BEDROOM_LIGHT OFF    EVERYDAY SUNRISE + 2:00 
BEDROOM_LIGHT DIM 50 EVERYDAY 10:30 PM RANDOM +15 EXPAND

#
# Activate the automatic plant watering system every 5 days.
#
PLANT_WATERING          ON      SUNRISE EVERY 3 DAYS
PLANT_WATERING          OFF     SUNRISE OFFSET 30 EVERY 3 DAYS

# Use the X10 Chime modules in the basement and garage to announce 
# the time at the top of the hour. 
# Use IF/ELSE logic, variables, arithmetic and boolean logic to 
# program the module between specific hours....

DISPLAY OFF
declare time time_var = 8:00
:hourly_loop
DISPLAY ON
HOURLY_CHIME ON time_var EVERYDAY EXCEPT THANKSGIVING THRU NEW_YEARS_DAY
DISPLAY OFF
time_var = time_var + 1:00
if (time_var <= 10:00 PM)
  goto :hourly_loop
endif
DISPLAY ON


DEHUMIDIFIER    ON     EVERYDAY ON   6:00 AM
DEHUMIDIFIER    OFF    EVERYDAY OFF 12:00 PM
DEHUMIDIFIER    ON     EVERYDAY ON  SUNSET 
DEHUMIDIFIER    OFF    EVERYDAY OFF SUNSET OFFSET 6:00 

DECK            ON     SUNSET 4/1 THRU 10/31 EXPAND
DECK BACK_PORCH DIM 50 DUSK   4/1 THRU 10/31 EXPAND
DECK BACK_PORCH OFF    SUNSET OFFSET 1:30  4/1 THRU 10/31 EXPAND

#
# These lights act as "nightlights". They are re-activated
# several times during the evening in case someone manually
# overrides their programmed setting.
#
HALLWAY STAIRS  DIM 40  EVERYDAY SUNSET EXPAND
HALLWAY STAIRS  DIM 25  EVERYDAY 10:30 PM RANDOM 15 EXPAND
HALLWAY STAIRS  DIM 25  EVERYDAY 11:30 PM RANDOM 15 EXPAND
HALLWAY STAIRS  OFF     EVERYDAY SUNRISE EXPAND


#
# Seasonal Lighting
#
FRONT_PORCH       DIM 45 SUNSET OFFSET 15 THANKSGIVING THRU NEW_YEARS_DAY EXPAND
CHRISTMAS_LIGHTS  ON  SUNSET OFFSET 20 THANKSGIVING THRU NEW_YEARS_DAY
XMAS_RED          ON  SUNSET OFFSET 25 THANKSGIVING THRU NEW_YEARS_DAY MON WED FRI SUN
XMAS_GREEN        ON  SUNSET OFFSET 25 THANKSGIVING THRU NEW_YEARS_DAY SAT TUE THU
XMAS_BLUE         ON  SUNSET OFFSET 25 THANKSGIVING THRU NEW_YEARS_DAY SAT TUE THU
XMAS_WHITE        ON  SUNSET OFFSET 25 THANKSGIVING THRU NEW_YEARS_DAY MON WED FRI SUN
CHRISTMAS_LIGHTS  OFF 10:45 PM THANKSGIVING THRU NEW_YEARS_DAY RANDOM 15 EXPAND
GHOST_LIGHTS      ON  SUNSET +0:15  10/27 THRU 10/31 EXPAND
GHOST_LIGHTS      OFF 10:00 PM 10/27 THRU 10/31
XMAS_RED          OFF 10:45 PM THANKSGIVING THRU NEW_YEARS_DAY RANDOM 15 EXPAND
XMAS_GREEN        OFF 10:45 PM THANKSGIVING THRU NEW_YEARS_DAY RANDOM 15 EXPAND
XMAS_BLUE         OFF 10:45 PM THANKSGIVING THRU NEW_YEARS_DAY RANDOM 15 EXPAND
XMAS_WHITE        OFF 10:45 PM THANKSGIVING THRU NEW_YEARS_DAY RANDOM 15 EXPAND

#
#
#
# The following event occurs every Sunday at 3:00 AM.
# When used in conjuction with POWERUP.EXE (in AUTOEXEC.BAT)
# we can automatically download new commands an a weekly basis.
# For example, sunrise and sunset change from day to day. The X10
# computer interface can store these times for 1 week, then it
# needs to be updated with new times.
#
# Additional note: Backups are now performed during this time, as
#      well as having all the drives optimized. See the sample 
#      AUTOEXEC.BAT file supplied with this package.
#
#
# Note: The sample AUTOEXEC.BAT contains the command: XA "PC OFF"
# after the download, optimizations, and backups have been performed.
# But just in case something went wrong (like leaving a floppy in Drive A),
# we'll have the CP-290 turn the computer off 4 hours later.

COMPUTER ON  SUNDAY  3:00
COMPUTER OFF SUNDAY  7:00

#
# Turn ON various lights around 5:30 am on weekdays only when it's still
# dark outside. The following conditional statement checks to see if 
# sunrise occurs after 6:20 am. During the winter months, this condition
# will be true so the lights will be scheduled. During the summer, the sun 
# will have risen, so the lights are not needed.
#
#
IF (SUNRISE > 6:00)
  FRONT_PORCH      DIM 80  WEEKDAYS  5:30 RANDOM 10
  FRONT_PORCH      OFF     WEEKDAYS  SUNRISE
  LR1              ON      WEEKDAYS  5:35 RANDOM 10
  LR1              OFF     WEEKDAYS  SUNRISE + 3:00
  FAMILY_ROOM_LAMP ON      WEEKDAYS  6:10 RANDOM 15
  FAMILY_ROOM_LAMP OFF     WEEKDAYS  SUNRISE + 2:00
ENDIF


#
# Turn all X10 modules off @ 2:30 AM everyday.  
HOUSE A ALL_UNITS_OFF EVERYDAY 2:30



#
# Increment a counter that tells us how many times we've run this file.
# NOTE: NVOL20 must not be altered by other *.CMD files.  That is,
#       keep it reserved for use only be XA.CMD.
#

NVOL20 = NVOL20 + 1


# That's all folks.
