/*
 *   This file is a part of uuhydra, a replacment for Waffle's uucico
 *
 *   Copyright (C) 1993  Erik Bos (erik@trashcan.hacktic.nl)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define TRUE  1
#define FALSE 0

#define UnknownSystem   0
#define UnknownProtocol 1
#define OnePacket       2
#define MultiplePackets 3

#define NoExit     0
#define Exit_Fatal 1
#define Exit_Retry 2

#define NScriptCmds    10
#define ValueLength    80
#define PathLength     MAXPATH
#define TempDirectory  "temp"

#define NAME          "UUHydra"
#define VERSION       "0.67"
#define CONFIGFILE    "uuhydra.cfg"
#define LOGFILE       "uuhydra.log"

extern void Help(void);
extern void Poll(char *);
extern void Receive(char *);
extern void PackMail(char *);
extern int GetString(char *,char *);
extern void ParseScript(char *,int);
extern void StartProtocol(char *);
extern int CheckProtocol(char *);
extern void DeleteFiles(char *);
extern void Move(char *,char *);
extern char *CreateUniqueName(char *);
extern char *CreateMailName(char *,int);
extern void CreateMailPacket(char *,int);
extern void KillMail(char *);
extern int ChangeDir(char *);
extern char *NukeName(char *);
extern void RenameFiles(void);
extern void EndProgram(void);
extern int control_break(void);
extern int GetStaticVar(FILE *,char *,char *);
extern void AsyncRxFlush(int);
extern int AsyncGets(int ,char *,long,int);
extern int AsyncPuts(int ,char *);
extern int AsyncWatch(int,char *,char *,char *,long ,int);
extern void HangUpModem(int);
extern void String_GetValues(char *,char *,char *);
extern void String_Clean(char *);
extern void String_UpperCase(char *);
extern int ReadConfig(char *);
extern void Execute(char *);
extern void OpenLog(void);
extern void CloseLog(void);
extern void WriteLog(char *,int);
