#!perl -w
# Suspected bug - somewhere somehow lost (losing?) initial lines with
# mail 01 delimiters.
#---
#To do	- Log very bad events in a log file.
#	- return message in replies ($bounce - not yet implemented)
#	- Move NoSpam files to user subdirectory.
#=============================================================================
# NoSpam: a Waffle junk e-mail filter
# Copyright 1997, by William Swan
# All Rights Reserved
#
# Alpha Test Version 1.0
#
# Warning:  This software is undergoing testing and further development; it is
# is being distributed solely for experimental purposes and as a model for
# similar filters for other e-mail systems.  Using it on a real Waffle account
# could cause the loss of wanted e-mail.
#
# Post comments, improvements, bugfixes, etc. to comp.bbs.waffle
#
#=============================================================================
#
#Usages:
#
#Processing outgoing mail:
#  nospam -n<login> -d [-o] [-v]
#	-n<login>:	User's login name.
#	-d:		Look for new e-mail destinations.
#	-o:		Show Option settings.
#	-v:		Verbose mode.
#
#Processing mailbox after incoming e-mail:
#  nospam -n<login> [-s] [-p<hours>] [-r<retries>] [-b] [-o] [-v]
#	-n<login>:	User's login name.
#	-s:		Save presumed spam in mailbox folder SPAM.
#	-r<retries>	Number of retires a probationer gets.
#	-b		Bounce - not implemented yet.
#	-o:		Show Option settings.
#	-v:		Verbose mode.
#
#-----------------------------------------------------------------------------
#
#		Definitions and initializations
#
#-----------------------------------------------------------------------------


# Operational flags and parameters:

# Mandatory parameters:
$username      = "";		# -n User's login name.

# Outgoing e-mail destination checking:
$newdest       = 0;

# Incoming e-mail processing parameters and flags:
$savespam      = 0;		# -s Save presumed spam (1) or not(0).
$probationtime = 72;		# -p Hours probationer has in which to respond.
$senderretries = 2;		# -r Number of retries probationer gets.
$bounce        = 0;             # -b Bounce rejected mail back.

# Optional flags:
$showopts      = 0;		# -o show option settings.
$verbose       = 0;		# -v Yak about what's being done (1), or not (0).


# File name definitions:

$MailBox_Orig = "mailbox.f";	# User's mailbox file.
$MailBox_Bak  = "mailbox.bak";	# User's mailbox file backup.
$MailBox_New  = "mailbox.new";	# Filtered mailbox file.
$SpamBox      = "spam.f";	# Diverted (spam) file.
$ProbFile     = "nospam.pro";	# Probation File.
$ProbFile_Bak = "nospam.pr1";	# Probation File Backup.
$RegFile      = "nospam.reg";	# Registry File (known sender, one per line).
$RegFile_Bak  = "nospam.re1";	# Registry File Backup. */
$KeyFile      = "nospam.key";	# Key File (list of keys, one per line).
$MsgFnames    = "nospam.m*";	# Message file prototypes.
$MsgFSpec     = "nospam.m%02d"; # Message File Spec.
$OKMsgFname   = "nospam.ok";	# Welcome message file prototype.
$Mailer_Bat   = "mailspam.bat";	# Mailer Batch File.
$MailFSpec    = "mailspam.%03d";# Outgoing mail to be sent by $Mailer_Bat.
$TempFile     = "nospam.tmp";	# A temporary file!
$XqtFSpec     = "*.XQT";	# Waffle outgoing XQT files.
$StaticFile = $ENV{"WAFFLE"};	# Waffle's STATIC (parameters) file.

# Global lists and arrays:
#
# Probation List:
# problist contains a list of contacts who are on probation; they have
# attempted to send mail to this user, but they were unregistered.  The
# key is the e-mail address, record data is as follows:
#   key: sender's e-mail address	newcontact@here.com
#   [0]: name of message file sent	nospam.m01
#   [1]: text of key			iuchar
#   [2]: number of retries left		0
#   [3]: date and time entry expires	1999/12/31 23:59:59
# This data is stored on file tab-delimited format.

@keylist  = ( );		# List of keys for probationer.
%problist = ( );		# List of probation records.
%reglist  = ( );		# List of registered senders.


$nextreplynum = 0;		# Outgoing $MailFspec, range 000..999
@msgfilenames = ( );		# List of names of message file
$msgfilect    = 0;

# Global Variables

$problistchanged = 0;		# Probation list changed
$registrychanged = 0;		# List of registered senders changed
$wrotespam  = 0;

$waffleroot    = "c:\waffle\\";	# Waffle root directory.
$spoolroot     = "c:\spool\\";	# Spool root directory.
$useraddr      = "a\@z";	# User's e-mail address.
$userdir       = "";		# User's directory.

# Constants

$RightNow        = gettimestring(0);
$MatchAddr       = '([A-Za-z0-9_\.%!\-]+[!@][A-Za-z0-9_\.%!\-]+)';
$RebuildIndexCmd = "makebox -i $MailBox_Orig\n";	# Waffle 1.65 command
$RebuildSpamCmd  = "makebox -i $SpamBox\n";	# Waffle 1.65 command

#-----------------------------------------------------------------------------
#
# 		Execution section
#
#-----------------------------------------------------------------------------

		#--- Pick up command line arguments.

while ($_ = $ARGV[0])
  {
  shift;
  last if /^--$/;
  if (/^-n(.*)/)  { $username      = $1; }
  if (/^-d/)      { $newdest       = 1; }
  if (/^-s/)      { $savespam      = 1; }
  if (/^-p(\d*)/) { $probationtime = eval("$1"); }
  if (/^-r(\d*)/) { $senderretries = eval("$1"); }
  if (/^-b/)      { $bounce        = 1; }
  if (/^-o/)      { $showopts      = 1; }
  if (/^-v/)      { $verbose       = 1; }
  }

if ( $showopts )
  {
  print "User name:              $username\n";
  print "New destination checks: $newdest\n";
  print "Save Spam:              $savespam\n";
  print "Probation:              $probationtime hours\n";
  print "Retries:                $senderretries\n";
  print "User directory:         $userdir\n";
  print "Show Options:           $showopts\n";		#:-)
  print "Verbose mode:           $verbose\n";
  }

if ( $verbose ) { warn "Executing at $RightNow \n"; }

srand();

if ( $username eq "" ) { die "Must specify -n[username]; aborting.\n"; }

		# --- Get user directory from the Waffle STATIC file.

if ( $StaticFile eq "" )
  {
  die "Environment variable WAFFLE must be set; check Waffle docs. Aborting.\n";
  }

open(StaticFile, "<$StaticFile")
  or die "Couldn't open the Waffle STATIC file ($StaticFile); aborting.\n";

while (<StaticFile>)
  {
  my($line) = $_;
  chomp ($line);

  if ( $line =~ m/^user:\s+([^\s]+)/i )
    {
    $userdir = $1;
    if ( $userdir !~ m/.+[\/\\]$/ ) { $userdir = "$userdir\\"; }
    $userdir = $userdir . $username;
    if ( $verbose ) { warn "Setting user directory to $userdir.\n"; }
    }

  if ( $line =~ m/^node:\s+([^\s]+)/i )
    {
    $useraddr = "$username\@$1";
    if ( $verbose ) { warn "Setting username to $username.\n"; }
    }

  if ( $line =~ m/^waffle:\s+([^\s]+)/i )
    {
    $waffleroot = $1;
    if ( $waffleroot !~ m/.+[\/\\]$/ ) { $waffleroot = "$waffleroot\\"; }
    }

  if ( $line =~ m/^spool:\s+([^\s]+)/i )
    {
    $spoolroot = $1;
    if ( $spoolroot !~ m/.+[\/\\]$/ ) { $spoolroot = "$spoolroot\\"; }
    }
  }

close(StaticFile);

if ( $userdir ne "" )
  {
  if ( $verbose ) { warn "Changing to directory $userdir.\n"; }
  chdir ($userdir);
  }

		#--- If the registry doesn't exist, create a new one and quit.

if ( $verbose ) { warn "Checking registry file $RegFile.\n" }
if ( ! -e $RegFile )
  {
  if ( -e $RegFile_Bak )
    {
    warn "Registry file $RegFile lost, restoring from backup $RegFile_Bak.\n";
    rename($RegFile_Bak, $RegFile);
    }
  else
    {
    warn "Registry file $RegFile doesn't exist; creating new one from mailbox.\n";
    if ( open(MAILBOX_ORIG, "<$MailBox_Orig") )
      {
      if ( $verbose ) { warn "Adding senders:\n"; }
      while ( 1 )
        {
        my($sender) = &get_sender;
        if ( $sender eq "" ) { last };
        if ( $verbose ) { warn "  $sender\n"}
        $reglist{$sender} = [$RightNow];
        }
      close(MAILBOX_ORIG);
      }
    &write_registry();
    die "New registry created.\n";
    }
  }

		#--- Read in the registry file.

if ( $verbose ) { warn "Opening registry file $RegFile and reading.\n" }
open(REGFILE, "<$RegFile")
  or die "Couldn't open registry file $RegFile.\n";
while (<REGFILE>)
  {
  my($entry) = $_;
  chomp ($entry);
  ( my($sender), my($timestamp) ) = split(/\t/, $entry);
  if ( !defined($timestamp) ) { $timestamp = $RightNow; }
  $reglist{$sender} = [$timestamp];
  }
close(REGFILE);

if ( !$newdest  &&  !%reglist )
  {
  warn "Registry list has no entries.  This is probably an error.\n";
  }

		#--- If new dest checking, search UUCP XQT files and quit.
if ( $newdest )
  {
  if ( $verbose ) { warn "Checking outgoing files for $username.\n";  }

  			#--- Read in the SYSTEMS file to get all neighbors.

  my $SystemsFile = "$waffleroot\\uucp\\systems";
  my @systems = ( );
  if ( $verbose ) { warn "Reading file $SystemsFile.\n";  }

  open(SYSTEMSFILE, $SystemsFile)
    or die "Couldn't open Waffle's SYSTEMS file $SystemsFile.\n";
  while ( <SYSTEMSFILE> )
    {
    my $line = $_;
    if ( $line =~ m/^([^#\s][^\s]*)\s/ )
      {
      push (@systems, $1);
      }
    }
  close(SYSTEMSFILE);

			#--- Examine XQT files queued for each neighbor.

  while ( defined ( $system = pop(@systems) ) )
    {
    my $fnamespec = "$spoolroot$system\\$XqtFSpec";
    @xqtfnames = glob ($fnamespec);

    while ( defined ( $xqtfile = pop(@xqtfnames) ) )
      {
      my $un = "";
      my $ra;

      if ( $verbose ) { warn "Checking XQT file $xqtfile.\n";  }
      open(XQTFILE, "<$xqtfile")
        or die "Couldn't open XQT file $xqtfile.\n";
      while (<XQTFILE>)
        {
        my($line) = $_;
        chomp ($line);
        if ( $line =~ m/^U ([^\s]+) / )      { $un = $1; }
        if ( $line =~ m/^C rmail ([^\s]+)/ ) { $ra = $1; }
        }
      close(XQTFILE);

			#--- If sender correct, add unregistered destination.

      if ( $un eq $username )
        {
        if ( ! exists($reglist{$ra}) )
	  {
          if ( $verbose ) { warn "Adding destination $ra.\n";  }
          $reglist{$ra} = [$RightNow];
  	  $registrychanged = 1;

	  # Note: One could also check for entry in the probation list and
	  # delete that, but that will expire naturally.  Registration
	  # overrides probation in any event.
          }
	} # end if ( correct user )
      } # end while (xqtfile)
    } # end while (system)

  if ( $registrychanged )
    {
    &write_registry();
    }
  exit;
  }
		#--- Look for mailbox file, attempting recovery upon failure.

if ( $verbose ) { warn "Looking for mailbox file $MailBox_Orig.\n" }
if ( ! -r $MailBox_Orig )
  {
  warn "Couldn't find $MailBox_Orig, attempting recovery: ";
  if ( rename($MailBox_Bak, $MailBox_Orig) )
    {
    warn "Restored from $MailBox_Bak.\n"
    }
  else
    {
    if ( rename($MailBox_New, $MailBox_Orig) )
      {
      warn "Restored from $MailBox_New.\n"
      }
    else
      {
      warn "Couldn't restore it at all!\n";
      exit;
      }
    }
  } # endif (couldn't open mailbox )

		#--- Open new mailbox file to receive filtered e-mail.

if ( $verbose ) { warn "Opening new mailbox file $MailBox_New.\n" }
unlink($MailBox_New);
open(MAILBOX_NEW, ">$MailBox_New")
  or die "Couldn't open new mailbox file $MailBox_New.\n";

		#--- Read in the keys file.

if ( $verbose ) { warn "Opening file $KeyFile to read in keys.\n" }
open(KEYFILE, "<$KeyFile")
  or die "Couldn't open key file $KeyFile.\n";
while (<KEYFILE>)
  {
  my($key) = $_;
  chomp ($key);
  if ( $key =~ m/\"/ )
    {
    warn "Key $key discarded - double-quote is illegal.\n";
    }
  else
    {
    push (@keylist, $key);
    }
  }
close(KEYFILE);

if ( !defined( $keylist[0]) )
  {
  die "Key list has no entries!\n";
  }
if ( $verbose ) { print "Keys:\n  ",join("\n  ",@keylist),"\n"; }

		#--- Read list and number of message file names.

if ( $verbose ) { print "Reading list of message file names.\n"; }
@msgfilenames = glob ($MsgFnames);
$msgfilect = $#msgfilenames;
if ($msgfilect == 0)
  {
  die "Too few message files!  Create more.\n";
  }
if ( $verbose ) { print "Message Files:\n  ",join("\n  ",@msgfilenames),"\n"; }

		#--- Create the rmail-invoking batch file.

if ( $verbose ) { print "Opening mailer batch file $Mailer_Bat.\n"; }
if ( !open(MAILER_BAT, ">>$Mailer_Bat") )
  {
  die "Couldn't open $Mailer_Bat for writing or appending.\n";
  }
# print MAILER_BAT "dir /w\n";

		#--- Open a mailfile to receive spam, if desired.

if ( $savespam)
  {
  if ( $verbose ) { print "Opening spam file $SpamBox.\n"; }
  if ( !open(SPAMBOX, ">>$SpamBox") )
    {
    die "Couldn't open $SpamBox for writing or appending.\n";
    }
  }

		#--- Read in unexpired probation records.

if ( $verbose ) { warn "Opening probationers file $ProbFile and reading.\n" }
if ( !-e $ProbFile )
  {
  warn "File $ProbFile not found, attempting to restore from $ProbFile_Bak.\n";
  rename ($ProbFile_Bak, $ProbFile);
  }
if ( open(PROBFILE, "<$ProbFile") )
  {
  while (<PROBFILE>)
    {
    my($entry) = $_;
    chomp ($entry);
    ( my($sender), my($fname), my($key), my($retries), my($expire) ) =
      split(/\t/, $entry);
    if ( $expire gt $RightNow )
      {
      $problist{$sender} = [$fname, $key, $retries, $expire];
      }
    else
      {
      $problistchanged = 0;		# Probation list changed
      }
    }
  close(PROBFILE);
  }
else
  {
  warn "Couldn't open probationers file $ProbFile.\n";
  }

if ( !%problist )
  {
  warn "Probation list has no entries.  This is probably okay, O Lucky One.\n";
  }
else
  {
  if ( $verbose )
    {
    warn "Probation list entries:\n";
    foreach $sender (sort(keys(%problist)))
      {
      warn "  $sender\t".join("\t", @{$problist{$sender}} ), "\n";
      }
    }
  }
		#--- Open mailbox file for reading.

if ( $verbose ) { warn "Opening mailbox file $MailBox_Orig.\n" }
open(MAILBOX_ORIG, "<$MailBox_Orig")
  or die "Couldn't open mailbox file $MailBox_Orig.\n";

		#--- Use the registry to filter the e-mail in MAILBOX_ORIG.

if ( $verbose ) { warn "Processing e-mail...\n"; }
my($state) = 0;
my($sendaddr) = "";
my(@Header) = ( );
while (<MAILBOX_ORIG>)
  {
  my($curline) = $_;
  chomp($curline);

#  state 0:	(Looking for tag, dropping message)
#    if (curline has tag)
#      remove curline text preceding tag
#      save (push) curline to list
#      state = 1

  if ( $state == 0 )
    {
    $sendaddr = "";
    if ( $curline =~ m/(.*)(\001\001\001\001.*)/ )
      {
      push(@Header, $2);
      $state = 1;
      }
    }

#  state 1:	(looking for From: line)
#    if (curline has tag)
#      clear list
#      remove curline text preceding tag
#      save (push) curline to list
#    else if (From: not at beginning of line)
#      save (push) curline to list
#    else if (sendaddr extracted from curline)
#      if (sendaddr in registerlist)
#        write (pop) list to newfile
#        write curline to newfile
#        state = 2
#      else if (sendaddr in probationlist)
#        write (push) curline to list
#        sender = sendaddr
#        state = 3
#      else	(unknown to us)
#        generate registration parms
#        send message to sendaddr
#        add sendaddr,parms to probationlist
#        if (savespam)
#          write (pop) list to spamfile
#          write curline to spamfile
#          state = 5
#        else
#	  clear list
#	  state = 0
#    else	(From: line damaged)
#      state = 0

  elsif ( $state == 1 )
    {
    $sendaddr = "";
    if ( $curline =~ m/(.*)(\001\001\001\001.*)/ )
      {
      @Header = ( );
      push(@Header,$2);
      }
    elsif ( $curline !~ m/^From: / )
      {
      push(@Header, $curline);
      }
    elsif ( $curline =~ m/$MatchAddr/ )
      {
      $sendaddr = $1;
      if ( exists($reglist{$sendaddr}) )
	{
        if ( $verbose )
           {
           warn "Accepting message from registered sender $sendaddr.\n";
           }
	print MAILBOX_NEW join("\n",@Header),"\n";
	@Header = ( );
	print MAILBOX_NEW "$curline\n";
	$state = 2;
	}
      elsif ( exists($problist{$sendaddr}) )
        {
        if ( $verbose )
          {
          warn "Checking message from probationed sender $sendaddr.\n";
          }
        push(@Header, $curline);
        $state = 3;
        }
      else	# unknown to us
        {
        if ( $verbose )
          {
          warn "Got message from unknown sender $sendaddr.\n";
          }
        push(@Header, $curline);
        &newprobationer($sendaddr);
	if ( $savespam )
	  {
	  $wrotespam = 1;
  	  print SPAMBOX join("\n",@Header),"\n";
          @Header = ();
          $state = 5;
          }
        else
          {
          @Header = ();
          $state = 0;
          }
	}
      }
    else	# From: line damaged
      {
      $state = 0;
      }
    }

#  state 2:	(mail from registered sendaddr)
#    if (curline has tag)
#      save curline text preceding tag to newfile
#      remove curline text preceding tag
#      save (push) curline to list
#      state = 1
#    else
#      save curline to newfile

  elsif ( $state == 2 )
    {
    if ( $curline =~ m/(.*)(\001\001\001\001.*)/ )
      {
      print MAILBOX_NEW "$1\n";
      push(@Header,$2);
      $state = 1;
      }
    else
      {
      print MAILBOX_NEW "$curline\n";
      }
    }

#  state 3:	(save header from probationed sendaddr)
#    if (curline has tag)
#      clear list
#      remove curline text preceding tag
#      save (push) curline to list
#      state = 1
#    else if (curline empty)
#      save (push) curline
#      state = 4
#    else
#      save (push) curline

  elsif ( $state == 3 )
    {
    if ( $curline =~ m/(.*)(\001\001\001\001.*)/ )
      {
      @Header = ( );
      push(@Header,$2);
      $state = 1;
      }
    elsif ( $curline eq "" )
      {
      push(@Header, $curline);
      $state = 4;
      }
    else
      {
      push(@Header, $curline);
      }
    }

#  state 4:	(verify probationer's key)
#    if (curline has tag)
#      if (curline preceding tag has key)
#        add sendaddr to registerlist
#        delete sendaddr from probationlist
#        send welcome to sendaddr
#        write (pop) list to newfile
#        write curline text preceding tag to newfile
#      else if (sendaddr has retries left)
#        resend message with key to sendaddr
#        if (savespam)
#          write (pop) list to spamfile
#          write curline text preceding tag to spamfile
#      clear list
#      remove curline text preceding tag
#      save (push) curline to list
#      state = 1
#    0else if (curline has key)
#      add sendaddr to registerlist
#      delete sendaddr from probationlist
#      write (pop) list to newfile
#      write curline to newfile
#      state = 2
#    else	(no key, or wrong)
#      if (sendaddr has retries left)
#        resend message with key to sendaddr
#      if (savespam)
#          write (pop) list to spamfile
#          write curline to spamfile
#          state = 5
#      else
#        clear list
#        state = 0

  elsif ( $state == 4 )
    {
    if ( $curline =~ m/(.*)(\001\001\001\001.*)/ )
      {
      my($keyline) = $1;
      my($nextline) = $2;
      if ( &haskey($sendaddr,$keyline) )
        {
        if ( $verbose )
          {
          warn "Probationed sender $sendaddr is now registered.\n";
          }
        $reglist{$sendaddr} = [$RightNow];
	$registrychanged = 1;
	delete($problist{$sendaddr});
	$problistchanged = 1;
	&sendwelcome($sendaddr);
	print MAILBOX_NEW join("\n",@Header),"\n";
	print MAILBOX_NEW "$keyline\n";
	}
      elsif ( &getretries($sendaddr) )
        {
        if ( $verbose ) { warn "Resending to $sendaddr.\n"; }
	&resend($sendaddr);
        if ( $savespam )
          {
  	  print SPAMBOX join("\n",@Header),"\n";
	  print SPAMBOX "$keyline\n";
	  }
	}
      @Header = $nextline;
      $state = 1;
      }
    elsif ( &haskey($sendaddr,$curline) )
      {
      if ( $verbose )
        {
        warn "Probationed sender $sendaddr is now registered.\n";
        }
      $reglist{$sendaddr} = [$RightNow];
      $registrychanged = 1;
      delete($problist{$sendaddr});
      $problistchanged = 1;
      &sendwelcome($sendaddr);
      print MAILBOX_NEW join("\n",@Header),"\n";
      print MAILBOX_NEW "$curline\n";
      @Header = ();
      $state = 2;
      }
    else
      {
      if ( &getretries($sendaddr) )
        {
        if ( $verbose ) { warn "Resending to $sendaddr.\n"; }
	&resend($sendaddr);
	}
      if ( $savespam )
        {
        $wrotespam = 1;
        print SPAMBOX join("\n",@Header),"\n";
	print SPAMBOX "$curline\n";
	@Header = ();
	$state = 5;
        }
      else
	{
	@Header = ();
	$state = 0;
	}
      }
    }

#  state 5:	(mail treated as spam)
#    if (curline has tag)
#      save curline text preceding tag to spamfile
#      remove curline text preceding tag
#      save (push) curline to list
#      state = 1
#    else
#      save curline to spamfile

  elsif ( $state == 5 )
    {
    if ( $curline =~ m/(.*)(\001\001\001\001.*)/ )
      {
      print SPAMBOX "$1\n";
      @Header = ( );
      push(@Header,$2);
      $state = 1;
      }
    else
      {
      print SPAMBOX "$curline\n";
      }
    }

  } # end while (<MAILBOX_ORIG>)


if ( $problistchanged )		# Probation list changed, write new one out.
  {
  if ( $verbose ) { warn "Writing new probation file $ProbFile.\n"; }
  open(TEMPFILE, ">$TempFile");
  foreach $sender (keys(%problist))
    {
    print TEMPFILE "$sender\t".join("\t", @{$problist{$sender}} ), "\n";
    }
  close(TEMPFILE);
  unlink($ProbFile_Bak);
  rename($ProbFile,$ProbFile_Bak);
  rename($TempFile,$ProbFile);
  }

if ( $registrychanged )		# Registry has changed, write new one out.
  {
  &write_registry();
  }

		# Final file closings and renamings.

close(MAILBOX_ORIG);
if ( $savespam )
  {
  if ( $wrotespam )
    {
    print SPAMBOX "\001\001\001\001";
    }
  close(SPAMBOX);
  }
print MAILBOX_NEW "\001\001\001\001";
close(MAILBOX_NEW);

unlink($MailBox_Bak);
rename($MailBox_Orig,$MailBox_Bak);
rename($MailBox_New,$MailBox_Orig);

# print "Done.\n";

print MAILER_BAT $RebuildIndexCmd;
print MAILER_BAT $RebuildSpamCmd;
#print MAILER_BAT "del $Mailer_Bat\n";
close(MAILER_BAT);
system($Mailer_Bat);
unlink($Mailer_Bat);
exit;	# All Done.



#-----------------------------------------------------------------------------
#
#		write_registry
#
#	Write the registry list out to the file.  This should only be done
#	when the registry has actually changed.
#
#-----------------------------------------------------------------------------

sub write_registry
{
  if ( $verbose ) { warn "Writing new registry file $RegFile.\n"; }
  open(TEMPFILE, ">$TempFile");
  foreach $sender (keys(%reglist))
    {
    print TEMPFILE "$sender\t".join("\t", @{$reglist{$sender}} ), "\n";
    }
  close(TEMPFILE);
  unlink($RegFile_Bak);
  rename($RegFile,$RegFile_Bak);
  rename($TempFile,$RegFile);
}


#-----------------------------------------------------------------------------
#
#		get_sender
#
#	Return the sender of the next message in the MAILBOX_ORIG mailbox.
#	Scans through the mailbox, looking for beginning of message (in
#	Waffle, 4 bytes of 0x01), then for the From: line.  Returns
#	the user address on that line, or "" if none found.
#
#-----------------------------------------------------------------------------

sub get_sender
{
while (<MAILBOX_ORIG>)
  {
  my($CurLine) = $_;
  chomp($CurLine);
  if ( $CurLine =~ m/\001\001\001\001/ )
    {
	#--- Beginning of message found, now look for From: line.

    while (<MAILBOX_ORIG>)
      {
      my($CurLine) = $_;
      chomp($CurLine);
      my($FromAddr) = &get_fromaddr($CurLine);
      if ( $FromAddr ne "" )
        {
        return $FromAddr;
	}
      }
    }
  }
return "";
}


#-----------------------------------------------------------------------------
#
#		gettimestring
#
# 	Passed a variable containing an offset in hours from the present
#	time, returns a string in record format: "YYYY/MM/DD hh:mm:ss"
#
#-----------------------------------------------------------------------------

sub gettimestring
{
  my($offset) = shift(@_) * 3600;

  ( my($sec), my($min), my($hr), my($dom), my($mo),
    my($yr), my($wd), my($dst) ) = localtime(time + $offset);

  return sprintf("%4d/%02d/%02d %02d:%02d:%02d",
                 $yr+1900, $mo+1, $dom, $hr, $min, $sec);
}


#-----------------------------------------------------------------------------
#
#		get_fromaddr
#
# 	Passed a string, tests for a line beginning with "From: " and
#	containing a return address, returns the address.  On failure,
#	returns empty string.
#
#-----------------------------------------------------------------------------

sub get_fromaddr
{
  my($Line) = @_;
  if ( $Line =~ m/^From: / )
    {
    if ( $Line =~ m/$MatchAddr/ )
      {
      return $1;
      }
    }
  return "";
}


#-----------------------------------------------------------------------------
#
#		newprobationer
#
# 	Passed a string containing sender's address, generate the registration
#	parameters, add him to the probation list, and send a message.
#
#-----------------------------------------------------------------------------

sub newprobationer
{
  my($sender)  = shift(@_);
  my($fname)   = sprintf( $MsgFSpec, int(rand() * $msgfilect + 0.5));
  my($key)     = $keylist[int(rand() * $#keylist + 0.5)];
  my($retries) = "".($senderretries + 1);
  my($expire)  = gettimestring($probationtime);

  $problist{$sender} = [$fname, $key, $retries, $expire];
  $problistchanged = 1;

  &resend($sender);
}


#-----------------------------------------------------------------------------
#
#		resend
#
# 	Passed a string containing sender's address, resend the original
#	message and decrement retry count.  Returns nothing.
#
#-----------------------------------------------------------------------------

sub resend
{
  my($daddr) = shift(@_);		# Address to send it to.
  my($msgfname) = &getmessagefname;	# File to receive outgoing message.

  ( my($fname), my($key), my($retries), my($expire) ) = @{$problist{$daddr}};

  open(OUTMSG,">$msgfname")
    or die "Couldn't open message file $msgfname. (1)\n";

  open(PROTOMSG,"<$fname")
    or die "Couldn't open message file $fname. (2)\n";

  while (<PROTOMSG>)
    {
    my($msgline) = $_;
    chomp($msgline);

    if ($msgline =~ m/^(.*)%e(.*)$/) { $msgline = $1.$expire.$2;   }

    if ($msgline =~ m/^(.*)%k(.*)$/) { $msgline = $1.$key.$2;      }

    if ($msgline =~ m/^(.*)%u(.*)$/) { $msgline = $1.$useraddr.$2; }

    print OUTMSG "$msgline\n";
    }

  close(PROTOMSG);
  close(OUTMSG);

  print MAILER_BAT
    "rmail -fmailer -s\"Message rejected -- see inside\" $daddr < $msgfname\n";
  print MAILER_BAT "del $msgfname\n";

  my($retryct) = &getretries($daddr);
  if ( $retryct > 0 )
    {
    $retries = sprintf("%d", $retryct-1);
    $problist{$daddr} = [$fname, $key, $retries, $expire];
    }
}


#-----------------------------------------------------------------------------
#
#		haskey
#
# 	Passed a string containing sender's address and the line which should
#	contain the key, check for the key and return 1 if present, 0 if not.
#
#-----------------------------------------------------------------------------

sub haskey
{
  my($retaddr) = shift(@_);
  my($line) = shift(@_);
  my($key) = $problist{$retaddr}[1];
  return ($line =~ m/$key/);
}


#-----------------------------------------------------------------------------
#
#		sendwelcome
#
# 	Passed a string containing sender's address, let him know he is now
#	registered.  Nothing is returned.
#
#-----------------------------------------------------------------------------

sub sendwelcome
{
  my($destaddr) = shift(@_);		# Address to send it to.
  my($msgfname) = &getmessagefname;	# File to receive outgoing message.

  ( my($fname), my($key), my($retries), my($expire) ) = @{$problist{$destaddr}};


  open(OUTMSG,">$msgfname")
    or die "Couldn't open message file $msgfname. (3)\n";

  open(PROTOMSG,"<$OKMsgFname")
    or die "Couldn't open message file $OKMsgFname. (4)\n";

  while (<PROTOMSG>)
    {
    my($msgline) = $_;
    chomp($msgline);

    if ($msgline =~ m/^(.*)%e(.*)$/) { $msgline = $1.$expire.$2;   }
    if ($msgline =~ m/^(.*)%k(.*)$/) { $msgline = $1.$key.$2;      }
    if ($msgline =~ m/^(.*)%u(.*)$/) { $msgline = $1.$useraddr.$2; }

    print OUTMSG "$msgline\n";
    }

  close(PROTOMSG);
  close(OUTMSG);

  print MAILER_BAT
    "rmail -fmailer -s\"You are approved\" $destaddr < $msgfname\n";
  print MAILER_BAT "del $msgfname\n";
}


#-----------------------------------------------------------------------------
#
#		getmessagefname
#
#	Return a string containing the name to use for the next message file.
#	Aborts if none could be found.
#
#-----------------------------------------------------------------------------

sub getmessagefname
{
  my($fname) = "";
  my($i)     = 0;

  while ( $i++ <= 999 )
    {
    $fname = sprintf($MailFSpec,$nextreplynum);
    if ( ! -e $fname )
      {
      return $fname;
      }

    $nextreplynum++;
    if ( $nextreplynum > 999 ) { $nextreplynum = 0; }
    }

  die "Cannot create message file name; check directory.\n";
}


#-----------------------------------------------------------------------------
#
#		getretries
#
# 	Passed a string containing sender's address, return the number of
#	retries left (strip leading zeros to get decimal interpretation).
#
#-----------------------------------------------------------------------------

sub getretries
{
  my($retaddr) = shift(@_);
  return int($problist{$retaddr}[2]);
}

#end

