Code       SEGMENT Byte Public
           ASSUME  CS:Code
           Public  CrtWrite
           Public  CrtWriteLn

Comment *

   A fast write-to-screen routine.  Calls INT 29h, a.k.a. 'Fast Putchar',
   which is handled by the CON device (such as ANSI.SYS or replacement).

   Features:
   -  Understands bell (7), backspace (8), tab (9), carriage return (13)
      and line feed (10);
   -  Much faster than the equivalent INT 21h, functions 2 or 6, or
      INT 10h, function 0Eh ('TTY write');
   -  Not redirectable to NUL (but a program can always grab INT 29h and
      set up a stub handler to surpress output through CON).

   WARNING:  OS/2's DOS compability box does not implement an INT 29h
   handler - at least not in version 1.3.

   Call in Turbo Pascal 4.0 and up:

   {$F- }
   Procedure CrtWrite(s : String); External;
   Procedure CrtWriteLn(s : String); External;
   {$L CRTWRITE.OBJ }
*

Cr         EQU     13
Lf         EQU     10

;  if the carry flag is set, a new line sequence will be written

CrtWrite   PROC
           CLC
           JMP     Short @@1

CrtWriteLn:
           STC

;  save the DS register in BX
;  pop the return address and the pointer to the string from the stack

@@1:       MOV     DI, DS
           POP     DX
           POP     SI
           POP     DS

;  save flags register (the carry flag, anyway)
;  go forward

           PUSHF
           CLD

;  check length byte of string

           SUB     AX, AX
           LODSB
           XCHG    AX, CX
           JCXZ    @@3

;  process string

@@2:       LODSB
           INT     29h
           LOOP    @@2

;  write new line sequence

@@3:       POPF
           JNC     @@4
           MOV     AL, Cr
           INT     29h
           MOV     AL, Lf
           INT     29h

;  restore DS and return

@@4:       MOV     DS, DI
           JMP     DX
CrtWrite   ENDP

Code       ENDS
           END