	Page	82,132
	Title	TOADSOFT - Convert text file to or from WordStar format

	Comment | Version 1.1, 15 Jan 86

TOADSOFT Command
-----------------

Purpose:   1. Convert text file to WordStar .DOC format
		or convert WordStar .DOC formatted file to text file.
	   2.  Replace blanks with tab character(s)
		or expand tabs.

Format:    TOADSOFT [d:[input.ext]] [d:[output.ext]] [/t] [/u]

Remarks:   Any tab characters found are first expanded. If TABS
	appear within quoted strings - out of context - they will
	not be expanded.

	The default is to expand tabs (the normal WordStar DOC format).
	- Carriage return/line feeds within a paragraph are "softened"
	  (Cr becomes 13 + 128) to permit WordStar reformatting.
	- If 2 or more spaces in a row, the last space is "softened"
	  (Space becomes 32 + 128) to permit WordStar reformatting.

	The /U option may be used to Unsoften a WordStar DOC file.
	Tabs (if any) will automatically be expanded unless the
	/T option is selected.

	The /T option may be used to replace spaces with tabs, and may
	be used without Unsoftening a W* DOC file.

	Both /T and /U may be used together.

	Side Effects:  If a normal text file is Unsoftened and tabs
	expanded ('/TU'), non-space characters may be followed by up
	to 3 new spaces (where there used to be a nice neat tab).
	This is an artifact of the minispace .. NO tab will be inserted
	until 3 or more spaces have been used.  Sorry 'bout that.

	The maximum logical record size is 255, see MAXREC equate.
	Defacto tab columns are 9,17,25,...

	Credits:
	- Majority of file handling and tab processing from
	  Vernon Buerg's TABS version 1.6gg, 10 Jul 85.
	- Ensoft procedure from ENSOFT2.C (yep, translated back from C)
	  by Gordon Brandley (original author)
	  totally rewritten by Harvey G. Lord.

	Should run on any MS-DOS system with DOS 2.0 or higher.
	For public domain use.

	Author: David Kirschbaum, Toad Hall
		7573 Jennings Lane
		Fayetteville NC  28303
		(919) 868-3471
		ARPAnet ABN.ISCAMS@USC-ISID

Notes:
  I do some baaaad things in here .. like not always entering and
leaving procedures at the same place, or beginning and end (tch tch).
But .. I wanted it tight and fast .. and I wrote it for ME to
understand, not necessarily for you.  It always traces logically ..
you'll just have to work at it.
Toad Hall

v1.1, 15 Jan 86:  ENSOFT2.C specifies a leading space will turn off the
soft carriage return function for that line.  I don't like that because
it makes reformatting columnar or indented material much harder (all the
hard cr/lfs are still there).  Commented that test out.
Tried softening trailing hyphens (when ensoftening), but too much hassle.
Still one wee little bug .. can't seem to terminate the target file with
a clean Cr/Lf and Ctrl-Z .. always get a couple of spaces or tabs stuffed
in there.  Strange.
[Toad Hall]
-----------------			|

CSeg	Segment Public Para 'CODE'
	Assume  CS:Cseg,DS:Cseg,ES:CSeg
	Org	100h

Tabs	Proc	Far
	Push	DS			;DOS convention
	Sub	AX,AX
	Push	AX

	Mov	CS:Stk_Top,SP		;Save stack ptr to insure return

	Call	ChkVer			;Check for DOS 2

	Call	Alloc			;Get maximum I/O buffers

	Call	GetFile			;Get file names

	Call	OpenIn			;Open input

	Call	OpenOut			; and output

	Call	Inform			;Display "cooking" message

	Call	GenTab			;Generate tabs

	Call	Flush			;Empty the output buffer
	mov	BX,Tabcnt		;get final tab count
	call	Print_count		;one last time

	Mov	DX,Offset EofMsg	;Say END-OF-FILE
Error:  Mov	SP,Stk_Top		;Insure proper return
	Call	PrintS			;Print any message

	Call	Close			;Close files

	Ret				;Return to DOS
	Page

Buflen  Dw	0			;I/O buffer size
MinCore Dw	512			;Minimum of one sector
Maxrec  Equ	255			;Longest logical record

S_Quote Equ	34			;Single quote
D_Quote Equ	39			;Double quote
Tab	Equ	9
Lf	Equ	10
Cr	Equ	13
EOF	Equ	1AH
FormF	Equ	0CH
Soft_Cr  Equ	8DH			;W* soft carriage return
End_Hyph Equ	1FH			;W* soft hyphen at end of line
Mid_Hyph Equ	1EH			;W* soft hyphen NOT at end of line
Minspace equ	3			;minimum # sequential spaces
					; before a tab (adjust to your
					; liking or circumstances).
					;(No, I DON'T know what'll happen
					; if you make it 0.)

Tabcnt  Dw	0			;tab counter
Rec	Db	Maxrec Dup (0)		;Current record
Sw	Db	0			;Number of blanks skipped
Qsw	Db	0			;Quote switch
Tabflg  db	0			;non-zero for tabbing function
Unsoft  db	0			;Non-zero for W* Unsoft
Lf_flag db	0			;Lf counter for ensoft
space_flag db	0			;space counter for ensoft
start_line db	0			;new line flag for ensoft

Stk_Top Dw	0			;SP at entry

MsgIn	Db	Cr,Lf,'Enter INPUT file name-  ',255
Msg1	Db	Cr,Lf,'Input failed to open, '
InKey	Db	32,32			;Keyboard buffer
Input	Db	76 Dup (0),0,255	;Drive:path\name.ext
IHandle Dw	0			;Input file handle
Ilen	Dw	0			;Input block length
Iptr	Dw	0			;Offset to next char
In_Ptr  Dw	0			;Seg offset

MsgOut  Db	Cr,Lf,'Enter OUTPUT file name- ',255
Msg2	Db	Cr,Lf,'Output failed to open, '
OutKey  Db	32,32
Output  Db	76 Dup (0),0,255
OHandle Dw	0			;Output file handle
Olen	Dw	0			;Bytes in output buffer
Optr	Dw	0			;Offset to next char
Out_Ptr Dw	0			;Seg offset

DTA	Db	48 Dup (0)
	Page
Sorry	Db	Cr,Lf,'Sorry, DOS Version 2 required',Cr,Lf,255
Msg3f	Db	Cr,Lf,'I/O error reading',Cr,Lf,255
Msg40	Db	Cr,Lf,'I/O error writing',Cr,Lf,255
Msg4a	Db	Cr,Lf,'Insufficient memory',Cr,Lf,255
Msg4e	Db	Cr,Lf,'No matching file(s) found',Cr,Lf,255
InformD Db      'De-'
Cooking Db      'Tabbing, ',255
SoftStr db      'nsofting:   ',255
Mark	Db      ' => ',255
EofMsg  Db	Cr,Lf,'End of File',Cr,Lf,255

Code2	Db      'File not found ',255
Code3	Db      'Path not found ',255
Code4	Db      'Too many files ',255
Code5	Db      'Access denied  ',255
CmdLine db 'TOADSOFT Version 1.1, Toad Hall, 15 Jan 86, public domain',cr,lf
 db 'Command:',cr,lf
 db 'TOADSOFT [d:][\p\][ source.typ][ target.typ] [/t][/u][/tu]',cr,lf
 db 'where source is file to be changed,',cr,lf
 db '      target is destination file (names MUST be different)',cr,lf
 db 'and options t = tabify (change spaces to tabs),',cr,lf
 db '            u = unsoften (change W* file to ASCII).',cr,lf
 db 'Defaults are Ensoften and expand tabs to spaces.',cr,lf,255

;
;	Replace blanks with tabs

GenTab  Proc	Near

Loop:	Call	GetRec			;Get a record, length in CX
	Sub	BX,BX			;Output column
	Mov	Sw,BL			;No blanks yet
	Mov	Qsw,BL			;No quotes yet
	Or	CX,CX			;Any data in record?
	jnz	Set1			;yep
	jmp	Null			; no, just CR-LF

;stuffed this in here cause the jumps were getting too long...

Done:	cmp	Lf_flag,0		;still owe a cr/lf?
	jz	Done1			; nope
	call	DoHarCrLf		;save a cr/lf
Done1:	mov	AL,Eof
	jmp	PutChar			;save that CtrlZ and return


Set1:	Mov	SI,Offset Rec		;Look for blanks and
Wloop:  Lodsb				; replace strings of blanks
	Cmp	AL,EOF			;End of file?
	Je	Done			; yes, all done
	Inc	BX			; with tab characters
	cmp	Tabflg,255		;are we tabifying?  If not, we don't
					; have any spaces saved anyway.
	jne	Copy			; nope, just save the char

; Don't count blanks within single or double quoted strings
	Cmp	AL,D_Quote		;Double quote?
	Jne	Chk1			; nope, go check single
	Xor	Qsw,2			; turn on/off the 2-bit for "
	Jmp	Chk2

Chk1:	Cmp	AL,S_Quote		;single quote?
	jne	Chk2			; nope
	cmp	Rec[SI+1],'t'		;a n't?
	je	Copy			; yep, just skip it
	Xor	Qsw,1			; turn on/off the 1-bit for '

Chk2:	test	Qsw,3			;within quotes?
	Jnz	Insert			; yep, save them
;--- done with quotations

;our column counter is in BL.
Chk3:	cmp	BL,08H			;no tabs till col 9
	jle	Insert			;...and Insert'll take care of any
					;   leading spaces
	mov	AH,BL			;(not using AH for anything)
;this gets weird, but it's Boolean... and it works...

	dec	AH			; (don't ask...)
	test	AH,07H			;ready for a tab?
	jnz	Insert			; nope, see if we must insert
					;  skipped spaces.

;we have a character, and we're on a tab column.
;we'll only tab if we have Minspace spaces before this char.

Check:  cmp	Sw,Minspace		;minimum space?
	jl	Insert			; not enough spaces, gotta insert
	call	Test_Count		;do the tab, putchar
	jmp	Tloop

Copy:	call	Ensoften		; process and save it
Tloop:  Loop	Wloop

Null:	mov	Sw,0			;clear skipped space counter
					; since we want no trailing spaces
					; on a new line
	mov	AL,Lf			;don't freak ...
	call	Ensoften		;...Ensoften knows what it's doing
	Jmp	Loop

;Check for and insert any blanks that didn't line up on a tab column.
;We do NOT insert any spaces yet if we still HAVE a space ..
; ..might be building up for a tab.

Insert: cmp	AL,' '			;entering with a space?
	jne	Insert1			; nope
	add	Sw,1			; yep, bump the skipped space counter
	jmp	Tloop			;..and go look for more

Insert1: cmp	Sw,0			;any skipped spaces?
	je	Copy			; nope, go save char
	Push	AX			;Save the old char
	push	CX			; and our loop counter
	mov	AL,Sw			;this many spaces
	cbw				;make AL a word AX
	mov	CX,AX			;our space loop counter
Blanks: Mov	AL,' '			;stuff in CX spaces
	Call	Ensoften		; with ensoft processing
	loop	Blanks			;loop
	pop	CX			;restore WLoop counter
	Pop	AX			;Get last char back
	mov	Sw,0			;reinit our skipped space counter
	Jmp	Copy			;..and save it

GenTab  Endp
	Page

;	Build a logical record with TABs expanded

GetRec  Proc	Near
	Sub	DI,DI			;Target record offset
	Mov	Qsw,0			;Quote indicator

;Build up a logical record by looking for a CR or LF as end-of-record.
;In Tabs16, this didn't handle isolated Lfs or Crs before.  Now does.
;Never passes on a Cr, doesn't stick Lfs in the building record.

Get1:	Call	GetChar			;Next char, please
	Cmp	AL,Lf			;Lf = end of record? (might be
					; isolated with no preceding Cr)
	Je	Get7			; yep
	cmp	AL,Cr			;gobble all Cr's, not gonna address
	je	Get1			; isolated Cr's just yet

	Cmp	AL,S_Quote		;Don't expand tabs
	Jne	Get2			; found within a
	Xor	Qsw,1			; quoted string
Get2:	Cmp	AL,D_Quote
	Jne	Get3
	Xor	Qsw,2
Get3:	Cmp	AL,Tab			;Is it TAB?
	Jne	Get5			; no, pass it
	Test	Qsw,3			;Within quotes?
	Jnz	Get5			; yes, pass it as-is
	cmp	Tabflg,255		;tabbing?
	je	Get4			; yep, so don't count/show now
	call	Test_count		; incr tab cntr, print
Get4:	Mov	Rec[DI],' '		;Expand embedded tabs
	Inc	DI			; with blanks
	Test	DI,0007H
	Jz	Get1
	Jmp	Get4

Get5:	Mov	Rec[DI],AL		;Build the record by
	Inc	DI			; copying each character
	Cmp	DI,Maxrec		; or TABs expanded to blanks
	Jae	Get6
	Cmp	AL,EOF			;Is it EOF?
	jne	Get1			; nope, continue
PadIt:  mov	Rec[DI],AL
	inc	DI
	cmp	DI,MaxRec
	jl	PadIt
Get6:	Mov	CX,DI			;Final record length
	Ret

; We've hit an end-of-record.  If unsofting, screen for hyphens, soften
; as appropriate.
; Gobble all trailing spaces.  (If we're doing an ensoft, we'll put them
; back, not to worry.)

Get7:	Cmp	Rec-1[DI],' '		;Trailing space?
	jne	Get6			; nope, all done
	Dec	DI			;back up
	Jz	Get6			; done
	Jmp	Get7			; not done yet, keep gobbling

GetRec  Endp
	Page
;
;
Ensoften	proc	near
;from ensoft2.c
;if Unsoftening, just flips current character to PutChar.
; otherwise processes text to WordStar DOC format.

Ensof1b: cmp	Unsoft,255		;Unsoftening?
	jnz	Ensoft2			; nope, go ensoft
Ensof1c: cmp	AL,Lf			;need to terminate a line?
	je	Ensof1d			; yep
	jmp	Endon			; nope, just save the char and return

Ensof1d: jmp	DoHarCrLf		;send a full cr/lf and return

;finally, we're ensofting...

Ensoft2: cmp	AL,Lf			;Lf for new line?
	jnz	Chek_enspace		; nope

;assume we're starting with a new line now.

	mov	Space_flag,1		;v1.1 new -- set space flag
	cmp	Lf_flag,0		;first cr/lf?
	jnz	Chkcr2			; nope
	mov	Lf_flag,1		;start our Lf count
	ret				;end without saving char
					;..cause we may do a soft one later

;if 2d Cr/Lf in a row, this means a hard Cr/Lf is needed to end
;a paragraph.
Chkcr2:	cmp	Lf_flag,1		;2d cr/lf in a row?
	jnz	Chkcr3			; nope, just save 1
	call	DoHarCrLf		; yep, save cr/lf
	mov	Lf_flag,2		;inx Lf_flag to 2

;we just have repeating cr/lfs now .. all will be hard.
Chkcr3:					;3d or > cr/lf in a row
	jmp	DoHarCrLf		;send this one set
					;..and return without saving char

;see if this char is a space
Chek_Enspace:
	cmp	AL,' '			;got a space?
	jnz	Chek_other		; nope

	cmp	Lf_flag,1		;owe a cr/lf?
	jnz	Sp2			;v1.1 nope
	mov	Lf_flag,0
	mov	AL,Soft_Cr
	call	DoCrLf			;putchar cr/lf in rec
	jmp	Sp3			;v1.1 indented .. force soft space

;so we aren't at the start of a line...
Sp2:	cmp	Space_flag,0		;1st space?
	jg	Sp3			; nope, more than 1
	mov	Space_flag,1		;flag a space
	jmp	Endon			;...and save that normal space

;not at start of line, 2 or more spaces in a row
Sp3:	mov	AL,' '+128		;stuff in a soft space
	jmp	PutChar			;...and save that soft space

;any other character
Chek_other: mov space_flag,0		;no repeating spaces now
	cmp	AL,FormF		;got a formfeed?
	jne	Chek_o1			; nope
	mov	Lf_flag,0		;clear the cr/lf flag
	push	AX			;save the FormFeed
	call	DoHarCrLf		;force a hard cr/lf
	pop	AX			;get FormFeed back
	jmp	Chek3			;..and skip
	
Chek_o1:
	cmp	Lf_flag,1		;last char a single cr/lf?
	jl	Endon			; nope, no cr/lf at all
	mov	Lf_flag,0		;zero the cr/lf flag in either case
	jg	Endon			; just save the char
					;..else if 1, fall thru to...

;we still owe a single soft cr/lf, so here goes...
Do_soft:
	push	AX			;save old char
	mov	AL,' '			;save a trailing space a la W*
	call	PutChar
	mov	AL,Soft_Cr		;save a soft Cr/lf
Do_so1:	call	DoCrLf
	pop	AX			;get old char back

;didn't have cr/lf
Chek3:  mov	Space_flag,0		;zero space flag
					;... and fall through to...

Endon:  jmp	PutChar			;save the char and return

Ensdon: ret
Ensoften	endp

;
;force a carriage return for Ensoften.
;enter with soft Cr (13+128) in AL if skipping to DoCrLf.
DoHarCrLf proc	near
	mov	AL,Cr			;if we're doing a hard one
DoCrLf:	call	PutChar
	mov	AL,Lf			;now the Lf
	call	PutChar
	ret
DoHarCrlf  endp

;
;	Extract one char from record

GetChar Proc	Near			;Read char into AL
Read1:  Dec	Ilen			;Any in buffer?
	Js	Read			; no, read next block
	Mov	SI,Iptr			; yes, get offset in buf
	Lodsb				;snarf a char in AL
	Mov	Iptr,SI			;Offset for next one
	cmp	AL,Mid_Hyph		;W* soft hyphen?
	je	Read01			; yep
	cmp	AL,End_Hyph		;the other W* soft hyphen?
	jne	Read02			; nope
Read01:	mov	AL,'-'			;yep, make it a normal hyphen always
	jmp	Read2

Read02:	and	AL,7FH			;strip any hi-bits
	Cmp	AL,EOF
	jnz	Read2			;not eof yet
Read03:
;	mov	Lf_Flag,2		;force hard cr/lf
	mov	Space_Flag,0		;insure no soft spaces
	mov	Ilen,1		;new	;length counter of just 1
Read2:  ret

Read:	Push	CX
	Mov	BX,IHandle		;Read a block of data
	Mov	CX,BufLen		; into Input (segment) buffer
	Mov	DX,In_Ptr
	Mov	Iptr,DX
	Mov	AH,3FH
	Int	21H
	Pop	CX
	Mov	Ilen,AX			; and length
	Jc	Read3			;carry means failed
	Or	AX,AX			;Anything read?
	Jnz	Read1			; yes, pick it up
	Mov	AL,EOF			; no, return EOF
	jmp	Read03	;Ret

Read3:  Mov	DX,Offset Msg3f		;Say I/O ERROR
	Jmp	Error
GetChar Endp

;	Block output records

PutChar Proc	Near			;Write from AL
	Push	CX
	Mov	DI,Optr			;Offset in buffer
	Stosb
	Mov	Optr,DI			;New buffer ptr
	Inc	Olen			;adjust our buffer length counter
	cmp	AL,Eof			;done
	je	Write1			;skip this test .. we'll do it later
	Mov	CX,Buflen
	Cmp	Olen,CX			;Full block?
	Jae	Write3			; yes, write it
Write1: Pop	CX
	Ret
;
;
;Write data left over in output buffer as one of last things to do.
Flush:
 	Mov	CX,Olen			;Any left in output?
	Or	CX,CX
	jz	Write4			; nope, just return
	push	CX

Write3: Push	AX
	Push	BP
	Push	BX
	Push	DX
	Mov	BX,OHandle		;Get file handle
	Mov	BP,CX			;Save size requested
	Mov	DX,Out_Ptr
	Mov	Optr,DX
	Mov	AH,40h			;Write the block
	Int	21H
	Jc	Writer			;carry means bad Write
	Sub	BP,AX			;Wrote all data?
	Mov	Olen,BP
	jnz	Writer			; nope

	Pop	DX
	Pop	BX
	Pop	BP
	Pop	AX
	Pop	CX
Write4: Ret

Writer: Mov	DX,Offset Msg40		; no, say I/O error
	Jmp	Error
PutChar Endp

;	Open input file

OpenIn  Proc	Near
	Mov	DX,Offset Input
	Mov	AL,0			;For input
	Mov	AH,3DH			;Open a file
	Int	21H
	jc	BadOpenI		;carry means bad open

Openi:  Mov	IHandle,AX
	Ret

BadOpenI:
	Mov	DX,Offset Msg1		;say I/O error
	Jmp	OpenErr
OpenIn  Endp

;	Open output file

OpenOut Proc	Near
	Mov	DX,Offset Output
	Sub	CX,CX			;Normal file attribute
	Mov	AH,3CH			;Create a file
	Int	21H
	jc	BadOpenO		;carry means bad open
	Mov	OHandle,AX
	Ret

BadOpenO:
	Mov	DX,Offset Msg2		;say I/O error
	Jmp	OpenErr
OpenOut Endp

;	Determine why OPEN failed

OpenErr:Cmp	AL,2			;AL has reason code
	Jb	Opene
	Cmp	AL,5
	Ja	Opene
	Sub	BX,BX			;Get offset to reason
	Mov	BL,AL			;text for open failure
	Mov	CL,4
	Shl	BX,CL
	Call	PrintS			;Say OPEN FAILED
	call	CrLf
	Lea	DX,Code2-32[BX]
Opene:  Jmp	Error

;	Close input/output

Close	Proc	Near			;Close files
	Mov	BX,OHandle		; output
	Mov	AH,3EH
	Int	21H
	Mov	BX,IHandle		; input
	Mov	AH,3EH
	Int	21H
	Ret
Close	Endp

;	Find first matching file, just cuz I'm lazy

Find	Proc	Near			;Find first matching file
	Mov	DX,Offset DTA		;Set data xfer area
	Mov	AH,1AH
	Int	21H
	Mov	DX,Offset Input		;Input path\filename.ext
	Sub	CX,CX			;Search for first normal file
	Mov	AH,4EH
	Int	21H
	jc	Find0			;carry means not found

Find1:  Or	AL,AL			;Set ZF for return
	Jnz	Find0			; if none found
	Mov	DI,Offset Input
	Cmp	Byte Ptr [DI+1],':'	;If drive was supplied
	Jne	Find2			; leave it in file name
	Add	DI,2
Find2:  Cmp	Byte Ptr [DI],'\'	;If path was supplied
	Jne	Find5			; try to leave it in Input name
	Mov	SI,Offset Input+75
	Std
	Mov	CX,76
Find3:  Lodsb
	Cmp	AL,'\'			;Find the last separator
	Je	Find4			; which is the filename spec
	Loop	Find3
	Mov	SI,DI

Find4:  Mov	DI,SI
	Add	DI,2
Find5:  Mov	CX,13			;Copy found name to Input name
	Cld
	Mov	SI,Offset DTA+30	; after drive and first path name
Find7:  Lodsb
	Stosb
	Cmp	AL,0			;Don't want crud in message
	Je	Find9
	Loop	Find7
Find9:  Ret

Find0:  Mov	DX,Offset Msg4e		;Say NO MATCHING FILE
	Jmp	Error
Find	Endp
;
;	Get file names from command line

GetFile Proc	Near			;Get file name(s)
	Mov	SI,80H			;Point to command line
	Sub	CX,CX			;The PSP may contain one or two
	Or	CL,Byte Ptr DS:[SI]	; filenames separated by blanks
	Jz	GetF6			; no names at all
	Lea	DI,ES:Input		;Target is infile for
	Inc	SI			; first command operand

GetF1:  Lodsb				;Copy command line to file names
	Cmp	AL,' '			; by skipping leading blanks
	Jne	GetF1x			; until a CR is found
	Loope	GetF1
	JCXz	GetF6			;If all blank

GetF1x: cmp	AL,'?'			;does he have a question?
	jne	GetF1a
	mov	DX,Offset CmdLine	;say how to do it
	jmp	Error			; and exit

GetF1a: Cmp	AL,Cr			;Is it CR, end of line?
	Je	GetF5			; yes, terminate fname
	Cmp	AL,'/'			;Or option string?
	Jne	GetF1b			; Nope, keep looking
	jmp	GetOpt			; Yep, go process any options

GetF1b: Cmp	AL,' '			;Ending blank?
	Je	GetF2			; separator .. check for 2d cmd
	Stosb				;stuff the char back
	Lodsb				;get the next
	Loop	GetF1a			;loop till done or we got something
	Jmp	GetF5			;one name, no options

GetF3:  Jmp	GetF6

GetF2:  Mov	AX,0FF00h		;Terminate fname operand
	Stosw
	Lea	DI,ES:Output		;Process second fname
GetF2a: Lodsb
	Cmp	AL,' '			;Skip intervening blanks
	Jne	GetF2b
	Loope	GetF2a
	JCXz	GetF6			;If no operand

GetF2b: Cmp	AL,Cr			;Is it CR, end of line?
	Je	GetF5			; yes, end of command
	Cmp	AL,'/'			;Or option string?
	jne	GetF2c			; nope, keep looping
	Jmp	GetOpt			; yes, go process it

GetF2c: Stosb				;save that 2d fname char
	loop	GetF2a

GetF5:  Mov	AX,0FF00H		;Append zero and dollar sign
	Stosw

GetF6:  Mov	AX,CS			;When done, set up
	Mov	DS,AX			; segment registers
	Mov	ES,AX

GetF7:  Cmp	Input,0			;Any input name?
	Jne	GetF8			; yes, try output name
	Mov	DI,Offset MsgIn		; no, ask for one
	Mov	SI,Offset InKey
	Call	AskName			;Get the input file name

GetF8:
	Call	Find			;Find first matching file
GetF8a: Cmp	Output,0		;Any output name?
	Jne	GetF9			; yes, that was easy
	Mov	DI,Offset MsgOut	; no, ask for it
	Mov	SI,Offset OutKey
	Call	AskName			;Get the output name

GetF9:  Cmp	Word Ptr Output+1,003AH ;If just a drive is given
	Jne	GetFend			; for the output,
	Mov	CX,74			; use the input filename
	Mov	DI,Offset Output+2
	Mov	SI,Offset Input
	Cmp	Input+1,':'		;If drive was given for
	Jne	GetF10			; input, must skip over it
	Sub	CL,2			;Adjust pointers passed drive
	Add	SI,2
GetF10: Rep	Movsb

GetFend:Ret

;we have a / option indicator, so process it.
GetOpt: Mov	AX,0FF00H		;Append zero and dollar sign
	Stosw

GetOp0: Lodsb				;Get possible option letter
	JCXz	OpEnd			;If no operand, return CX=0
GetOp1: cmp	AL,Cr			;ran out of command line?
	je	OpEnd			; yep, terminate

GetOp2: xor	AL,20H			;uppercase it
	Cmp	AL,'T'			;check /T option for tabbing
	jne	GetOp3			;go see if /U for unsoften
	Mov	Tabflg,255		; flag we're tabbing

GetOp3: cmp	AL,'U'			;check /U option
	jne	GetOp4			; nope
	mov	Unsoft,255		;flag unsoftening

GetOp4: loop	GetOp0			;loop for another
OpEnd:  jmp	GetF6			;Terminate
GetFile Endp
;
;	Ask for file name(s)

AskName Proc	Near			;Ask for input file name
	Push	DI			;Ptr to prompt msg
	Push	SI			;Ptr to reply buffer
	Mov	Byte Ptr [SI],76	;Reply length
Ask1:	Mov	DX,DI
	Call	PrintS			;Print the prompt msg
	Mov	DX,SI			;Read console reply
	Mov	AH,10
	Int	21h
	Sub	BX,BX			;If a reply is given,
	Add	BL,1[SI]		; append a zero as the
	Jz	Ask1			; ASCIIZ name stopper
	Mov	Word Ptr 2[SI][BX],0FF00H
	Mov	Word Ptr 0[SI],'  '	;Clear error message part
	Pop	SI
	Pop	DI
	Ret
AskName Endp

;	Display "cooking" message

Inform  Proc	Near
	call	CrLf
	Mov	DX,Offset Cooking	;'Tabbing'
	Cmp	Tabflg,0		;tabbing?
	Jne	Inform1			; yep
	Mov	DX,Offset InformD	;say "De"
Inform1: Call	PrintS
	mov	DL,'E'			;'Ensoft'
	cmp	Unsoft,255		;Unsofting?
	jne	Inform2			; nope
	mov	DL,'U'			;'Unsoft'
Inform2: mov	AH,02H			;display char function
	int	21H			;call DOS
	mov	DX,Offset SoftStr	;'nsofting'
	call	PrintS
	Mov	DX,Offset Input
	Call	PrintS
	Mov	DX,Offset Mark
	Call	PrintS
	Mov	DX,Offset Output
	Call	PrintS
	jmp	CrLf
Inform  Endp

CrLf	proc	near
	mov	DL,Cr
	mov	AH,02H			;display char function
	int	21H			;call DOS
	mov	DL,Lf
	mov	AH,02H
	int	21H
	Ret
CrLf	endp

ChkVer  Proc	Near
	Mov	AH,30H
	Int	21H			;Verify DOS 2.0 or later
	Cmp	AL,2
	Jae	Chk9
	Mov	DX,Offset Sorry
	Jmp	Error
Chk9:	Ret
ChkVer  Endp

PrintS  Proc	Near			;Print string like Int 21h (9)
	Push	BX			;DX points to string
	Push	SI
	Push	DX
	Mov	SI,DX
PS1:	Lodsb
	Cmp	AL,255			;String ends in a hex FF
	Je	PS9			; so can display dollar sign
	Cmp	AL,0			;Ignore zeros
	Je	PS1
	Mov	DL,AL
	Mov	AH,2			;TTY write
	Int	21H
	Jmp	PS1

PS9:	Pop	DX
	Pop	SI
	Pop	BX
	Ret
PrintS  Endp

Test_count	proc	near
; increase our tab counter and display.
; display updated count only every 128 tabs,
; and for sure at end of program.
;
	inc	Tabcnt			;increase counter
	test	Tabcnt,127		;do only every 128 tabs
	jnz	Test_col		; not yet
	call	Print_count		;go show it
Test_col:
	cmp	Tabflg,255		;tabbing?
	jne	Test_end		; nope, don't do anything silly

	push	AX			;save old char a sec
	cmp	Sw,8			;skipped more than 1 tab col?
	jle	Testcol2		; nope, just one to do
	mov	AL,Tab			;we owe a tab
	call	Ensoften
	call	Print_Count		;update our counter
Testcol2:
	mov	AL,Tab			; save a tab
	call	Ensoften		; with processing
	mov	Sw,1			;reinit skipped space counter,
					; assuming last char was a space
	pop	AX			;get back our old character
	cmp	AL,' '			;did we enter at a blank tab col?
	jz	Test_end		;yep, so no char write for a space
	Call	Ensoften		;process, save that char
	mov	Sw,0			;no space, reinit counter
Test_end:
	ret				;return to calling routine
Test_count	endp
;
;
Print_count	proc	near
; procedure converts binary number in BX (in this case, our tab counter)
; to decimal, prints on screen.
; cribbed from The Write Group Assembly Language Primer for the PC and XT.
; [Toad Hall]

	push	AX
	push	BX
	push	CX
	push	DX
	mov	BX,Tabcnt		;get counter
	mov	CX,10000d		;div by 10000
	call	Dec_div
	mov	CX,1000d		;div by 1000
	call	Dec_div
	mov	CX,100d			;div by 100
	call	Dec_div
	mov	CX,10d			;div by 10
	call	Dec_div
	mov	CX,1d			;div by 1 for last display
	call	Dec_div
	mov	DL,Cr			;Do a Cr to make it pretty
	mov	AH,02H			;display char function
	int	21H			;call DOS
	pop	DX			;restore regs
	pop	CX
	pop	BX
	pop	AX
	ret				;from Print_count
Print_count	endp
;
;
Dec_div proc	near
;divide BX by CX, print quotient on screen.
; cribbed from The Write Group Assembly Language Primer for the PC and XT.
; [Toad Hall]
	cmp	BX,CX			;dividend smaller?
	jge	Dec1			;nope
	mov	DL,'0'			;make it a zero
	jmp	Dec2			;print it

Dec1:	mov	AX,BX
	cwd				;double word AX into AX & DX
	div	CX
	mov	BX,DX			;remainder into BX
	mov	DL,AL			;quotient into DL
	add	DL,30H			;asciify
Dec2:	mov	AH,02H			;char display
	int	21H			;call DOS
	ret
Dec_div endp
;
;
;	Allocate up to 32K per buffer by modifying memory
;	to use all of the 64K allowed for a COM program.
;	This is more complicated than using data segments
;	for the buffers, but has the advantages of allowing
;	for variable buffer sizes depending upon the amount
;	of memory available. It also allows DS and ES to remain
;	static. Besides, the COM version is under 2K bytes.

Alloc	Proc	Near			;Get I/O buffers
	Mov	BX,PgmSize		;Paras in program
	Mov	AH,4AH			; and modify allocated memory
	Int	21H			; using ES from entry
	jc	Alloc0			;carry means bad

Alloc1: Mov	BX,MaxCore		;Get rest of 64k
Alloc2: Mov	AH,48H
	Int	21H
	Jc	Alloc2			; but settle for what there is
	Mov	In_Ptr,AX		;Seg addr for input buffer
	Sub	BX,32			;Size less stack and PSP
	Js	Alloc0			; bad

	Sar	BX,1			;Paras for each buffer
	Add	AX,BX
	Mov	Out_Ptr,AX		;Seg addr for output buffer

	Mov	AX,BX
	Mov	CL,4
	Shl	AX,CL			;Convert to bytes
	Mov	BufLen,AX
	Cmp	AX,MinCore		;Have enough?
	Jb	Alloc0			; bad

	Mov	DX,DS			;Convert ptrs to offsets
	Mov	AX,In_Ptr
	Sub	AX,DX
	Shl	AX,CL
	Mov	In_Ptr,AX
	Mov	Iptr,AX

	Mov	AX,Out_Ptr
	Sub	AX,DX
	Shl	AX,CL
	Mov	Out_Ptr,AX
	Mov	Optr,AX
	Ret

Alloc0: Mov	DX,Offset Msg4a		;error msg
	Jmp	Error
Alloc	Endp

Tabs	Endp

PgmSize Equ	($-Cseg+16)/16		;Cseg and stack length
MaxCore Equ	4096-PgmSize		;Max 64k COM

Cseg	Ends

	End	Tabs
