/*
 * TEA for DOS database unbuilder
 *
 * Version 1.01
 *
 * Usage: TEAUNBLD <database_file>
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

typedef int Boolean;
#define False           (0)
#define True            (!False)

#define LENMIN          1
#define LENMAX          40

#define OFFSETMAX       0x7

#define CODE_APOSTROPHE '{'
#define CODE_CAP        '|'
#define CODE_HYPHEN     '}'
#define CODE_SPACE      '~'

static char character[256] =
{
    'a','a','a','a','a','a','a','a','b','b','b','b','b','b','b','b',
    'c','c','c','c','c','c','c','c','d','d','d','d','d','d','d','d',
    'e','e','e','e','e','e','e','e','f','f','f','f','f','f','f','f',
    'g','g','g','g','g','g','g','g','h','h','h','h','h','h','h','h',
    'i','i','i','i','i','i','i','i','j','j','j','j','j','j','j','j',
    'k','k','k','k','k','k','k','k','l','l','l','l','l','l','l','l',
    'm','m','m','m','m','m','m','m','n','n','n','n','n','n','n','n',
    'o','o','o','o','o','o','o','o','p','p','p','p','p','p','p','p',
    'q','q','q','q','q','q','q','q','r','r','r','r','r','r','r','r',
    's','s','s','s','s','s','s','s','t','t','t','t','t','t','t','t',
    'u','u','u','u','u','u','u','u','v','v','v','v','v','v','v','v',
    'w','w','w','w','w','w','w','w','x','x','x','x','x','x','x','x',
    'y','y','y','y','y','y','y','y','z','z','z','z','z','z','z','z',
    '{','{','{','{','{','{','{','{','|','|','|','|','|','|','|','|',
    '}','}','}','}','}','}','}','}','~','~','~','~','~','~','~','~',
    '?','?','?','?','?','?','?','?','?','?','?','?','?','?','?','?',
    };

#define CHARACTER(x)    (character[x])
#define alphabeticMax   (26 << 3)

static void output(int fn, char* frame, int mn, int* offsets, int* codes)
{
    int fi, mi;
    char caseMask;

    mi = 0;
    for (fi = 0; fi < fn; fi++)
    {
        caseMask = 0x00;

        while (mi < mn && offsets[mi] == fi)
        {
            switch(CHARACTER(codes[mi++]))
            {
            case CODE_APOSTROPHE: putchar('\''); break;
            case CODE_HYPHEN    : putchar('-'); break;
            case CODE_SPACE     : putchar(' '); break;
            case CODE_CAP       : caseMask = 0x20; break;
            }
        }

        putchar(frame[fi] ^ caseMask);
    }

    putchar('\n');
}

static void decode(FILE* file, int length)
{
    int modifierOffsets[LENMAX*4];
    int modifierCodes[LENMAX*4];
    int modifiers;

    char frame[LENMAX+1];
    int cursor;
    int c;

    frame[length] = '\0';
    cursor = 0;
    modifiers = 0;

    while ((c = fgetc(file)) != EOF)
    {
        if ((cursor += (c & 0x7)) < length)
        {
            if (c < alphabeticMax)
            {
                frame[cursor++] = CHARACTER(c);
            }
            else
            {
                modifierOffsets[modifiers] = cursor;
                modifierCodes[modifiers++] = c;
            }
        }
        else
        {
            output(length, frame, modifiers, modifierOffsets, modifierCodes);
            cursor -= length;
            ungetc(c & ~0x7, file);
            modifiers = 0;
        }
    }

    output(length, frame, modifiers, modifierOffsets, modifierCodes);
}

int main(int argc, char* argv[])
{
    FILE *ifp;
    char *lp;
    int length = 0;

    /* check usage */
    if (argc != 2)
    {
        fprintf(stderr, "TEA for DOS database unbuilder v1.01\nUsage: TEAUNBLD <database_file>\n");
        exit(1);
    }

    /* open TEA input file */
    if ((ifp = fopen(argv[1], "rb")) == NULL)
    {
        fprintf(stderr, "Couldn't open \"%s\" for input\n", argv[1]);
        exit(1);
    }

    /* the length of the encoded words comes from the file suffix */
    if ((lp = strrchr(argv[1], '.')) != NULL)
        length = atoi(lp+1);
    if (length < 1) 
    {
        fprintf(stderr, "Couldn't decode word length in \"%s\"\n", argv[1]);
        exit(1);
    }

    decode(ifp, length);

    return(0);
}
