

     NAME
       man - display online manual documents

     SYNOPSIS
       man [-x] [-s] <name>
       man -k <search string>
       man -d
       man -?


     DESCRIPTION

       Man is patterned after the Unix command of the same name.  Its
       purpose is to search for online manual documents and display them
       using an external viewer such as Vernon Buerg's LIST.COM


       Man supports the following options:

       -d    Displays debug information

       -x    Displays what files man is searching for.

       -s    Process all subdirectories for each entry in MANPATH.

       -k    Perform keyword search on `search string'.  For every path in
             MANPATH, and subdirectories if the -s option is active, man
             looks for the file `descript.ion'.  If the file is found, it
             is searched for <search string>.  Any lines containing
             <search string> will be printed to the screen.

       -?    Displays help information.



     VARIABLES
       The operation of man is controlled through a set of variables.
       These variables can be defined in the DOS environment or in a
       configuration file located in the directory specified by the HOME
       environment variable.  When man starts, it looks for the HOME
       variable and if found, searches that directory for a file called
       `man.cfg'.  If the configuration file is found the variables are
       read from the file, otherwise the environment is used.

       MANPATH     Defines the directories to search.  Multiple
                   directories can be specified by delimiting
                   each entry with a semicolin.  If not defined,
                   the current directory is used.

                   Example:
                   To have man search the directories c:\doc and
                   d:\doc...

                       set MANPATH=c:\doc;d:\doc

       MANTYPE     Defines the extensions to be considered as
                   manual pages.  Only the extension is
                   specified, not the delimiter (.).  Multiple
                   extensions can be specified by delimiting each
                   entry with a semicolin.  If not defined,
                   defaults to 'man'.

                   Example:
                   To have man search for *.doc & *.txt in the
                   MANPATH directories...

                       set MANTYPE=doc;txt

       MANPAGER    Defines the output program to be used for
                   displaying pages.  Any option switches needed
                   by the pager may be placed on the line also.
                   The program must reside in one of the
                   directories listed in the PATH variable.  If
                   not defined, defaults to 'list'.

       MANCFG      Defines the default switch options. This
                   primarily useful with the -s switch option to
                   force subdirectory searches.

                   Example:
                   To force subdirectory searches by default...

                       set MANCFG=s


     CONFIGURATION FILE
       The format of the configuration file, `man.cfg', is the same as
       that for the DOS SET command (ie; VAR=STRING).  Each line must
       contain only one variable.


     ERRORS
       Possible exit status values are:

       0      Successful completion
       1      No manual entry found
       2      Unknown commandline option
       3      Error reading file
       4      No filename supplied
