	Name nonull
	Title	Null (0) stripping filter.
	page	,132
Comment ~

	This program is a filter that removes all occurrances
	of the ASCII character 0 from its output stream.
	It will optionally accept a filename from which to read
	input.  All output goes to the 	standard output device
	unless redirected.

	Examples:
		nonull abc.txt	read input from abc.txt,
				output goes to screen.
		nonull abc.txt >abcnew.txt
				read input from abc.txt,
				output goes to abcnew.txt.
		nonull <abc.txt >abcnew.txt
				same as previous example
Toad Hall Tweak, Oct 89
 - Bumping working buffer to BIG...
 - Simplistic PSP command line parsing didn't properly handle
   DOS redirection/filter usage.  Fixed.
 - No reason at all to release memory .. unless maybe for filters??
 - v1.2 replaces Ctrl Z's with an innocuous space.
   Cleaner code but not significantly faster than v1.1's lodsb/test/stosb
   loop!
   If you don't wish this function and wish the Ctrl Z's truly deleted,
   use v1.1.

Nonull produced from NOCZ, replacing Ctrl-Z replacement
with NULL (Ascii 0) replacement.

David Kirschbaum
Toad Hall
kirschd@hq.ljl.com

~

CR	equ	0DH
LF	equ	0AH
STDOUT	equ	1		;Standard Output (normally console)	v1.2

;===================================================================
	CSEG	segment	public para 'CODE'
;===================================================================
;
;	command line is at 80h of psp - first byte is length
;
	ORG	80h

cmdline	label	byte			;				v1.1

	ORG	100h			; com file starts here
	ASSUME	CS:CSEG,DS:CSEG,ES:CSEG

NoNull	proc	near			;v1.1

	mov	AH,30h			; get dos version
	int	21h
	cmp	AL,2			; must be at least 2.0
	jb	Oops

	call	Parse_CmdLine		;parse cmdline for target filename v1.1
					;(will give help and die if NO
					;filename or redirection)

	xor	bp,bp			;assume StdIn handle		v1.1
	or	dx,dx			;did we get a name?		v1.1
	jz	Save_Handle		;nope, use StdIn		v1.1

;v1.1	else DX -> filename start

; now try to open the file

	mov	ax,3D00H		;open file, read only		v1.1
	int	21h			; invoke function
	jc	Oops			; open error - quit

	mov	bp,ax			;keep file handle in BP		v1.1

Save_Handle:				;				v1.1
	mov	DX,offset buffer	;DX -> read/write buffer	v1.1

Again:
	mov	BX,bp	;handle		; read from standard input or file v1.1
	mov	CX,BUFSIZ		; # of characters to read	v1.1
	mov	AH,3Fh			; dos read function
	int	21h			; invoke function
	jc	Oops			; error!  (error value in AL)	v1.1
	or	ax,ax			; if zero, end of file		v1.1
	jz	Oops			; (errorlevel 0)		v1.1

;v1.2	Instead of the lodsb/test/stosb loop in v1.1,
;	we'll use the more elegant scasb function to seek out
;	those Ctrl Z's.

	mov	si,ax			;save nr chars read		v1.2
	mov	CX,AX			; CX contains # characters read
;	mov	ax,201AH		; AL = Ctrl Z to scan for	v1.2
	mov	ax,2000H		; AL = 0 to scan for		v1.3
					; AH = space replacement	v1.2
	mov	di,dx	;offset buffer	; ES:DI is buffer to scan	v1.2
	mov	bx,-1			; to point (DI:BX) to prev char	v1.2

ScanLup:
	repne	scasb			;find first Ctrl Z		v1.2
	jnz	Skip			;none found, done		v1.2
	 mov	[di][bx],ah		;replace with a space		v1.2
	 or	cx,cx			;all done?			v1.2
	 jnz	ScanLup			;nope, back for more		v1.2

Skip:
	mov	cx,si			; orig nr chars read		v1.2
	mov	bx,STDOUT		; standard output device	v1.2
	mov	AH,40h			; dos write function
	int	21h			; invoke dos function

	jnc	Again			; if no write error ..		v1.1
					; repeat until EOF or read error v1.1

Oops:
	mov	ah,4CH			;terminate (errorlevel in AL)	v1.1
	int	21H			;				v1.1

NoNull	endp				;				v1.1

	even				;				v1.1

buffer	LABEL	NEAR

BUFSIZ	equ	NOT ($ - CSEG + 256)	;use full segment		v1.1
					;minus 256-byte stack
					;and program size

;v1.1	Parse commandline for target filename
;	Handle redirection spaces

Parse_CmdLine	proc	near

	mov	si,offset cmdline	;cmd parm length byte
	lodsb				;snarf length byte
					;(SI -> 1st char)
	xor	ah,ah			;clear msb
	mov	cx,ax			;cmdline length is loop counter
	jcxz	Help			;no cmdline, give help and die

;v1.1	When redirection happens, DOS leaves spaces instead of simply
;	a null line!
;	Gotta allow for that by gobbling leading spaces.
;	If spaces is all we had .. we have redirection!

	xor	dx,dx			;clear DX (don't have a name)
	mov	ah,20H			;handy constant

ParseLup:
	lodsb				;snarf cmdline char
	cmp	al,ah			;space?
	jz	Relup			;yep, skip it
	 cmp	al,CR			;terminating CR? (no name)
	 jnz	Got_Name		;nope, must be real name
Relup:
	loop	ParseLup		;do all cmdline chars

;If we fall thru .. there were only spaces (redirection).

	ret				;with DX = 0 (no name)

;SI -> target filename's first char (non-space)

Got_Name:
	mov	dx,si			;DX -> filename's first char +1
	dec	dx			;back up to real first char
	mov	ax,CR			;scan for terminating CR
					;AH=0
Name_Lup:
	cmp	[si],al			;terminating CR?
	jz	AsciiZ_Name		;yep, stuff a 0 there
	 inc	si			;bump filename ptr
	 loop	Name_Lup		;nope, keep going

;If we fell through .. something is SEVERELY wrong with our
;command line count!  Shouldn't ever happen.

AsciiZ_Name:
	mov	[si],ah			;AsciiZ the name
	ret
	
Parse_CmdLine	endp


;v1.1	Provide help if no cmd line parms

Help	proc	near			;				v1.1
	mov	dx,offset help$		;help msg
	mov	ah,9			;display msg
	int	21H
	mov	ax,4C00H		;terminate (errorlevel 0)	v1.1
	int	21H			;				v1.1

help$	db	'NoNull v1.0- strips NULL (#0) characters from a file,',CR,LF
	db	'replacing them with spaces.',CR,LF
	db	'Usage:  nonull [<] filename.typ [>output]',CR,LF
	db	'Input may be a proper path:\filename or redirection.',CR,LF
	db	'Output may be redirected as desired (default CON:).'
	db	CR,LF,'$'

Help	endp

CSEG	ENDS
	END	NoNull
