'STRIPPER cleans blank lines, extra spaces or selected columns out of a file  
'
' $INCLUDE: 'qb.bi'

DECLARE FUNCTION exists (filename$)

DIM SHARED inregs AS RegTypeX, outregs AS RegTypeX
CONST YES = 1, NO = 0
	 
	  com$ = UCASE$(COMMAND$)
	  length = LEN(com$)
	  max = 10
	  DIM arg$(max)
	  true = -1: false = 0: i = 1: num = 1: inword = true
	  WHILE i <= length
			 ch$ = MID$(com$, i, 1)
			 IF ch$ <> " " THEN
					IF NOT inword THEN inword = true
					arg$(num) = arg$(num) + ch$
			 ELSEIF inword THEN
					num = num + 1
					inword = false
			 END IF
			 i = i + 1
	  WEND
	  y = 1
	  GOTO FRONTEND
help:
	  PRINT " "
	  PRINT "STRIPPER strips columns, extra spaces or blank lines in a file."
	  PRINT "(c) 1990 David A. Wesson"
	  PRINT " "
	  PRINT "Syntax: STRIPPER  [d:]filename  [option]"
	  PRINT " where  filename = original file  [drive optional]"
	  PRINT "          option = B  for strip BLANK LINES"
	  PRINT "                   S  for strip EXTRA SPACES"
	  PRINT "                   C  #1  #2  for stripping COLUMNS starting"
	  PRINT "                              in column #1 and ending in #2."
	  PRINT "                              If #1 = #2 or #2 is omitted then"
	  PRINT "                              only one column is stripped."
	  PRINT ""
	  PRINT "        If option is omitted, then the program will prompt you."
	  PRINT "        "
	  PRINT "NOTE: This program makes a backup of the file named filename.OLD"
	  END

FRONTEND:
	  IF arg$(1) = "" THEN
			GOTO help
	  ELSE
			infile$ = UCASE$(arg$(1))
			IF exists(infile$) = NO THEN GOTO nofind
			OPEN infile$ FOR INPUT AS #1
			outfile$ = "temp"
			OPEN outfile$ FOR OUTPUT AS #2
			GOSUB filename
			oldfile$ = UCASE$(file$) + ".OLD"
	  END IF
	 
	  SELECT CASE ag$(2)
			CASE "": GOTO LONGFORM
			CASE "B": GOTO BLANKLINE
			CASE "S": GOTO EXTRASPACE
			CASE "C": GOTO COLUMNS
			CASE ELSE: GOTO help
	  END SELECT
'***************************** BLANKLINE STRIPPER ***************************
BLANKLINE:
	  CLS : COLOR 15: PRINT "STRIPPER "; : COLOR 7
	  PRINT "stripping BLANKLINES from "; infile$; ", creating "; oldfile$
	  PRINT "Hit [Ctrl] + [Break] to terminate run."
	  PRINT "Starting time: "; TIME$
	  PRINT " Process line: "
BLANKCYCLE:
	  IF EOF(1) THEN GOTO FINISH
			 LINE INPUT #1, inline$
					l = LEN(inline$)
					x = x + 1: blank = 0
CUTBLANK:
	  IF l = 0 OR LEFT$(inline$, 1) = CHR$(13) OR LEFT$(inline$, 1) = CHR$(10) THEN GOTO BLANKCYCLE
	  FOR col = 1 TO LEN(inline$)
			IF MID$(inline$, col, 1) = CHR$(32) THEN
				  blank = 1
				  ELSE GOTO OUTBLANK
			END IF
	  NEXT
	  IF blank = 1 THEN GOTO BLANKCYCLE
OUTBLANK:
			 PRINT #2, inline$
			 y = y + 1
			 LOCATE 4, 15: PRINT y
			 GOTO BLANKCYCLE
'*************************** EXTRA SPACE STRIPPER ****************************
EXTRASPACE:
	  CLS : COLOR 15: PRINT "STRIPPER "; : COLOR 7
	  PRINT "stripping EXTRA SPACES from "; infile$; ", creating "; oldfile$
	  PRINT "Hit [Ctrl] + [Break] to terminate run."
	  PRINT "Starting time: "; TIME$
	  PRINT " Process line: "
SPACECYCLE:
	  WHILE NOT EOF(1)
			 LINE INPUT #1, inline$
					l = LEN(inline$)
CUTSPACE:
	  WHILE RIGHT$(inline$, 1) = CHR$(32)
			 inline$ = LEFT$(inline$, l - 1)
			 l = l - 1
	  WEND
 IF INSTR(inline$, CHR$(32)) = 0 THEN GOTO OUTSPACE
	  FOR x = 1 TO l - 1
  char$ = MID$(inline$, x, 1): next$ = MID$(inline$, x + 1, 1)
  IF char$ = CHR$(32) AND next$ = CHR$(32) THEN
	inline$ = LEFT$(inline$, x) + RIGHT$(inline$, l - x - 1)
	l = l - 1: x = x - 1
			 END IF
	  NEXT
OUTSPACE:
			 PRINT #2, inline$
			 y = y + 1
			 LOCATE 4, 15: PRINT y
		WEND
		GOTO FINISH
'*********************** COLUMNS STRIPPER ************************************
COLUMNS:
	  a = VAL(arg$(3))
	  b = VAL(arg$(4))
			 IF a = 0 THEN GOTO MISSCOL
			 IF b = 0 THEN b = a
			 IF a > b THEN GOTO BADCOL
	  CLS : COLOR 15: PRINT "STRIPPER "; : COLOR 7
	  PRINT "stripping COLUMNS"; a; "to"; b; "from "; infile$; ", creating "; oldfile$
	  PRINT "Hit [Ctrl] + [Break] to terminate run."
	  PRINT "Starting time: "; TIME$
	  PRINT " Process line: "
	  a = a - 1: b = b + 1
CUTCOL:
	  IF EOF(1) THEN GOTO FINISH
			 LINE INPUT #1, inline$
					a$ = LEFT$(inline$, a)
					b$ = MID$(inline$, b)
					outline$ = a$ + b$
OUTCOL:
			 PRINT #2, outline$
			 y = y + 1
			 LOCATE 4, 15: PRINT y
			 GOTO CUTCOL
'************************** PROMPT FOR INPUT FORMAT ***************************
LONGFORM:
	  CLS
	  GOSUB DRAWFRAME
	  LOCATE 1, 33: PRINT "[ STRIPPER ]"
	  LOCATE 3, 31: COLOR 15: PRINT "[ INTRODUCTION ]": COLOR 7
	  LOCATE 6, 10: PRINT "STRIPPER is a utility package for manipulating ASCII text files."
	  LOCATE 7, 10: PRINT "  "
	  LOCATE 8, 10: PRINT "There are three functions you can call:"
	  LOCATE 10, 10: PRINT "       [1]  Strip all BLANK LINES from file"
	  LOCATE 12, 10: PRINT "       [2]  Strip all EXTRA SPACES from file"
	  LOCATE 14, 10: PRINT "       [3]  Strip selected COLUMNS from file"
	  LOCATE 18, 17: PRINT "(c) 1990 David A. Wesson"
	  LOCATE 19, 17: PRINT "Type STRIPPER for instructions to bypass this menu."
SELECTONE:
	  LOCATE 22, 20: COLOR 15: PRINT "Select a NUMBER or [Esc] key to EXIT.": COLOR 7
	  GOSUB in
	  SELECT CASE in$
			CASE CHR$(27):
				 CLS
				 COLOR 15
				 PRINT "OK, thanks for visiting STRIPPER."
				 COLOR 7
				 END
			CASE "1": GOTO BLANKLINE
			CASE "2": GOTO EXTRASPACE
			CASE "3": GOTO LONGPROMPT
			CASE ELSE: GOTO SELECTONE
	  END SELECT
LONGPROMPT:
	  GOSUB CLEAR22
	  GOSUB CLEARALL
	  LOCATE 10, 15: INPUT "Input column to START stripping: ", arg$(3)
	  LOCATE 15, 15: PRINT "hit [Return] for FINISH."
	  LOCATE 14, 15: PRINT "To strip just one column,"
	  LOCATE 12, 15: INPUT "Input column to FINISH stripping: ", arg$(4)
	  GOTO COLUMNS
'*************************** GENERAL SUBROUTINES ******************************
DRAWFRAME:
	  LOCATE 1, 1, 0, 8: PRINT CHR$(201); STRING$(77, 205); CHR$(187)
	  FOR x = 2 TO 22: LOCATE x, 79: PRINT CHR$(186): NEXT
	  FOR x = 22 TO 2 STEP -1: LOCATE x, 1: PRINT CHR$(186): NEXT
	  LOCATE 23, 1: PRINT CHR$(200); STRING$(77, 205); CHR$(188)
	  LOCATE 3: PRINT CHR$(199); STRING$(77, 196); CHR$(182)
	  LOCATE 21: PRINT CHR$(199); STRING$(77, 196); CHR$(182)
	  RETURN
CLEARALL:
	  FOR x = 20 TO 4 STEP -1: LOCATE x, 2: PRINT STRING$(77, 0): NEXT: RETURN
CLEAR22:
	  LOCATE 22, 2: PRINT STRING$(77, 0): RETURN
in:
	  in$ = INKEY$: IF in$ = "" THEN GOTO in ELSE RETURN
filename:                                         'splits infile$ into
		  period = INSTR(infile$, ".")              'file$ and ext$
		  IF period = 0 THEN
					file$ = infile$
					ext$ = ""
					ELSE
						  file$ = LEFT$(infile$, period - 1)
						  ext$ = MID$(infile$, period + 1)
		  END IF
		  RETURN
nofind:
	  PRINT "ERROR: No file by that name found."
	  GOTO help
MISSCOL:
	  PRINT "ERROR: Missing column specifier."
	  GOTO help
BADCOL:
	  PRINT "ERROR: ENDCOL must be equal to or larger than STARTCOL."
	  GOTO help
FINISH:
	  CLOSE
	  IF exists(oldfile$) THEN KILL oldfile$
	  NAME infile$ AS oldfile$
	  NAME outfile$ AS infile$
	  PRINT "Finish time  : "; TIME$
	  END

FUNCTION exists (search$)
	 savefile$ = search$
	 inregs.ax = &H4E00
	 inregs.cx = 1     '3 for hidden
	 search$ = search$ + CHR$(0)
	 inregs.dx = SADD(search$)
	 inregs.ds = -1
	 CALL INTERRUPTX(&H21, inregs, outregs)
	 IF (outregs.flags AND 1) = 1 THEN
			exists = NO
	 ELSE
			exists = YES
	 END IF
	 search$ = savefile$
END FUNCTION

