{$A+,B-,D+,E+,F-,G+,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V+,X+}
{$M 16384,0,655360}

{
SPHERE.PAS
Demonstrates 	- sprite loading
		- sprite chaining
		- higher level of sprite encapsulation
}


uses	crt,uve32;

const	maxspheres=20;

type	spheretype=record
		x,y,
		forcex,forcey:longint;
	end;

var	sphere:array[1..maxspheres] of spheretype;

procedure init;
var	pal:palette;
	i:integer;
begin
	ia_inituve;
	ia_loadspr('sphere.uvl',1);
	ia_loadpalette('sphere.pal',pal);
	ia_chainsprite(1,spritesloaded,1);
	ia_powerup;
	ia_setpalette(pal);
	ia_setcycletime(40);
	for i:=1 to maxspheres do with sphere[i] do begin
		x:=longint(random(320))*256;
		y:=longint(random(180))*256;
		forcex:=(longint(random(10))-5)*256;
		forcey:=(longint(random(10))-5)*256;
		spr[i].n:=1+random(30);
	end;
end;

procedure deinit;
begin
	ia_shutdown;
	halt;
end;


procedure movespheres;
var	i:integer;
begin
	for i:=1 to maxspheres do with sphere[i] do begin
		inc(x,forcex);
		inc(y,forcey);
		if (y>200*256) and (forcey>0) then
			forcey:=-forcey
			else inc(forcey,64);
		if (x<0) and (forcex<0) then forcex:=-forcex;
		if (x>320*256) and (forcex>0) then forcex:=-forcex;
		ia_center(i,x div 256,y div 256,2);
	end;
end;

begin
	init;
	repeat
		movespheres;
		ia_doframe;
	until keypressed;
	deinit;
end.