{ ͻ
   Programmer Tony Papadimitriou                             
   Program    WHERE                                          
   Uses       Dos, TPUtils, TPRecDir                         
   Includes   Nothing                                        
   Links      Nothing                                        
   Created    Sunday, December 19, 1993  2:08 am             
   Updated    Saturday, December 25, 1993  3:50 pm           
   Language   (MSDOS) Turbo Pascal 6.0                       
   Purpose    Show off TPRecDir unit                         
   Version History Ķ
   1.00       Original                                       
  ͼ }
uses
  Dos,
  TPUtils,
  TPRecDir;

const
  progName = 'WHERE';
  version  = '1.00';

procedure Copyright;
begin
  Writeln(stderr);
  Writeln(stderr,progName+' ver. ' + version + '  Copyright (c) 1993-94 by Tony G. Papadimitriou *FREEWARE*');
  Writeln(stderr);
end; { Copyright }

var
  totalMatches: Longint;

{ --- this is the user routine whose address you must supply to ForEachFileIn }
function List(rec: SearchRec): Boolean; far;
begin
  List := True;
  ShowProgressHere;
  if not AttributeMatches(rec.attr,Directory) then
  begin
    Inc(totalMatches);
    BlankLine;
    Writeln(FExpand(rec.name));
    Write(stderr,'Working  ');
  end;
end; { List }

var
  path : PathStr;
  mask : String;
begin
  Copyright;
  if ParamCount = 0 then
  begin
    Writeln(stderr,'Usage: WHERE [<path>\]<mask>[;<mask>]');
    Writeln(stderr);
    Writeln(stderr,'       Press ESC during search to interrupt prematurely.');
    Halt;
  end; { if }
  totalMatches := 0;
  path := ParamStr(1);
  mask := GetMask(path);
  path := GetPath(path);
  Write(stderr,'Working  ');
  ForEachFileIn(path,mask,AnyFile,True,True,@List);
  BlankLine;
  if errorsFound then Writeln(stderr,'Errors during processing!');
  Writeln(stderr,totalMatches,' match'+OneManyStr(totalMatches,'','es')+' found!');
end.
