{ ͻ
   Programmer Tony Papadimitriou                             
   Program    LDIR                                           
   Uses       Dos, TPUtils, TPRecDir                         
   Includes   Nothing                                        
   Links      Nothing                                        
   Created    Sunday, December 19, 1993  2:08 am             
   Updated    Saturday, December 25, 1993  3:50 pm           
   Language   (MSDOS) Turbo Pascal 6.0                       
   Purpose    Show off TPRecDir unit                         
   Version History Ķ
   1.00       Original                                       
  ͼ }
uses
  Dos,
  TPUtils,
  TPRecDir;

const
  progName = 'LDIR';
  version  = '1.00';

procedure Copyright;
begin
  Writeln(stderr);
  Writeln(stderr,progName+' ver. ' + version + '  Copyright (c) 1993-94 by Tony G. Papadimitriou *FREEWARE*');
  Writeln(stderr);
end; { Copyright }

var
  archives,              { number of archive matches }
  hiddenfiles,           { number of hidden files }
  sysfiles,              { number of system files }
  readonlys,             { number of read-only files }
  dirs,                  { number of directories (any attribute) }
  files:       Longint;  { number of files (any attribute) }

{ --- this is the user routine whose address you must supply to ForEachFileIn }
function List(rec: SearchRec): Boolean; far;
  { 1 } procedure PrintAttr(attr,testAttr: Word; printChar: Char; var counter: Longint);
        begin
          if AttributeMatches(attr,testAttr) then
          begin
            Write(printChar);
            Inc(counter);
          end
          else
            Write('-');
        end; { PrintAttr }
begin
  List := True;
  if AttributeMatches(rec.attr,Directory) then
    Inc(dirs)
  else
  begin
    PrintAttr(rec.attr,Archive, 'A',archives);
    PrintAttr(rec.attr,SysFile, 'S',sysfiles);
    PrintAttr(rec.attr,Hidden,  'H',hiddenfiles);
    PrintAttr(rec.attr,ReadOnly,'R',readonlys);
    Inc(files);
    Writeln('  ',FExpand(rec.name));
  end;
end; { List }

var
  counter: Longint;
  path   : String;
  mask   : String;
begin
  Copyright;
  if ParamCount = 0 then
  begin
    Writeln(stderr,'Usage: LDIR [<path>\]<mask>[;<mask>]');
    Writeln(stderr);
    Writeln(stderr,'       Press ESC during search to interrupt prematurely.');
    Halt;
  end; { if }
  archives    := 0;
  hiddenfiles := 0;
  sysfiles    := 0;
  readonlys   := 0;
  dirs        := 0;
  files       := 0;
  path := ParamStr(1);
  mask := GetMask(path);
  path := GetPath(path);
  counter := ForEachFileIn(path,mask,AnyFile,True,True,@List);
  if errorsFound then Writeln(stderr,'Errors during processing!');
  Writeln(stderr,'Processed ',dirs,' dir'+OneManyStr(dirs,'','s')+
                 ' and ',files,' file'+OneManyStr(files,'','s')+
                 ' for a total of ',counter,' match'+OneManyStr(counter,'','es'));
  Writeln(stderr);
  Writeln(stderr,'In detail by attribute they are broken down as follows:');
  Writeln(stderr,'');
  Writeln(stderr,'Archives:        ',archives);
  Writeln(stderr,'Hidden:          ',hiddenfiles);
  Writeln(stderr,'System files:    ',sysfiles);
  Writeln(stderr,'Read-only files: ',readonlys);
end.
