{----------------------------------------------------------------------------
 |  Program DEMOV3.PAS                                                      |
 |                                                                          |
 |  This program demonstrates some of the capabilities of TPHRT.            |
 |                                                                          |
 |  (c) 1989 Ryle Design, P.O. Box 22, Mt. Pleasant, Michigan 48804         |
 |                                                                          |
 |  V3.00 Shareware Evaluation Version                                      |
 ----------------------------------------------------------------------------}

uses
    CRT, TPHRT;

var
    hits, elapsed : longint;
    indx          : integer;
    tstring       : string;
    atom          : char;

procedure sin_funct;
{----------------------------------------------------------------------------
 |  A simple procedure to time.   TPHRT will tell us how many this function |
 |  was called and how much time we spent here.                             |
 |                                                                          |
 |  Globals referenced: none                                                |
 |                                                                          |
 |  Arguments: void                                                         |
 |                                                                          |
 |  Returns  : void                                                         |
 ----------------------------------------------------------------------------}
var
    alpha : real;

begin

	t_entry(5);                                             { start a timer }

    alpha := sin(2.2734593);                                { do something  }

	t_exit(5);                                              { stop timer    }

end; { sin_funct }


begin

    t_request(5);                                           { ask for 5 timers - default is 10 }
    t_start;                                                { turns on TPHRT }
	t_entry(1);                                             { use  timer 1 to time whole run }

    writeln('TPHRT V3.00 demonstration');
    write('Press any key ... ');

	t_entry(3);                                             { start timer # 3 }
    atom := readkey;
	t_exit(3);                                              { stop timer # 3 }
    writeln;

	t_ask_timer(3,hits,elapsed);                            { query timer # 3 }

    writeln('Response time was ',elapsed,' microseconds, or ',t_cvt_time(elapsed,tstring));

    write('Calling sin function with embedded timer 100 times ... ');
    for indx := 1 to 100 do sin_funct;
    writeln('complete.');

    writeln;
    write('Press any key to generate timer reports >> ');
    atom := readkey;
    writeln;

    t_exit(1);                                              { stop run time timer }

    t_rname('TPHRT Demonstration - HIGHWATER report type'); { title timer report }
	t_name(1,'Total run time');                             { give each timer a name }
	t_name(3,'Keyboard response');
	t_name(5,'sin function');

    t_report(0);                                            { do report - 0 goes to CRT }

	t_set_report(NONZERO);
    t_rname('TPHRT Demonstration - NONZERO report type');
    t_report(0);

    t_stop;

    writeln('TPHRT demo complete.');

end. { demov3 }

