UNIT DListOBJ ;




{**********************************************************************
 *                                                                    *
 *  PROGRAM :  DListOBJ                PC FILE NAME :  DListOBJ.PAS   *
 *  ----------------------------------------------------------------  *
 *  LIBRARY MODULES USED :  DOS CRT                                   *
 *  BaseType :  TP6.0 TPU SOURCE: BASETYPE.PAS  BINARY:  BASETYPE.TPU *
 *  ----------------------------------------------------------------  *
 *  PURPOSE :  The purpose of this UNIT is to provide a Doublely-     *
 *             Linked list object that uses a common base and base    *
 *             element type.                                          *
 *  ----------------------------------------------------------------  *
 *  AUTHOR   :  Thomas E. Jenkins, Jr.                                *
 *              PROGRAMMER, UNIVERSITY OF SOUTH CAROLINA, USA         *
 *  BITNET   :  C0361@UNIVSCVM.BITNET                                 *
 *  INTERNET :  C0361@univscvm.csd.scarolina.EDU                      *
 *              tomj@csdserver3.csd.scarolina.EDU                     *
 *  ----------------------------------------------------------------  *
 *  DISCAIMER :  This program has been tested to the best of my       *
 *               abilities.  The author claims no responsibility      *
 *               for the performance or side effects this program     *
 *               may yield.                                           *
 *  ----------------------------------------------------------------  *
 *  DISTIBUTION :  This program is given freely to the PD realms.     *
 *                 It may freely be copied and distributed.  Any      *
 *                 one wishing to use some or whole parts of this     *
 *                 program for commercial use please contact the      *
 *                 author first.                                      *
 *                                                                    *
 **********************************************************************}




                                  INTERFACE






             {


                 Here is a basic view of the DList object tree:

                 TObject                    [ to allow use with streams   ]
                    |
                    |
                    \___ TBaseOBJ           [ basic functions of Queue &  ]
                             |              [ elements                    ]
                             |
                             \___ TElementOBJ    [ basic functionality of ]
                             /         |         [ any element            ]
                             |         |
                             |         \___ TStrOBJ [ string specific     ]
                             |         /            [ functions & storage ]
                             |         |
                             |         |
                             |         \___ TIntOBJ [ integer specific    ]
                             |         /            [ functions & storage ]
                             |         |
                             |         |
                             |         \___ TRealOBJ [ Real specific      ]
                             |                       [ functions & storage]
                             |
                             |
                             \___ TDListOBJ      [ DList specific         ]
                                                 [ functions & storage    ]

             }


USES
       BaseTypes ;



TYPE

       PDListOBJ                       = ^TDListOBJ ;
       TDListOBJ                       = OBJECT ( TBaseOBJ )

         current                       : PElementOBJ ;

         CONSTRUCTOR Init ;

         PROCEDURE   Add (     item    : PElementOBJ ) ;
           VIRTUAL ;

         FUNCTION    NextOne           : BOOLEAN ;
           VIRTUAL ;

         FUNCTION    PrevOne           : BOOLEAN ;
           VIRTUAL ;

         FUNCTION    Get               : PElementOBJ ;
           VIRTUAL ;

         PROCEDURE   Delete ;
           VIRTUAL ;

         FUNCTION    Empty             : BOOLEAN ;
           VIRTUAL ;

         FUNCTION    TheType           : WORD ;
           VIRTUAL ;

         PROCEDURE   SetData (     d   : POINTER ) ;
           VIRTUAL ;

         DESTRUCTOR  Done ;
           VIRTUAL ;

         END ;  {  TDListOBJ  }




                                IMPLEMENTATION




 CONSTRUCTOR TDListOBJ.Init ;

   BEGIN  {  TDListOBJ.Init  }

     current := NIL ;

     END ;  {  TDListOBJ.Init  }




 PROCEDURE   TDListOBJ.Add (     item  : PElementOBJ ) ;

  BEGIN  {  TDListOBJ.Add  }

    IF ( current = NIL )
     THEN
      BEGIN

        current := item ;

        Exit ;

        END ;  {  THEN  }

    IF ( current^.next = NIL )
     THEN
      BEGIN

        item^.last := current ;
        current^.next := item ;

        current := item ;

        Exit ;

        END ;  {  THEN  }

    current^.next^.last := item ;
    item^.next := current^.next ;
    item^.last := current ;
    current^.next := item ;

    current := item ;

    END ;  {  TDListOBJ.Add  }




 FUNCTION    TDListOBJ.Get                       : PElementOBJ ;

  BEGIN  {  TDListOBJ.Get  }

    Get := current ;

    IF ( Empty )
     THEN
        Exit ;

    Delete ;

    END ;  {  TDListOBJ.Get  }



 PROCEDURE   TDlistOBJ.Delete ;

   BEGIN  {  TDlistOBJ.Delete  }

    IF ( ( current^.next = NIL ) AND
         ( current^.last = NIL ) )
     THEN
      BEGIN

        current := NIL ;

        Exit ;

        END ;  {  THEN  }

     IF ( current^.next = NIL )
      THEN
       BEGIN

         current^.last^.next := NIL ;
         current := current^.last ;

         Exit ;

         END ;  {  THEN  }

     IF ( current^.last = NIL )
      THEN
       BEGIN

         current^.next^.last := NIL ;
         current := current^.next ;

         Exit ;

         END ;  {  THEN  }

     current^.next^.last := current^.last ;
     current^.last^.next := current^.next ;

     current := current^.next ;

     END ;  {  TDlistOBJ.Delete  }




 FUNCTION    TDListOBJ.Empty                     : BOOLEAN ;

  BEGIN  {  TDListOBJ.Empty  }

    Empty := ( current = NIL ) ;

    END ;  {  TDListOBJ.Empty  }




 FUNCTION    TDlistOBJ.TheType         : WORD ;

   BEGIN  {  TDlistOBJ.TheType  }

     TheType := current^.TheType ;

     END ;  {  TDlistOBJ.TheType  }



 PROCEDURE   TDlistOBJ.SetData (     d : POINTER ) ;

   BEGIN  {  TDlistOBJ.SetData  }

     current^.SetData ( d ) ;

     END ;  {  TDlistOBJ.SetData  }




 DESTRUCTOR  TDListOBJ.Done ;

   BEGIN  {  TDListOBJ.Done  }

     IF ( Empty )
      THEN
         Exit ;

     WHILE ( PrevOne )
      DO ;

     WHILE ( NOT ( Empty ) )
      DO
         Dispose ( Get , Done ) ;

     current := NIL ;

     END ;  {  TDListOBJ.Done  }




 FUNCTION    TDListOBJ.PrevOne         : BOOLEAN ;

  BEGIN  {  TDListOBJ.PrevOne  }

    PrevOne := FALSE ;

    IF ( current^.last = NIL )
     THEN
        Exit ;

    current := current^.last ;

    PrevOne := TRUE ;

    END ;  {  TDListOBJ.PrevOne  }




 FUNCTION    TDListOBJ.NextOne         : BOOLEAN ;

  BEGIN  {  TDListOBJ.NextOne  }

    NextOne := FALSE ;

    IF ( current^.next = NIL )
     THEN
        Exit ;

    current := current^.next ;

    NextOne := TRUE ;

    END ;  {  TDListOBJ.NextOne  }




END .