{*******************************************************************************
*   Unit name: MCGRAF10 interface
*      Author: Martin CEKAL
*        Date: January 15, 1993
*     Version: 1.0
*     Purpose: Draw line and bar charts
********************************************************************************}
UNIT GRAF10;

interface

type  hd = record
           case u:boolean of
             true:(t:string[35];);  {axis's labels}
      end;

      it = record                  {axis characteristics}
           case u:boolean of
             true:(x,y:word;
                   ns:1..10;       {number of ticks}
                   d:shortint;     {decimals of labels}
                   m:real;         {scale}
                   ni:2..10;       {number of tick's labels}
                   min,max:real;   {min and max value}
                   nh:0..3;        {number of axis's labels}
                   c:byte;         {color}
                   hds:array [1..3] of hd); {axis's labels}
      end;

      axis = record                 {Definitions of axis}
            x,y,w,h:word;           {x,y:upper left corner
                                     w:width; h:hight}
            nit:1..2;               {number of axis}
            rec:boolean;            {draw a rectangle}
            its:array[1..2] of it;  {axis's characteristics}
      end;

      gbar = record
             x,y,w,h:integer;             {x,y:upper left corner
                                           w:width; h:hight}
             d:shortint;                  {decimals of labels}
             m,min,max,xi:real;           {m:scale; min and max value
                                           xi:label in front of bar}
             c:byte;                      {color}
             p:string[5];                 {title in front of bar}
             i:array[1..3] of string[10]; {array of titles}
             nh:0..2;                     {number of headers}
             hds:array[1..2] of hd;       {headers}
      end;


{*******************************************************************************
*        Name: igraf_a
*  Parametres: o: Definition of chart
*        Date: January 14, 1993
*     Version: 1.0
*     Purpose: Initialization of line chart
********************************************************************************}
procedure igraf_a(var o:axis);

{*******************************************************************************
*        Name: graf_a
*  Parametres: xo,yo values on step I
*              xn,yn values on step I+1
*              o: Definition of chart
*        Date: January 14, 1993
*     Version: 1.0
*     Purpose: Line chart drawing
********************************************************************************}
procedure graf_a(xo,yo,xn,yn:real;o:axis);

{*******************************************************************************
*        Name: igraf_b
*  Parametres: b: Definition of bar chart
*              xi value of label
*              xx displayed value
*        Date: January 14, 1993
*     Version: 1.0
*     Purpose: Initialization of bar chart
********************************************************************************}
procedure igraf_b(var b:gbar;xi,xx:real);

{*******************************************************************************
*        Name: graf_b
*  Parametres: b: Definition of bar chart
*              xi value of label
*              xx displayed value
*        Date: January 14, 1993
*     Version: 1.0
*     Purpose: Bar chart drawing
********************************************************************************}
procedure graf_b(var b:gbar;xi,xx:real);


{*******************************************************************************
*   Unit name: MCGRAF10 implementation
*      Author: Martin CEKAL
*        Date: January 15, 1993
*     Version: 1.0
*     Purpose: Draw line and bar charts
********************************************************************************}
implementation

uses graph;

const fh=12;

{*******************************************************************************
*        Name: igraf_a
*  Parametres: o: Definition of chart
*        Date: January 14, 1993
*     Version: 1.0
*     Purpose: Initialization of line chart
********************************************************************************}
procedure igraf_a(var o:axis);
var oi,j,lght:integer;
    xi,si,hs,hi:real;
    vals:string[10];
    cl:byte;

begin
 setviewport(0,0,getmaxx,getmaxy,clipon);
 if o.rec then begin
   setviewport(o.x,o.y-o.h,o.x+o.w,o.y,clipon);
   clearviewport;
   rectangle(0,0,o.w,o.h);
 end;
 {vertical axis}
 if o.its[1].u then begin
   o.its[1].m:=o.h/(o.its[1].max-o.its[1].min);
   si:=(o.its[1].max-o.its[1].min)/(o.its[1].ni-1);
   hs:=o.h/o.its[1].ns;
   hi:=o.h/(o.its[1].ni-1);
   lght:=0;
   settextstyle(0,0,1);
   settextjustify(2,1);
   setviewport(o.its[1].x-80,o.its[1].y-o.h-5,
               o.its[1].x-2,o.its[1].y+5,clipon);
   clearviewport;
   setviewport(o.its[1].x,o.its[1].y-o.h,o.its[1].x+5,o.its[1].y,clipoff);
   cl:=getcolor;
   setcolor(o.its[1].c);
   line(0,0,0,o.h);
   for j:=1 to (o.its[1].ns+1) do
      line(0,round(hs*(j-1)),-3,round(hs*(j-1)));
   for j:=1 to o.its[1].ni do begin
      xi:=o.its[1].min+(j-1)*si;
      str(xi:0:o.its[1].d,vals);
      outtextxy(-5,o.h-round(hi*(j-1)),vals);
      if length(vals) > lght then lght:=length(vals);
   end;
   settextstyle(0,1,0);
   for j:=1 to o.its[1].nh do
      outtextxy((-fh*(o.its[1].nh-j)-(lght*8+12)),
                  round(o.h/2),o.its[1].hds[j].t);
   setcolor(cl);
 end;
{horizontal axis}
 if o.its[2].u then begin
   o.its[2].m:=o.w/(o.its[2].max-o.its[2].min);
   si:=(o.its[2].max-o.its[2].min)/(o.its[2].ni-1);
   hs:=o.w/o.its[2].ns;
   hi:=o.w/(o.its[2].ni-1);
   settextstyle(0,0,0);
   settextjustify(1,0);
   setviewport(o.its[2].x-60,o.its[2].y+5,
               o.its[2].x+o.w+30,o.its[2].y+15,clipon);
   clearviewport;
   setviewport(o.its[2].x,o.its[2].y,o.its[2].x+o.w,o.its[2].y+5,clipoff);
   cl:=getcolor;
   setcolor(o.its[2].c);
   line(0,0,o.w,0);
   for j:=1 to (o.its[2].ns+1) do
      line(round(hs*(j-1)),0,round(hs*(j-1)),3);
   for j:=1 to o.its[2].ni do begin
      xi:=o.its[2].min+(j-1)*si;
      str(xi:0:o.its[2].d,vals);
      outtextxy(round(hi*(j-1)),14,vals);
   end;
   for j:=1 to o.its[2].nh do
      outtextxy(round(o.w/2),2+fh*(j+1),o.its[2].hds[j].t);
 end;
 setcolor(cl);
 settextstyle(0,0,0);
 settextjustify(0,0);
 setviewport(0,0,getmaxx,getmaxy,clipon);
end; {*** end konec IGRAF_A ***}

{*******************************************************************************
*        Name: graf_a
*  Parametres: xo,yo values on step I
*              xn,yn values on step I+1
*              o: Definition of chart
*        Date: January 14, 1993
*     Version: 1.0
*     Purpose: Line chart drawing
********************************************************************************}
procedure graf_a(xo,yo,xn,yn:real;o:axis);
var cl:byte;
begin
  setviewport(o.x,o.y-o.h,o.x+o.w,o.y,clipon);
  cl:=getcolor;
  setcolor(o.its[1].c);
  line(round((xo-o.its[2].min)*o.its[2].m),
              o.h-round((yo-o.its[1].min)*o.its[1].m),
           round((xn-o.its[2].min)*o.its[2].m),
           o.h-round((yn-o.its[1].min)*o.its[1].m));
  setviewport(0,0,getmaxx,getmaxy,clipon);
  setcolor(cl);
end; {*** end GRAF_A ***}

{*******************************************************************************
*        Name: igraf_b
*  Parametres: b: Definition of bar chart
*              xi value of label
*              xx displayed value
*        Date: January 14, 1993
*     Version: 1.0
*     Purpose: Initialization of bar chart
********************************************************************************}
procedure igraf_b(var b:gbar;xi,xx:real);
var j:integer;
    vals:string[10];
    co:byte;
begin
  setviewport(b.x,b.y,b.x+b.w,b.y+b.h,clipoff);
  rectangle(0,0,b.w,b.h);
  line(round(b.w/2),b.h-2,round(b.w/2),b.h);
  settextjustify(1,0);
  for j:=1 to 3 do
    outtextxy(round(b.w*(j-1)/2),b.h+fh,b.i[j]);
  for j:=1 to b.nh do
    outtextxy(round(b.w/2),-fh*(b.nh-j)-4,b.hds[j].t);
  settextjustify(2,0);
  co:=getcolor;
  setcolor(b.c);
  setfillstyle(1,b.c);
  b.xi:=xi;
  str(xi:0:b.d,vals);
  outtextxy(-5,round(b.h/2)+5,vals);
  outtextxy(-10-ord(vals[0])*8,round(b.h/2)+5,b.p);
  b.m:=(b.max-b.min)/b.w;
  j:=round((xx-b.min)/b.m);
  if j=0 then j:=1;
  bar(1,3,j,b.h-3);
  setcolor(co);
  setviewport(0,0,getmaxx,getmaxy,clipon);
end; {*** end IGRAF_B ***}

{*******************************************************************************
*        Name: graf_b
*  Parametres: b: Definition of bar chart
*              xi value of label
*              xx displayed value
*        Date: January 14, 1993
*     Version: 1.0
*     Purpose: Bar chart drawing
********************************************************************************}
procedure graf_b(var b:gbar;xi,xx:real);
var cl,j:word;
    vals:string[10];
    co:byte;
begin
  co:=getcolor;
  setcolor(b.c);
  setviewport(b.x+1,b.y+3,b.x+b.w-1,b.y+b.h-3,clipon);
  clearviewport;
  setfillstyle(1,b.c);
  j:=round((xx-b.min)/b.m);
  if j=0 then j:=1;
  bar(1,0,j,b.h-6);
  setviewport(b.x,b.y,b.x+b.w,b.y+b.h,clipoff);
  settextjustify(2,0);
  cl:=getcolor;
  setcolor(getbkcolor);
  for j:=1 to 2 do begin
    str(b.xi:0:b.d,vals);
    outtextxy(-5,b.h div 2+5,vals);
    outtextxy(-10-ord(vals[0])*8,b.h div 2+5,b.p);
    setcolor(cl);
    b.xi:=xi;
  end;
  setcolor(co);
  setviewport(0,0,getmaxx,getmaxy,clipon);
  settextjustify(0,0);
end; {*** end GRAF_B ***}

End. {*****konec UNIT GRAF10*****}
