{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Sample/Classrg1.pas              [x] Protected mode

  This is a sample class register that maintains arbitrary information
  referenced by identity numbers (word sized). This class is abstract
  and you'll have to add member fields for your data (or instance link).

  tClassReg is a sample component that shows you how to create
  class registers.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFKERNEL;


type pClassReg = ^tClassReg;
     tClassReg = object (tObject)

       { This is a recursive class register. It maintains a
         register of arbitrary information. To create your
         own registration class, extend this class to a new
         class, and add your own member fields, eg. fInstance
         (pObject) or fInteger (integer).

         tClassReg is ordered according to the identity of the
         registration records (the fIdentity member field). }

       public

         {#Z Constructors and destructors }
         constructor Initialize (What : word);                  { Initializes and constructs an instance of this type. }
         destructor  Intercept; virtual;                        { Intercepts and destructs an instance of this type. }

         {#Z Register handling methods }
         procedure   Register (What : pClassReg);               { Registers a new register record (or updates an existing). }
         function    Search (What : word) : pClassReg;          { Searchs register for an record with the specified identity. }

         {#Z Status methods }
         function    IsRegistered (What : word) : boolean;      { Is the identity registered in the register? }

       private

         {#Z Fields }
         fSuccessor          : pClassReg;                       { Successor pointer for object linkage. }
         fIdentity           : word;                            { Identity number for this register record. }

     end;


{ *****************************************
  *               tClassReg               *
  *****************************************
  Derived from: tObject
  Parent for: None                          }

{ Initializes and constructs an object of this type. This constructor
  creates an empty register record without successor link. }
constructor tClassReg.Initialize (What : word);
begin
     Inherited Initialize;
     fSuccessor := NIL; { Reset the successor link }
     fIdentity  := What; { Set record identity }
end;

{ Destructs an instance of this type, ie. detachs this and all the following
  records in the register. }
destructor tClassReg.Intercept;
begin
     { Detach successor registration records (recursive call) }
     if Assigned (fSuccessor) and fSuccessor^.IsInitialized then
        fSuccessor^.Free;
end;


{ Registers a new register record, ie. inserts a new instance in
  sorted order (according to the identity number). }
procedure tClassReg.Register (What : pClassReg);
var Iterator : pClassReg;
begin
     { Attach the instance to it's
       valid location. }
     Iterator := @Self;

     while Assigned (Iterator^.fSuccessor) and
           (What^.fIdentity > Iterator^.fSuccessor^.fIdentity)
           do Iterator := Iterator^.fSuccessor;

     { Attach here! }
     What^.fSuccessor := Iterator^.fSuccessor;
     Iterator^.fSuccessor := What;
end;

{ Searchs the register for the specified identity and returns the
  corresponding record or a NIL pointer if no matching record exists. }
function tClassReg.Search (What : word) : pClassReg;
var Iterator : pClassReg;
begin
     Iterator := @Self; { Start search at the current record }

     { Search for the identity in the ordered register }
     while (What > Iterator^.fIdentity) and Assigned (Iterator^.fSuccessor) and
           Iterator^.fSuccessor^.IsInitialized do
           Iterator := Iterator^.fSuccessor; { Walk forward }

     { Return the matching register record or a NIL pointer if no
       record with the specified identity exists in the register. }
     if (What = Iterator^.fIdentity) then Search := Iterator
        else Search := NIL;
end;

{ Returns TRUE if the identity number is registered in the register. }
function tClassReg.IsRegistered (What : word) : boolean;
begin
     IsRegistered := (Search (What) <> NIL);
end;



var MyRegister : tClassReg;

begin
     with MyRegister do begin

          Initialize (0); { First = zero }

          { Demonstration (does nothing, really). }

          Register ( New (pClassReg, Initialize (2)) );
          Register ( New (pClassReg, Initialize (3)) );
          Register ( New (pClassReg, Initialize (4)) );

          if IsRegistered (4)
             then WriteLn ('An object with identity 3 is registered.');

          Intercept;

     end;
end.