{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Math/Complex.pas                 [x] Protected mode

  This is an example of complex number arithmetics.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFSTREAM, EFMATH;


var Z1, Z2, Z3 : tComplex;

begin
     Z1.Initialize (1, -1);
     Z2.Initialize (2, 2);
     Z3.Initialize (3, -3);

     with Z1 do begin

          { Let's do some complex arithmetics! }
          Add (@Z2); { Z1 = Z1 + Z2 }
          Multiply (@Z3); { Z1 = Z1 * Z3 }
          Conjugate; { Z1 = Z1* }
          Square (@Z1); { Z1 = Z1^2 }
          SquareRoot (@Z1); { Z1 = Z1^0.5 }

          WriteLn ('Arg Z1 = ', Argument:0:3);
          WriteLn ('| Z1 | = ', Magnitude:0:3);
          StreamWrite (StdIO); WriteLn;

     end;


     Z1.Intercept; Z2.Intercept; Z3.Intercept;
end.