{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Tables/Buckhash.pas     [x] Protected mode

  Hash tables with buckets are provided in tBucketHashTable. The
  bucket mechanism brings the real power of hashing since collisions
  are effectively avoided.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;


uses EFTABLE, EFSTRING, EFTEST;

const CapacityOfElements = 200; { Maximum capacity }
      NumberOfElements   = CapacityOfElements div 2; { Number of elements to add }

var Table : pHashTable; Index : word;
    S : string;

begin
     MemPush; { EFTEST }

     Randomize;
     Table := New (pBucketHashTable, Initialize (CapacityOfElements, SizeOf(S)));


     with Table^ do begin

          { Install a good hash function. }
          InstallPlug ( New (pTextHashPlug, Initialize (NIL)) );

          { Store some random elements in the
            hash table. }

          for Index := 1 to NumberOfElements do begin
              Str ( Random (99), S );
              Put ( New ( pString, Initialize (S) ) );
          end;

          WriteLn ('Elements: ');

          { Show used elements }
          with CreateIterator^ do begin

               while not IsEnd do begin
                     Write ( '[', pString(Element)^.Pascal:2, '] ' );
                     WalkForward;
               end;

               Free; { Iterator }

          end;

          if Elements <> NumberOfElements
             then WriteLn ('Not all elements could be inserted - duplicate elements generated.');

          Free;
          WriteLn;

     end;

     MemPop; { EFTEST }
end.