{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Elements/Linkage4.pas   [x] Protected mode

  Some ADT's use a special packaging for their elements, for example
  lists and trees. These ADT require links between their elements,
  these links are implemented in the packaging - the container
  class. This is a demonstration of tLinkage, the packaging of
  linked lists, that is, descendants of tList.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFKERNEL, EFLIST;


var Start, Capture : pLinkage;
    StartMem : longint;

begin
     StartMem := MemAvail;

     { Create a chain of two nodes: }
     New (Start, Initialize (NIL,
       New (pLinkage, Initialize (NIL, NIL))));

     { Detach the predecessor node }
     Capture := pLinkage(Start^.Predecessor);
     Capture^.Detach;

     if Capture^.IsIntact
        then WriteLn  ('We detached a node, and it is intact.');

     { Manual attach of the node [Capture] }
     Start^.SetSuccessor (Capture); { After [Start] }
     Capture^.SetPredecessor (Start);

     { Both ends of the chain is NIL pointers.
       If there are no ends, the chain is circular,
       and is invalid. Our chain has NIL pointers,
       since we have not attached a node to itself. }

     if (Start^.Last^.Successor = NIL) and
        (Start^.First^.Predecessor = NIL)
        then WriteLn ('Chain with NIL boundaries - its valid.');

     { Certify that our manual attachment completed. }

     if (Start^.Last = pContainer(Capture)) and Start^.Last^.IsIntact
        then WriteLn ('We have attached the node again.');

     { Requires 32 bytes: 8*SizeOf(Pointer) }
     WriteLn ('Required ', StartMem - MemAvail, ' bytes.');

     Start^.First^.FreeAll; { This releases the entire chain }

     { Certify that no memory is left undisposed
       on the heap. }

     if StartMem <> MemAvail
        then WriteLn ('Left ', StartMem - MemAvail, ' bytes undisposed.');
end.