{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Elements/Generic4.pas   [x] Protected mode

  Polymorphic elements: an example of updating and retrieving
  of contents.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFELEM;


var Element1, Element2 : pGenericElement;
    Data1 : string[100]; Data2, Data3 : string[200];


begin
     Data1 := '1) Some data to store in the element.';
     Data2 := '2) Some other data to update the element with.';
     Data3 := '3) Not functioning properly!';


     New (Element1, InitializeEmpty);
     System.Dispose (Element1, Intercept);

     New (Element1, Initialize (@Data1, SizeOf(Data3)));

     with Element1^ do begin
          CopyOut (@Data1, SizeOf(Data1), 0);
          WriteLn (Data1);

          CopyIn (@Data2, SizeOf(Data2), 0);
          CopyOut (@Data1, SizeOf(Data1), 0);
          WriteLn (Data1);

          if IsAllocated then begin
             New (Element2, Duplicate (Element1));
             if not IsCompatible(Element2) then
                WriteLn ('Element compatiblity check failed.');
             with Element2^ do begin
                  CopyOut (@Data3, SizeOf(Data3), 0);
                  WriteLn (Data3);
             end;
             Element2^.Free; { Same as Dispose (Element2, Intercept) }
          end;
     end;

     Element1^.Free;
end.