
{$I LZDefine.inc}

unit LZImplic;
{sample "implicit" or "static" import unit for ChiefLZ.dll}

interface
uses
{$ifdef Win32}
Windows,
{$endif Win32}
ChfTypes;

{exported functions}

function IsChiefLZArchive(const fName: {$ifdef Win32} string
                                       {$else}        PChar
                                       {$endif} ): boolean;
{$ifdef Win32} stdcall; {$endif Win32}

{$ifdef Win32}
function GetChiefLZFileName(const fName: string): string; stdcall;
{$else}
function GetChiefLZFileName(fName, Dest:PChar): boolean;
{$endif Win32}

function GetChiefLZFileSize(fName: {$ifdef Win32} string
                                   {$else Win32}  PChar
                                   {$endif Win32}): LongInt;
{$ifdef Win32} stdcall; {$endif Win32}


function GetChiefLZArchiveInfo(const ArchName: {$ifdef Win32} string
                                               {$else Win32}  PChar
                                               {$endif Win32};
                               var   Header: TChiefLZArchiveHeader): boolean;
{$ifdef Win32} stdcall; {$endif Win32}

function GetChiefLZArchiveSize(const ArchName: {$ifdef Win32} string
                                               {$else Win32}  PChar
                                               {$endif Win32}): LongInt;
{$ifdef Win32} stdcall; {$endif Win32}

function LZCompress(const {$ifdef Win32} Source, Dest:   string
                          {$else}        aSource, aDest: pChar
                          {$endif};
                    LZQuestion: TLZQuestionFunc;
                    aProc:      TLZReportProc): LongInt;
{$ifdef Win32} stdcall; {$endif Win32}

function LZDecompress({$ifdef Win32} Source, Dest:  string
                      {$else} const aSource, aDest: PChar
                      {$endif};
                      LZQuestion: TLZQuestionFunc;
                      aProc:      TLZReportProc):LongInt;
{$ifdef Win32} stdcall; {$endif Win32}


function IsChiefLZFile(const fName: {$ifdef Win32} string
                                    {$else}        PChar
                                    {$endif}): boolean;
{$ifdef Win32} stdcall; {$endif Win32}


function LZArchive(const fSpec, ArchName: {$ifdef Win32} string
                                          {$else}        PChar
                                          {$endif};
                   LZRecurseDirs: TLZRecurse;
                   aProc:         TLZReportProc): LongInt;
{$ifdef Win32} stdcall; {$endif Win32}


function LZDearchive(ArchName: {$ifdef Win32} string
                               {$else}        PChar
                               {$endif};
                    {$ifdef Win32} DefDir: string
                    {$else} const aDefDir: PChar
                    {$endif};
                     LZQuestion: TLZQuestionFunc;
                     aProc:      TLZReportProc;
                     aRename:    TLZRenameFunc): LongInt;
{$ifdef Win32} stdcall; {$endif Win32}


function LZCompressEx(const {$ifdef Win32} Name:  string
                            {$else}        aName: PChar
                            {$endif};
                      ReplaceQuestion: TLZQuestionFunc;
                      aProc:           TLZReportProc): LongInt;
{$ifdef Win32} stdcall; {$endif Win32}


function LZDecompressEx({$ifdef Win32} Name:  string
                        {$else}        aName: PChar
                        {$endif};
                        ReplaceQuestion: TLZQuestionFunc;
                        aProc:           TLZReportProc): LongInt;
{$ifdef Win32} stdcall; {$endif Win32}


function GetLZMarkerChar: Char; {$ifdef Win32} stdcall; {$endif}

procedure SetLZMarkerChar(const NewChar: Char);
                                        {$ifdef Win32} stdcall; {$endif}

function ChiefLZDLLVersion: Integer; {$ifdef Win32} stdcall; {$endif}

function GetFullLZName(Const X    : TChiefLZArchiveHeader;
                             Index: Integer): String;
{$ifdef Win32} stdcall; {$endif}

Function LoadChiefLZDLL(DLLName: PChar): {$ifdef Win32} BOOL {$else} Integer {$endif};
{Dummy for compatibility with LZExplic}

Function UnloadChiefLZDLL: {$ifdef Win32} BOOL {$else} Boolean {$endif};
{Dummy for compatibility with LZExplic}

implementation

const ChiefDLL = 'ChiefLZ';

{-------- functions exported in ChiefLZ.dll -----------------}
  function  LZCompress; external ChiefDLL     index 1;
  function  LZDecompress; external ChiefDLL   index 2;
  function  IsChiefLZFile; external ChiefDLL  index 3;
  function  LZArchive; external ChiefDLL      index 4;
  function  LZDeArchive; external ChiefDLL    index 5;
  function  IsChiefLZArchive; external ChiefDLL    index 6;
  function  GetChiefLZFileName; external ChiefDLL  index 7;
  function  GetChiefLZFileSize; external ChiefDLL  index 8;
  function  GetChiefLZArchiveInfo; external ChiefDLL index 9;
  function  LZCompressEx; external ChiefDLL       index 10;
  function  LZDeCompressEx; external ChiefDLL     index 11;
  function  GetLZMarkerChar; external ChiefDLL    index 12;
  procedure SetLZMarkerChar; external ChiefDLL    index 13;
  function  GetFullLZName; external ChiefDLL      index 14;
  function  ChiefLZDLLVersion; external ChiefDLL  index 15;
  function  GetChiefLZArchiveSize; external ChiefDLL  index 16;

{--------------------------------------------------------}
Function LoadChiefLZDLL(DLLName: PChar): {$ifdef Win32} BOOL {$else} Integer {$endif};
Begin
  LoadChiefLZDLL := {$ifdef Win32} True {$else} 0 {$endif};
End;

Function UnloadChiefLZDLL: {$ifdef Win32} BOOL {$else} Boolean {$endif};
Begin
  UnloadChiefLZDLL := True
End;

End.

