(*******************************************************************)
(* 3dLIB Macro Program 3dPas.pas                                   *)
(* Generated on the 15-3-1992 Sunday, 1992:3:15                    *)
(* (c) 1992, Loewy Ron.                                            *)
(*******************************************************************)

program macronewdemo;

uses
	crt
	,graph
	,rtObj
	,project3
	,hdr3d
	,ctm3d
	;
(*******************************************************************)
(* Global Variables and Constants                                  *)
(*******************************************************************)
var
	i,
	element	: integer;
	ee	: word;
	obj	: array [ 1 .. 9 ] of baseObjectPtr;
	ch	: char;
	V0
	,V1
	,V2
	,V3
	,V4
	,V5
	,V6
	,V7
	,V8
	,V9	: real;
	I0
	,I1
	,I2
	,I3
	,I4
	,I5
	,I6
	,I7
	,I8
	,I9	: integer;
const
	zeroPoint	: point3d = (x:0.0; y:0.0; z:0.0);

(*******************************************************************)
(* error                                                           *)
(*******************************************************************)
procedure error(i : byte; j : word);
var
	errStr	: string[20];
	a	:char;
begin
	restoreCrtMode;
	case i of
		1 : errStr := 'I/O error #'
		else errStr := 'General error #'
	end; { case }
	writeln;
	write(errStr);
	if (j <> 0) then
		writeln(j)
	else
		writeln;
	a := readKey;
	closeGraph;
	halt(1)
end; {error}

(*******************************************************************)
(* power                                                           *)
(*******************************************************************)
function power(a, b : real) : real;
begin
	power := exp(b * ln(a));
end; {power}

(*******************************************************************)
(* MAIN                                                            *)
(*******************************************************************)
begin
   outTextXY(80, 10, '3dLib demo program, (c) 1993, Ron Loewy.');
	resetPerspective;
	obj[1] := new(obj3dPtr, open('pyr.3D2', zeroPoint, maxColor));
	ee := obj[1]^.load;
	if (ee <> 0) then
		error(1, ee);
	obj[1]^.goto3DPos(trunc( 0), trunc( 0), trunc( 0));
	resetPerspective;
	for i0 := 1 to trunc( 15) do begin
      setcolor(1 + random(maxColor));
		obj[1]^.paint;
		obj[1]^.rotate(z, trunc( 12));
	end; { loop }
	for i0 := 1 to trunc( 60) do begin
      setcolor(1 + random(maxColor));
		obj[1]^.paint;
		obj[1]^.rotate(x, trunc( 6));
		obj[1]^.paint;
	end; { loop }
	obj[1]^.paint;
	obj[1]^.rotate(z, trunc( 180));
	for i0 := 1 to trunc( 60) do begin
      setcolor(1 + random(maxColor));
		obj[1]^.paint;
		obj[1]^.rotate(y, trunc( 6));
		obj[1]^.paint;
	end; { loop }
	for i0 := 1 to trunc( 120) do begin
      setcolor(1 + random(maxColor));
		obj[1]^.paint;
		obj[1]^.rotate(x, trunc( 6));
		obj[1]^.paint;
		obj[1]^.paint;
		obj[1]^.rotate(y, trunc( 6));
		obj[1]^.paint;
	end; { loop }
	for i0 := 1 to trunc( 120) do begin
      setcolor(1 + random(maxColor));
		obj[1]^.paint;
		obj[1]^.rotate(x, trunc( 3));
		obj[1]^.paint;
		obj[1]^.paint;
		obj[1]^.rotate(y, trunc( 3));
		obj[1]^.paint;
		obj[1]^.paint;
		obj[1]^.rotate(z, trunc( 6));
		obj[1]^.paint;
	end; { loop }
	for i0 := 1 to trunc( 30) do begin
      setcolor(1 + random(maxColor));
		obj[1]^.paint;
		obj[1]^.rotate(z, trunc( 6));
		obj[1]^.paint;
	end; { loop }
	for i0 := 1 to trunc( 120) do begin
      setcolor(1 + random(maxColor));
		obj[1]^.paint;
		obj[1]^.rotate(x, trunc( 3));
		obj[1]^.paint;
		obj[1]^.paint;
		obj[1]^.rotate(y, trunc( 6));
		obj[1]^.paint;
		obj[1]^.paint;
		obj[1]^.rotate(z, trunc( 3));
		obj[1]^.paint;
	end; { loop }
	for i0 := 1 to trunc( 450) do begin
      setcolor(1 + random(maxColor));
		obj[1]^.paint;
		obj[1]^.move(x,  -1);
		obj[1]^.rotate(x, trunc( 3));
		obj[1]^.paint;
	end; { loop }
	ch := readKey;
	closeGraph;
end.
