;=======================================================================
; MARK.ASM - mark a position in memory above which TSRs will later
;30-May-1989 be cleared by UnMark.COM.  MARK can be called multiple
;03:10       times.  If MARK is called with something on the command
;	     line, that text will be stored in the program segment
;	     prefix at offset 80H, where it is later accessible to
;	     UnMark for a "named" release.
;=======================================================================
; written for MASM (version 4 or later) or TASM
; by Kim Kokkonen, TurboPower Software
; telephone: 408-438-8608, Compuserve 72457,2131
;=======================================================================
; VERSION 1.4  2/23/86
;   This version stores the EMS page map so that RELEASE can release
;   READY! and any future resident programs using expanded memory
; VERSION 1.5  2/28/86
;   to keep consistent with MAPMEM and RELEASE
; VERSION 1.6  3/8/86
;   store all 256 interrupts, but only 32 EMS blocks
; VERSION 1.7  4/1/86
;   close the EMS handle opened to avoid using up a DOS handle
; VERSION 1.8  4/20/86
;   to keep consistent with MAPMEM and RELEASE
; VERSION 1.9  5/22/86
;   to keep consistent with MAPMEM and RELEASE
; VERSION 2.0  5/26/86
;   to keep consistent with MAPMEM and RELEASE
; VERSION 2.1  7/18/86
;   to keep consistent with RELEASE
; VERSION 2.2  3/4/87
;   add save area for BIOS data areas
;     40:A8 (8 bytes for EGA)
;     40:F0 (16 bytes for interapplications communications)
; VERSION 2.3  5/1/87
;   convert to use MASM
;   chop off unused portion of EMS page map when going resident
;   modify so that the data areas are not part of the COM file
; VERSION 2.4  5/17/87
;   for consistency with RELEASE
; VERSION 2.5  6/2/87
;   add version checking between MARK and RELEASE
; VERSION 3.1 5/30/89 for UnMark and ReMark Versions 3.0 by
;   Tom Gilbert's Heart & Mind - includes TurboPower 2.8
;   fix problem occurring when command processor is an EXE file,
;     by storing parent's PSP segment as part of MARK save area
;     (thanks to Tom Rawson for this code)
;=======================================================================

CSEG	segment public para
	ASSUME	CS:CSEG, DS:CSEG, ES:NOTHING

	org     100H
ComEntry:
	jmp	doit

;put the following in the MAP file
public idstr,VECTOR,EGASAV,INTCOM,EMSCNT,EMSMAP

idstr	db  'M3.1 PARAMETER BLOCK FOLLOWS' ;used to find this TSR

;**** the following will be overwritten by the vector table image ******
;success message and version number
didit	db  13,10,'MARK 3.1 - Marked current memory position',13,10,36
;file name for testing EMS presence
emsnm	db  'EMMXXXX0',0
;ID string
id	db  ' M3.1 TSR'
IDLEN	equ $-id

;***********************************************************************
VECTOR  equ 0120H	;offset in code seg where vector table is copied
VECLEN  equ 0400H	    ;1024 bytes for vectors
EGASAV  equ VECTOR+VECLEN
EGALEN  equ 8		    ;8 bytes for EGA save area
INTCOM  equ EGASAV+EGALEN
INTLEN  equ 10H		    ;16 bytes for interapps communication area
PARENT  equ INTCOM+INTLEN
PARLEN  equ 2		    ;2 bytes for parent's PSP
EMSCNT  equ PARENT+PARLEN
EMSMAP  equ EMSCNT+2
NEWLOC  equ EMSMAP+100H     ;location of relocated code
;***********************************************************************

doit	proc	near

;put a standard ID string into the PSP for ShowTSRs to check
	mov	si,offset id
	mov	di,60h		;unused area of PSP
	mov	cx,IDLEN	;characters in ID string
	cld
	rep	movsb		;copied
	mov	di,NEWLOC	;relocate ourselves out of the way
	push	di		;will act as a return address
	mov	si,offset pmess
	mov	cx,lastcode-pmess
	rep	movsb
	ret			;"return" to the relocated code

pmess:  mov	dx,offset didit ;print message
	mov	ah,9
	int	21H		;write success message
	mov	dx,offset emsnm ;determine whether EMS is present
	mov	ax,3D00H
	int	21H
	jnc	emspres		;ems driver installed
	 xor	bx,bx		; or zero active handles
	 jmp	short stocnt

emspres:
	mov	bx,ax		;close the open handle
	mov	ah,3EH
	int	21H
	mov	ah,4DH		;store the EMS page map
	mov	di,EMSMAP
	xor	bx,bx		;required by some versions of EMM
	cld			;required by some versions of EMM
	int	67H

stocnt: mov	di,EMSCNT	;store the number of active handles
	mov	[di],bx		;count of active handles

;store the interrupt vector table (overwrites initial messages)
	xor	ax,ax
	mov	DS,ax		;source address segment 0
	ASSUME	DS:NOTHING
	xor	si,si		;offset 0
	mov	di,VECTOR	;destination offset, es=cs already
	mov	cx,VECLEN shr 1	;count of words to store
	rep	movsw		;copy vectors to our table
	mov	ax,40H		;store the EGA save area
	mov	DS,ax		;point to BIOS data area
	mov	si,00A8H	;EGA save area pointer
	mov	di,EGASAV
	mov	cx,EGALEN shr 1
	rep	movsw
	mov	si,00F0H	;store the interapplications
	mov	di,INTCOM	;communication area
	mov	cx,INTLEN shr 1
	rep	movsw
	mov	ax,CS		;store the parent's
	mov	DS,ax		;PSP segment
	mov	ax,DS:[16h]	;get parent's PSP from our PSP
	mov	DS:[PARENT],ax  ;store in data save area
	mov	ES,ES:[2Ch]	;release environment
	mov	ah,49h		;release for
	int	21h		;DOS reuse

;terminate and stay resident
	mov	dx,EMSMAP	;start at base of ems map
	mov	di,EMSCNT
	mov	bx,CS:[di]	;count of active handles
	shl	bx,1
	shl	bx,1		;multiply EMS handle count by 4
	add	dx,bx
	add	dx,000FH	;round up for paragraphs
	mov	cl,4
	shr	dx,cl		;convert to paragraphs
	mov	ax,3100H
	int	21H		;terminate but stay resident
lastcode:
doit	endp

CSEG	ends
	end	ComEntry
