/* imtypes.c - imaging generic typedefs
 */

/****************** typedefs ********************/

/* FAR pointer typedefs
 */
typedef	short FAR	*LPSHORT;
typedef long FAR	*LPLONG;
typedef BYTE FAR	*LPBYTE;
typedef WORD FAR	*LPWORD;
typedef DWORD FAR	*LPDWORD;
typedef HANDLE FAR	*LPHANDLE;
typedef SINT FAR	*LPSINT;

typedef PVOID		PDLOC;	/* to allow imaging routines to pass a hidden
							 * data location structure, for eventual
							 * use by the vio.c routines.
							 */

/***************** constants and macros *******************/

#ifndef MAXSHORT
 #define	MAXSHORT		(0x7FFF)		/* maximum 16-bit signed int */
 #define	MINSHORT		(0x8000)
 #define	MAXWORD			((WORD)0xFFFF)	/* maximum 16-bit unsigned int */
 #define	MAXLONG			0x7FFFFFFFL		/* maximum 32-bit signed int */
 #define	MAXDWORD		((DWORD)0xFFFFFFFFL)/* max 32-bit unsigned int */
#endif

/* macros for computing BytesPerRow and Word-Aligned BytesPerRow
 *  w=width of row in pixels
 *  b=BitsPerSample
 *  s=SamplesPerPixel
 */
#define UBPR(w,b,s)		(((w)*(b)*(s)+7)>>3)
#define UWABPR(w,b,s)	((((w)*(b)*(s)+15)>>4)<<1)

/* NULL shorthands:
 */
#define HNULL	((HANDLE)NULL)
#define BFNULL	((BYTE FAR *)NULL)
#define LPNULL	((LPSTR)NULL)
