/*****************************************************************************
 *	AldTypes - Basic data types.
 *
 * created from rev 3.3 on 88-10-31
 *
 ****************************************************************************/

#include "Universe.h"

#ifndef	GLOBAL					/* Globals will be allocated by PMMain.c */
#define	GLOBAL	extern			/* used here for global data */
#endif /* GLOBAL */

#ifdef WINDOWS

/* #define FAR far */
#define FAR		/* shouldn't need it, for our unix-type environment */
#define LINT_ARGS
#define ARGS(list) list
#define T_ARGS(list) list
#define PAD(name) short name;

#endif /* WINDOWS */

#ifdef MACINTOSH

#include <MacTypes.h>
#define FAR
#ifndef	ARGS
#define ARGS(list) list
#endif
#define T_ARGS(list) ()

#define PAD(name)

int printf (char *, ...);

#endif /* MACINTOSH */

#define DBMSG(a)	(printf a)

#ifndef	PLOCL

#ifdef  WINDOWS
#define PLOCL	static
#endif

#ifdef	MACINTOSH
#define PLOCL
#endif

#endif

#ifndef	LOCAL
#define LOCAL	static
#endif

#ifndef	PRIVATE
#define PRIVATE	static
#endif


/*****************************************************************************
 *	These are the fundamental data types. We're defining them here, where
 *	we have control over them.
 */

typedef short RC;				/* standard Aldus return code */
#define SUCCESS ((RC) 0)
#define FAILURE ((RC) -1)

#define	BOOL	int		/* BOOL is the type WE use for logical expressions. */
#define	TRUE 	1
#define	FALSE	0

#ifdef MACINTOSH
#define NULL	0L
#else
#define NULL	0
#endif

typedef char FAR *LPSTR;		/* long pointer to string	*/
typedef int  FAR *LPINT;        /* long pointer to int   */

#ifdef WINDOWS
typedef void		*PVOID;		/* generic untyped pointer	*/
typedef void FAR	*LPVOID;
#endif
#ifdef MACINTOSH
								/* The following will become "void*"	*/
								/* when LightSpeedC supports it			*/
typedef unsigned char		*PVOID;		/* generic untyped pointer	*/
typedef unsigned char FAR	*LPVOID;
#endif
typedef unsigned char 	BYTE;	/* 8-bit, unsigned integer. */
typedef char			SINT;	/* 8-bit, signed integer. */
typedef unsigned short	WORD;	/* 16-bit unsigned integer. */
typedef long 			LONG;	/* 32-bit signed integer. */
typedef unsigned long 	DWORD;	/* 32-bit unsigned integer. */

#define PASCAL pascal
#define VOID void

typedef	char	*HANDLE;
typedef HANDLE	HWND;

/* end Aldtypes.h */
 

