/* 
 * tiff to PS converter
 *
 * written orginally to convert TIFF to a 4 bit format for ron ball
 * update to create a post script file on June 11, 1987
 *
 */

#include <stdio.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <windows.h>
#include <time.h>

#define TAG_IMWIDTH	256
#define TAG_IMLENGTH	257
#define TAG_BITSPIX	258
#define TAG_PHOTOINTERP	262
#define TAG_SAMPIX	277
#define TAG_ROW_PER_STRIP	278
#define FULL_RES 1
#define BITSPERBYTE	8
#define RATIO	(300.0/72.0)

float	pwidth;
float	pheight;
int	ifd,ofd;


int width;		/* width of the image in pixels */
int length;		/* length of the image in pixels */
int bitspix; 		/* bits per pixel */
int tncount;		/* what line of the image are we reading. */
int bytes_per_line;	/* how many bytes does this scan line take */
int samppix;
int blacklevel;
int negflag;
long rows_per_strip;	/* rows per strip flag */
LPSTR linebuffer;
LPSTR bigalloc();

int tiffin(ifd)
int ifd;
{
int bytesreq;
int numtags;
char *malloc();

/* tiffin reads the file header and tags list from the tiff file */

if(!read_tag(ifd,FULL_RES,TAG_SAMPIX,(LPSTR)&samppix,(short)sizeof(samppix))){
	/*error */
	samppix = 1;
	}

if(!read_tag(ifd,FULL_RES,TAG_BITSPIX,(LPSTR)&bitspix,(short)sizeof(bitspix))){
	/*error */
	bitspix = 1;
	}

if(!read_tag(ifd,FULL_RES,TAG_IMWIDTH,(LPSTR)&width,(short)sizeof(width))){
	/*error */
	exit(4);
	}
pwidth = (float)width/(RATIO);

if(!read_tag(ifd,FULL_RES,TAG_IMLENGTH,(LPSTR)&length,(short)sizeof(length))){
	/*error */
	exit(4);
	}

if(!read_tag(ifd,FULL_RES,TAG_ROW_PER_STRIP,(LPSTR)&rows_per_strip,(short)sizeof(rows_per_strip))){
	/*error */
	/* if tag not present, then value == image height */
	rows_per_strip = length;
	}

if(!read_tag(ifd,FULL_RES,TAG_PHOTOINTERP,(LPSTR)&blacklevel,(short)sizeof(blacklevel))){
	/*error*/
	/* white is black.  ff == black 00 = white  */
	blacklevel = 0;
	}
pheight = (float)length/(RATIO);


bytes_per_line = ((((width& 0x1)?width+1:width)*bitspix * samppix)+BITSPERBYTE-1)/BITSPERBYTE;

}


/* decodeline - read a line of data from a tiff file.  This function assumes
   		that the user is reading the file one line at a time.
		The function requires a file descriptor (handle in dos parlance)
		and a buffer that is big enough to store the uncompressed image.
	*/

int decodeline(ifd,buffer,PostScript)
int ifd;
LPSTR buffer;
int PostScript;
{
int retval;

	if((retval = read_image(ifd,FULL_RES,1,(long)tncount,rows_per_strip,
		(LPSTR)buffer,(long)bytes_per_line*rows_per_strip)) == NULL) {
		return(-1);
  	}
	return(tncount+=rows_per_strip);
}


main(argc,argv)
int argc;
char **argv;
{

	int PostScript;	/* are we converting to PostScript or RBFormat */
	int var;	/* argument pointer */
	
	/* input filename of output file and open it */


	PostScript = TRUE;
	var = 1;

	if(argc !=3 && argc !=4 )
		{
		printf("usage: tiftops [-n] infil.tif outfil.eps\n");
		exit(1);
		}

	/* check to see which format we'll be writing out */

	if(argc == 4 && !strcmp(argv[var],"-n")) {
		negflag = 1;
		var++;
	}

	if((ifd = open(argv[var++],O_RDONLY|O_BINARY)) == -1)
		{
		/* error */
		exit(1);
		}


	if((ofd = open(argv[var],O_CREAT|O_TRUNC|O_BINARY|O_WRONLY,
				S_IREAD|S_IWRITE)) == -1) {
		/* error */
		exit(1);
		}

	tiffin(ifd);

	linebuffer = (LPSTR)bigalloc(bytes_per_line * rows_per_strip);


	if(PostScript) {
		write_PS(ofd,width,length,bitspix);
	} else {
		write_he(ofd,width,length,bitspix);
	}



	tncount = 0;
	

	while(tncount < length ) {
		if(tncount % 100 == 0)
			printf("processing line %d\n",tncount);
		if(decodeline(ifd,linebuffer,PostScript) == -1) {
			printf("file translation unsuccessful \n");
			break;
		}
		write_line(ofd,(LPSTR)linebuffer,PostScript);
	}
	finish_ofile(ofd,PostScript);
	bigfree(linebuffer);
	close_read(ifd);
	close(ifd);
	close(ofd);

}

write_he(ofd,wd,ln,bp)
int wd;
int ln;
int bp;
int ofd;
{

	write(ofd,&wd,2);
	write(ofd,&ln,2);
	write(ofd,&bp,2);
}

/* write the Encapsulated PostScript Header */
#define PSTYPE	"%%!PS-Adobe-2.0 EPSF-1.2\n\r"
#define BOUNDER "%%%%BoundingBox: %d %d %f %f\n\r"
#define CREATE	"%%Creator: TIFF to Encapsulated PostScript\n%%Title: Image.TIF\n\r"
#define CRDTE	"%%%%CreationDate: %s\r"
#define ENDCOM	"%%EndComments\n\r"
#define TRAILER	"%%Trailer\n\r"
#define POINT_HEIGHT	"/height %d def\n\r"
#define POINT_WIDTH	"/width %d def\n\r"
#define GREY_LEVEL	"/grey %d def\n\r "
#define GSAVE		"gsave \n\r"
#define GRESTORE	"grestore \n\r"
#define IMG_CMD		"/theimage \n\r{ width height grey [%d 0 0 -%d 0 %d]\n {currentfile picstr readhexstring pop} image \n\r} def\n\r"
#define SHOWPAGE	"showpage\n\r"
#define SCALE	"%f %f scale\n\r"
#define STRING  "/picstr %d string def \n\r"
#define THE_IMAGE "theimage\r\n"

#define CONCATPROC	"/concatprocs \n\r { /proc2 exch cvlit def \n\r /proc1 exch cvlit def \n\r "
#define CONCAT1	"/newproc proc1 length proc2 length add array def \n\r"
#define CONCAT2 "newproc 0 proc1 putinterval \n\r newproc proc1 length proc2 putinterval \n\r"
#define CONCAT3 "newproc cvx \n\r } def \n\r"
#define EXCHV "{1 exch sub } currenttransfer concatprocs settransfer \n\r"



write_PS(of,wd,ln,bp)
int of;
int wd;
int ln;
int bp;
	{

	int cou;
	long ltime;
	struct tm *tmst;
	struct tm *localtime();
	char *asctime();
	int count;
	char obuf[200];

	cou = write(of,PSTYPE,strlen(PSTYPE));	/* !PS - ADOBE - EPSF */

	count = sprintf(obuf,BOUNDER,0,0,pwidth,pheight);
	cou += write(of,obuf,count);	/* BOUNDING BOX */

	cou += write(of,CREATE,strlen(CREATE));  /* CREATOR, TITLE */

	time(&ltime); 	/* get the time */
	tmst = localtime(&ltime);
	count = sprintf(obuf,CRDTE,asctime(tmst));	/* creation time */
	cou += write(of,obuf,count);

	cou += write(of,ENDCOM,strlen(ENDCOM));

	cou += write(of,"\n",1);
	
	cou += write(of,GSAVE,strlen(GSAVE));


	write(of,CONCATPROC,strlen(CONCATPROC));
	write(of,CONCAT1,strlen(CONCAT1));
	write(of,CONCAT2,strlen(CONCAT2));
	write(of,CONCAT3,strlen(CONCAT3));

	count = sprintf(obuf,GREY_LEVEL,bitspix*samppix);
	cou += write(of,obuf,count);

	count = sprintf(obuf,POINT_HEIGHT, length  );
	cou += write(of,obuf,count);

	count = sprintf(obuf,POINT_WIDTH,width);
	cou += write(of,obuf,count);

	count = sprintf(obuf,STRING,bytes_per_line);
	cou += write(of,obuf,count);

	if(negflag || !blacklevel) {
		write(of,EXCHV,sizeof(EXCHV));
	}

	count = sprintf(obuf,SCALE,pwidth,pheight);
	cou += write(of,obuf,count);

	count = sprintf(obuf,IMG_CMD,width,length,length);
	cou += write(of,obuf,count);

	cou += write(of,GSAVE,strlen(GSAVE));

	cou += write(of,THE_IMAGE,strlen(THE_IMAGE));


}

	


write_line(of,buf,PS)
int of;
LPSTR buf;
int PS;
{
	
	if(PS) {
		tlpWrite(of,(LPSTR)buf,bytes_per_line*rows_per_strip);
	} else { 
		tlpWrite(of,(LPSTR)buf,bytes_per_line*2);
	}
}


finish_ofile(of)
int of;
{
	int cou;

	cou = 0;
	cou += write(of,GRESTORE,strlen(GRESTORE));
	cou += write(of,SHOWPAGE,strlen(SHOWPAGE));
	cou += write(of,GRESTORE,strlen(GRESTORE));
	cou += write(of,TRAILER,strlen(TRAILER));
}
