name	COMPRESS

; This module made compatible to work with Microsoft C
; 1D Modified Huffman code compression technique

page	66,132

;
;******************************************************************************
;* COMPRESS - Compress raw image data					      *
;*									      *
;*	Input:	AH	Residual bit count				      *
;*		AL	Residual data byte				      *
;*		ES:DI	Address of source image data			      *
;*		ES:SI	Address to store compressed image data		      *
;*		CX	Length of raw image data			      *
;*		DX	Maximum number of bits/scan line		      *
;*									      *
;*	Output: AH	Residual bit count				      *
;*		AL	Residual data byte				      *
;*		BX	If set, negative compression resulted		      *
;*									      *
;******************************************************************************
;

_compress_TEXT	 SEGMENT BYTE PUBLIC 'CODE'
	ASSUME	CS:_compress_TEXT,DS:_compress_TEXT

		PUBLIC	_COMPRESS

SRC_PTR DW	?
DST_PTR DW	?
DST_LEN DW	?
COMP_DS DW	?		; 9/12 VJ

_COMPRESS	PROC
		PUSH	DS
		mov	cs:comp_ds,ds	; 9/12 vj
		PUSH	CS
		POP	DS
		MOV	cs:DST_LEN,0
		MOV	cs:SRC_PTR,DI
		MOV	cs:DST_PTR,SI
		JCXZ	COMPRESS7
		MOV	BX,CX
		SHL	BX,1
		SHL	BX,1
		SHL	BX,1		; total pixel count
COMPRESS1:	CALL	WHITE_RUN
		SUB	BX,SI
		CMP	SI,64
		JL	COMPRESS2
		PUSH	SI
		SUB	SI,64
		AND	SI,0FFC0H
		SHR	SI,1
		SHR	SI,1
		SHR	SI,1
		SHR	SI,1
		ADD	SI,offset(WHITE_MC)
		CALL	OUTPATTERN
		JC	COMPRESS10
		POP	SI
		AND	SI,003FH
COMPRESS2:	SHL	SI,1
		SHL	SI,1
		ADD	SI,offset(WHITE_TC)
		CALL	OUTPATTERN
		JC	COMPRESS10
		CMP	BX,0
		JZ	COMPRESS7
		CALL	BLACK_RUN
		SUB	BX,SI
		CMP	SI,64
		JL	COMPRESS3
		PUSH	SI
		SUB	SI,64
		AND	SI,0FFC0H
		SHR	SI,1
		SHR	SI,1
		SHR	SI,1
		SHR	SI,1
		ADD	SI,offset(BLACK_MC)
		CALL	OUTPATTERN
		JC	COMPRESS10
		POP	SI
		AND	SI,003FH
COMPRESS3:	SHL	SI,1
		SHL	SI,1
		ADD	SI,offset(BLACK_TC)
		CALL	OUTPATTERN
		JC	COMPRESS10
		CMP	BX,0
		JNZ	COMPRESS1
;COMPRESS7:	 CMP	 DX,WORD PTR [EOL+0]
;		 JL	 COMPRESS10
COMPRESS7:
COMPRESS9:				   ; LEA     SI,EOL
					   ; CALL    OUTPATTERN
		POP	DS
		MOV	CX,cs:DST_LEN
		MOV	SI,cs:DST_PTR
		MOV	BX,0
		RET
COMPRESS10:	POP	DS
		MOV	CX,cs:DST_LEN
		MOV	SI,cs:DST_PTR
		MOV	BX,1
		RET
_COMPRESS	ENDP

page
;***************************************************************************
;
OUTPATTERN	PROC
		PUSH	CX
		MOV	CX,word ptr[SI] 	; Pattern length
		JCXZ	OUTPATTERN3
		MOV	SI,word ptr[SI+2]	; Pattern
OUTPATTERN1:	SHL	SI,1
		RCL	AL,1
		INC	AH
		CMP	AH,8
		JL	OUTPATTERN2
		PUSH	DI
		MOV	DI,cs:DST_PTR

;new addition 9/12 vj

		push	es
		push	cx
		mov	cx,cs:comp_ds
		mov	es,cx
;end
		MOV	ES:[DI],AL

;new 9/12 vj
		pop	cx
		pop	es
;end
		INC	cs:DST_PTR
		INC	cs:DST_LEN
		POP	DI
		MOV	AX,0
OUTPATTERN2:	DEC	DX
;		JZ	OUTPATTERN4
		LOOP	OUTPATTERN1
OUTPATTERN3:	POP	CX
		CLC
		RET
OUTPATTERN4:	POP	CX
		STC
		RET
OUTPATTERN	ENDP

page
;***************************************************************************
;
WHITE_RUN	PROC
		PUSH	AX			; residue count/byte
		PUSH	BX			; output bit count
		PUSH	DX			; minimum bit output length
		MOV	SI,0			; run length
		AND	BX,0007H
		JZ	WHITE_RUN2
		PUSH	CX
		MOV	AL,ES:[DI]
		MOV	CX,8
		SUB	CX,BX
		SHL	AL,CL
		POP	CX
		JNZ	WHITE_RUN1
		ADD	SI,BX
		INC	DI
		DEC	CX
		JMP	short WHITE_RUN2
WHITE_RUN1:	SHL	AL,1
		JC	WHITE_RUN6
		INC	SI
		JMP	short WHITE_RUN1
WHITE_RUN2:	JCXZ	WHITE_RUN6
		MOV	BX,DI
		MOV	AL,00H
		CLD
		REPE SCASB		; scan for non-white
		JZ	WHITE_RUN5	; jump if no black found
		DEC	DI
		INC	CX
		MOV	AL,byte ptr(ES:[DI])
WHITE_RUN4:	SHL	AL,1
		JC	WHITE_RUN5
		INC	SI
		JMP	short WHITE_RUN4
WHITE_RUN5:	SUB	BX,DI
		NEG	BX
		SHL	BX,1
		SHL	BX,1
		SHL	BX,1
		ADD	SI,BX
WHITE_RUN6:	POP	DX
		POP	BX
		POP	AX
		RET
WHITE_RUN	ENDP

page
;***************************************************************************
;
BLACK_RUN	PROC
		PUSH	AX			; residue count/byte
		PUSH	BX			; output bit count
		PUSH	DX			; minimum bit output length
		MOV	SI,0			; run length
		AND	BX,0007H
		JZ	BLACK_RUN3
		PUSH	CX
		MOV	AL,byte ptr(ES:[DI])
		MOV	CX,8
		SUB	CX,BX
		SHL	AL,CL
		POP	CX
BLACK_RUN1:	SHL	AL,1
		JNC	BLACK_RUN2
		INC	SI
		JMP	short BLACK_RUN1
BLACK_RUN2:	CMP	SI,BX
		JNZ	BLACK_RUN6
		INC	DI
		DEC	CX
BLACK_RUN3:	JCXZ	BLACK_RUN6
		MOV	BX,DI
		MOV	AL,0FFH
		CLD
		REPE SCASB		; scan for non-BLACK
		JZ	BLACK_RUN5	; jump if no black found
		DEC	DI
		INC	CX
		MOV	AL,byte ptr(ES:[DI])
BLACK_RUN4:	SHL	AL,1
		JNC	BLACK_RUN5
		INC	SI
		JMP	short BLACK_RUN4
BLACK_RUN5:	SUB	BX,DI
		NEG	BX
		SHL	BX,1
		SHL	BX,1
		SHL	BX,1
		ADD	SI,BX
BLACK_RUN6:	POP	DX
		POP	BX
		POP	AX
		RET
BLACK_RUN	ENDP

page
;***************************************************************************
; Compression Tables
;
TC		MACRO	runlength,codelength,pattern
		IF (codelength EQ 0)
		DW	codelength,0000000000000000B
		ENDIF
		IF (codelength EQ 1)
		DW	codelength,pattern&000000000000000B
		ENDIF
		IF (codelength EQ 2)
		DW	codelength,pattern&00000000000000B
		ENDIF
		IF (codelength EQ 3)
		DW	codelength,pattern&0000000000000B
		ENDIF
		IF (codelength EQ 4)
		DW	codelength,pattern&000000000000B
		ENDIF
		IF (codelength EQ 5)
		DW	codelength,pattern&00000000000B
		ENDIF
		IF (codelength EQ 6)
		DW	codelength,pattern&0000000000B
		ENDIF
		IF (codelength EQ 7)
		DW	codelength,pattern&000000000B
		ENDIF
		IF (codelength EQ 8)
		DW	codelength,pattern&00000000B
		ENDIF
		IF (codelength EQ 9)
		DW	codelength,pattern&0000000B
		ENDIF
		IF (codelength EQ 10)
		DW	codelength,pattern&000000B
		ENDIF
		IF (codelength EQ 11)
		DW	codelength,pattern&00000B
		ENDIF
		IF (codelength EQ 12)
		DW	codelength,pattern&0000B
		ENDIF
		IF (codelength EQ 13)
		DW	codelength,pattern&000B
		ENDIF
		IF (codelength EQ 14)
		DW	codelength,pattern&00B
		ENDIF
		IF (codelength EQ 15)
		DW	codelength,pattern&0B
		ENDIF
		IF (codelength EQ 16)
		DW	codelength,pattern&B
		ENDIF
		ENDM

page
;***************************************************************************
;
WHITE_TC	LABEL	WORD		; Termination codes for white runs
		TC	 0, 8,00110101
		TC	 1, 6,000111
		TC	 2, 4,0111
		TC	 3, 4,1000
		TC	 4, 4,1011
		TC	 5, 4,1100
		TC	 6, 4,1110
		TC	 7, 4,1111
		TC	 8, 5,10011
		TC	 9, 5,10100
		TC	10, 5,00111
		TC	11, 5,01000
		TC	12, 6,001000
		TC	13, 6,000011
		TC	14, 6,110100
		TC	15, 6,110101
		TC	16, 6,101010
		TC	17, 6,101011
		TC	18, 7,0100111
		TC	19, 7,0001100
		TC	20, 7,0001000
		TC	21, 7,0010111
		TC	22, 7,0000011
		TC	23, 7,0000100
		TC	24, 7,0101000
		TC	25, 7,0101011
		TC	26, 7,0010011
		TC	27, 7,0100100
		TC	28, 7,0011000
		TC	29, 8,00000010
		TC	30, 8,00000011
		TC	31, 8,00011010
		TC	32, 8,00011011
		TC	33, 8,00010010
		TC	34, 8,00010011
		TC	35, 8,00010100
		TC	36, 8,00010101
		TC	37, 8,00010110
		TC	38, 8,00010111
		TC	39, 8,00101000
		TC	40, 8,00101001
		TC	41, 8,00101010
		TC	42, 8,00101011
		TC	43, 8,00101100
		TC	44, 8,00101101
		TC	45, 8,00000100
		TC	46, 8,00000101
		TC	47, 8,00001010
		TC	48, 8,00001011
		TC	49, 8,01010010
		TC	50, 8,01010011
		TC	51, 8,01010100
		TC	52, 8,01010101
		TC	53, 8,00100100
		TC	54, 8,00100101
		TC	55, 8,01011000
		TC	56, 8,01011001
		TC	57, 8,01011010
		TC	58, 8,01011011
		TC	59, 8,01001010
		TC	60, 8,01001011
		TC	61, 8,00110010
		TC	62, 8,00110011
		TC	63, 8,00110100

page
;***************************************************************************
;
WHITE_MC	LABEL	WORD		; Make-up codes for white runs
		TC	  64, 5,11011
		TC	 128, 5,10010
		TC	 192, 6,010111
		TC	 256, 7,0110111
		TC	 320, 8,00110110
		TC	 384, 8,00110111
		TC	 448, 8,01100100
		TC	 512, 8,01100101
		TC	 576, 8,01101000
		TC	 640, 8,01100111
		TC	 704, 9,011001100
		TC	 768, 9,011001101
		TC	 832, 9,011010010
		TC	 896, 9,011010011
		TC	 960, 9,011010100
		TC	1024, 9,011010101
		TC	1088, 9,011010110
		TC	1152, 9,011010111
		TC	1216, 9,011011000
		TC	1280, 9,011011001
		TC	1344, 9,011011010
		TC	1408, 9,011011011
		TC	1472, 9,010011000
		TC	1536, 9,010011001
		TC	1600, 9,010011010
		TC	1664, 6,011000
		TC	1728, 9,010011011
		TC	1792,11,00000001000
		TC	1856,11,00000001100
		TC	1920,11,00000001101
		TC	1984,12,000000010010
		TC	2048,12,000000010011
		TC	2112,12,000000010100
		TC	2176,12,000000010101
		TC	2240,12,000000010110
		TC	2304,12,000000010111
		TC	2368,12,000000011100
		TC	2432,12,000000011101
		TC	2496,12,000000011110
		TC	2560,12,000000011111

page
;***************************************************************************
;
BLACK_TC	LABEL	WORD		; termination codes for black runs
		TC	 0,10,0000110111
		TC	 1, 3,010
		TC	 2, 2,11
		TC	 3, 2,10
		TC	 4, 3,011
		TC	 5, 4,0011
		TC	 6, 4,0010
		TC	 7, 5,00011
		TC	 8, 6,000101
		TC	 9, 6,000100
		TC	10, 7,0000100
		TC	11, 7,0000101
		TC	12, 7,0000111
		TC	13, 8,00000100
		TC	14, 8,00000111
		TC	15, 9,000011000
		TC	16,10,0000010111
		TC	17,10,0000011000
		TC	18,10,0000001000
		TC	19,11,00001100111
		TC	20,11,00001101000
		TC	21,11,00001101100
		TC	22,11,00000110111
		TC	23,11,00000101000
		TC	24,11,00000010111
		TC	25,11,00000011000
		TC	26,12,000011001010
		TC	27,12,000011001011
		TC	28,12,000011001100
		TC	29,12,000011001101
		TC	30,12,000001101000
		TC	31,12,000001101001
		TC	32,12,000001101010
		TC	33,12,000001101011
		TC	34,12,000011010010
		TC	35,12,000011010011
		TC	36,12,000011010100
		TC	37,12,000011010101
		TC	38,12,000011010110
		TC	39,12,000011010111
		TC	40,12,000001101100
		TC	41,12,000001101101
		TC	42,12,000011011010
		TC	43,12,000011011011
		TC	44,12,000001010100
		TC	45,12,000001010101
		TC	46,12,000001010110
		TC	47,12,000001010111
		TC	48,12,000001100100
		TC	49,12,000001100101
		TC	50,12,000001010010
		TC	51,12,000001010011
		TC	52,12,000000100100
		TC	53,12,000000110111
		TC	54,12,000000111000
		TC	55,12,000000100111
		TC	56,12,000000101000
		TC	57,12,000001011000
		TC	58,12,000001011001
		TC	59,12,000000101011
		TC	60,12,000000101100
		TC	61,12,000001011010
		TC	62,12,000001100110
		TC	63,12,000001100111

page
;***************************************************************************
;
BLACK_MC	LABEL	WORD		; Make-up codes for black runs
		TC	  64,10,0000001111
		TC	 128,12,000011001000
		TC	 192,12,000011001001
		TC	 256,12,000001011011
		TC	 320,12,000000110011
		TC	 384,12,000000110100
		TC	 448,12,000000110101
		TC	 512,13,0000001101100
		TC	 576,13,0000001101101
		TC	 640,13,0000001001010
		TC	 704,13,0000001001011
		TC	 768,13,0000001001100
		TC	 832,13,0000001001101
		TC	 896,13,0000001110010
		TC	 960,13,0000001110011
		TC	1024,13,0000001110100
		TC	1088,13,0000001110101
		TC	1152,13,0000001110110
		TC	1216,13,0000001110111
		TC	1280,13,0000001010010
		TC	1344,13,0000001010011
		TC	1408,13,0000001010100
		TC	1472,13,0000001010101
		TC	1536,13,0000001011010
		TC	1600,13,0000001011011
		TC	1664,13,0000001100100
		TC	1728,13,0000001100101
		TC	1792,11,00000001000
		TC	1856,11,00000001100
		TC	1920,11,00000001101
		TC	1984,12,000000010010
		TC	2048,12,000000010011
		TC	2112,12,000000010100
		TC	2176,12,000000010101
		TC	2240,12,000000010110
		TC	2304,12,000000010111
		TC	2368,12,000000011100
		TC	2432,12,000000011101
		TC	2496,12,000000011110
		TC	2560,12,000000011111

page
;***************************************************************************
;
EOL		LABEL	WORD
		TC	EOL,12,000000000001

FILL		LABEL	WORD
		TC	FILL,1,0

_compress_TEXT		 ENDS
		END
