/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class XYBarDataset
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
DatasetChangeListener {
    private XYDataset underlying;
    private double barWidth;

    public XYBarDataset(XYDataset xYDataset, double d) {
        this.underlying = xYDataset;
        this.underlying.addChangeListener(this);
        this.barWidth = d;
    }

    public int getSeriesCount() {
        return this.underlying.getSeriesCount();
    }

    public String getSeriesName(int n) {
        return this.underlying.getSeriesName(n);
    }

    public int getItemCount(int n) {
        return this.underlying.getItemCount(n);
    }

    public Number getX(int n, int n2) {
        return this.underlying.getX(n, n2);
    }

    public Number getY(int n, int n2) {
        return this.underlying.getY(n, n2);
    }

    public Number getStartX(int n, int n2) {
        Double d = null;
        Number number = this.underlying.getX(n, n2);
        if (number != null) {
            d = new Double(number.doubleValue() - this.barWidth / 2.0);
        }
        return d;
    }

    public Number getEndX(int n, int n2) {
        Double d = null;
        Number number = this.underlying.getX(n, n2);
        if (number != null) {
            d = new Double(number.doubleValue() + this.barWidth / 2.0);
        }
        return d;
    }

    public Number getStartY(int n, int n2) {
        return this.underlying.getY(n, n2);
    }

    public Number getEndY(int n, int n2) {
        return this.underlying.getY(n, n2);
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.notifyListeners(datasetChangeEvent);
    }
}

