/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodFormatException;

public class Year
extends RegularTimePeriod
implements Serializable {
    private int year;

    public Year() {
        this(new Date());
    }

    public Year(int n) {
        if (n < 1900 || n > 9999) {
            throw new IllegalArgumentException("Year constructor: year (" + n + ") outside valid range.");
        }
        this.year = n;
    }

    public Year(Date date) {
        this(date, RegularTimePeriod.DEFAULT_TIME_ZONE);
    }

    public Year(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        this.year = calendar.get(1);
    }

    public int getYear() {
        return this.year;
    }

    public RegularTimePeriod previous() {
        if (this.year > 1900) {
            return new Year(this.year - 1);
        }
        return null;
    }

    public RegularTimePeriod next() {
        if (this.year < 9999) {
            return new Year(this.year + 1);
        }
        return null;
    }

    public long getSerialIndex() {
        return this.year;
    }

    public long getFirstMillisecond(Calendar calendar) {
        Day day = new Day(1, 1, this.year);
        return day.getFirstMillisecond(calendar);
    }

    public long getLastMillisecond(Calendar calendar) {
        Day day = new Day(31, 12, this.year);
        return day.getLastMillisecond(calendar);
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object instanceof Year) {
                Year year = (Year)object;
                return this.year == year.getYear();
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        int n2 = this.year ^ this.year >>> 32;
        n = 37 * n + n2;
        return n;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Year) {
            Year year = (Year)object;
            n = this.year - year.getYear();
        } else {
            n = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n;
    }

    public String toString() {
        return Integer.toString(this.year);
    }

    public static Year parseYear(String string) {
        int n;
        try {
            n = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimePeriodFormatException("Year.parseYear(string): cannot parse string.");
        }
        try {
            return new Year(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TimePeriodFormatException("Year outside valid range.");
        }
    }
}

