/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodFormatException;
import org.jfree.data.time.Year;
import org.jfree.date.SerialDate;

public class Quarter
extends RegularTimePeriod
implements Serializable {
    public static final int FIRST_QUARTER = 1;
    public static final int LAST_QUARTER = 4;
    public static final int[] FIRST_MONTH_IN_QUARTER;
    public static final int[] LAST_MONTH_IN_QUARTER;
    private Year year;
    private int quarter;

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 7;
        nArray[4] = 10;
        FIRST_MONTH_IN_QUARTER = nArray;
        int[] nArray2 = new int[5];
        nArray2[1] = 3;
        nArray2[2] = 6;
        nArray2[3] = 9;
        nArray2[4] = 12;
        LAST_MONTH_IN_QUARTER = nArray2;
    }

    public Quarter() {
        this(new Date());
    }

    public Quarter(int n, int n2) {
        this(n, new Year(n2));
    }

    public Quarter(int n, Year year) {
        if (n < 1 && n > 4) {
            throw new IllegalArgumentException("Quarter(int, Year): quarter outside valid range.");
        }
        this.year = year;
        this.quarter = n;
    }

    public Quarter(Date date) {
        this(date, RegularTimePeriod.DEFAULT_TIME_ZONE);
    }

    public Quarter(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        int n = calendar.get(2) + 1;
        this.quarter = SerialDate.monthCodeToQuarter((int)n);
        this.year = new Year(calendar.get(1));
    }

    public int getQuarter() {
        return this.quarter;
    }

    public Year getYear() {
        return this.year;
    }

    public RegularTimePeriod previous() {
        Year year;
        Quarter quarter = this.quarter > 1 ? new Quarter(this.quarter - 1, this.year) : ((year = (Year)this.year.previous()) != null ? new Quarter(4, year) : null);
        return quarter;
    }

    public RegularTimePeriod next() {
        Year year;
        Quarter quarter = this.quarter < 4 ? new Quarter(this.quarter + 1, this.year) : ((year = (Year)this.year.next()) != null ? new Quarter(1, year) : null);
        return quarter;
    }

    public long getSerialIndex() {
        return (long)this.year.getYear() * 4L + (long)this.quarter;
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object instanceof Quarter) {
                Quarter quarter = (Quarter)object;
                return this.quarter == quarter.getQuarter() && this.year.equals(quarter.getYear());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.quarter;
        n = 37 * n + this.year.hashCode();
        return n;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Quarter) {
            Quarter quarter = (Quarter)object;
            n = this.year.getYear() - quarter.getYear().getYear();
            if (n == 0) {
                n = this.quarter - quarter.getQuarter();
            }
        } else {
            n = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n;
    }

    public String toString() {
        return "Q" + this.quarter + "/" + this.year;
    }

    public long getFirstMillisecond(Calendar calendar) {
        int n = FIRST_MONTH_IN_QUARTER[this.quarter];
        Day day = new Day(1, n, this.year.getYear());
        return day.getFirstMillisecond(calendar);
    }

    public long getLastMillisecond(Calendar calendar) {
        int n = LAST_MONTH_IN_QUARTER[this.quarter];
        int n2 = SerialDate.lastDayOfMonth((int)n, (int)this.year.getYear());
        Day day = new Day(n2, n, this.year.getYear());
        return day.getLastMillisecond(calendar);
    }

    public static Quarter parseQuarter(String string) {
        int n = string.indexOf("Q");
        if (n == -1) {
            throw new TimePeriodFormatException("Quarter.parseQuarter(string): missing Q.");
        }
        if (n == string.length() - 1) {
            throw new TimePeriodFormatException("Quarter.parseQuarter(string): Q found at end of string.");
        }
        String string2 = string.substring(n + 1, n + 2);
        int n2 = Integer.parseInt(string2);
        String string3 = String.valueOf(string.substring(0, n)) + string.substring(n + 2, string.length());
        string3 = string3.replace('/', ' ');
        string3 = string3.replace(',', ' ');
        string3 = string3.replace('-', ' ');
        Year year = Year.parseYear(string3.trim());
        Quarter quarter = new Quarter(n2, year);
        return quarter;
    }
}

