/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class MovingAverage {
    public static TimeSeriesCollection createMovingAverage(TimeSeriesCollection timeSeriesCollection, String string, int n, int n2) {
        if (timeSeriesCollection == null) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : null source.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : periodCount must be greater than or equal to 1.");
        }
        TimeSeriesCollection timeSeriesCollection2 = new TimeSeriesCollection();
        int n3 = 0;
        while (n3 < timeSeriesCollection.getSeriesCount()) {
            TimeSeries timeSeries = timeSeriesCollection.getSeries(n3);
            TimeSeries timeSeries2 = MovingAverage.createMovingAverage(timeSeries, String.valueOf(timeSeries.getName()) + string, n, n2);
            timeSeriesCollection2.addSeries(timeSeries2);
            ++n3;
        }
        return timeSeriesCollection2;
    }

    public static TimeSeries createMovingAverage(TimeSeries timeSeries, String string, int n, int n2) {
        if (timeSeries == null) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : null source.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : periodCount must be greater than or equal to 1.");
        }
        TimeSeries timeSeries2 = new TimeSeries(string, timeSeries.getTimePeriodClass());
        if (timeSeries.getItemCount() > 0) {
            long l = timeSeries.getDataItem(0).getPeriod().getSerialIndex() + (long)n2;
            int n3 = timeSeries.getItemCount() - 1;
            while (n3 >= 0) {
                TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(n3);
                RegularTimePeriod regularTimePeriod = timeSeriesDataItem.getPeriod();
                long l2 = regularTimePeriod.getSerialIndex();
                if (l2 >= l) {
                    int n4 = 0;
                    double d = 0.0;
                    long l3 = regularTimePeriod.getSerialIndex() - (long)n;
                    int n5 = 0;
                    boolean bl = false;
                    while (n5 < n && !bl) {
                        if (n3 - n5 >= 0) {
                            TimeSeriesDataItem timeSeriesDataItem2 = timeSeries.getDataItem(n3 - n5);
                            RegularTimePeriod regularTimePeriod2 = timeSeriesDataItem2.getPeriod();
                            Number number = timeSeriesDataItem2.getValue();
                            long l4 = regularTimePeriod2.getSerialIndex();
                            if (l4 > l3) {
                                if (number != null) {
                                    d += number.doubleValue();
                                    ++n4;
                                }
                            } else {
                                bl = true;
                            }
                        }
                        ++n5;
                    }
                    if (n4 > 0) {
                        timeSeries2.add(regularTimePeriod, d / (double)n4);
                    } else {
                        timeSeries2.add(regularTimePeriod, null);
                    }
                }
                --n3;
            }
        }
        return timeSeries2;
    }

    public static TimeSeries createPointMovingAverage(TimeSeries timeSeries, String string, int n) {
        if (timeSeries == null) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : null source.");
        }
        if (n < 2) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : periodCount must be greater than or equal to 2.");
        }
        TimeSeries timeSeries2 = new TimeSeries(string, timeSeries.getTimePeriodClass());
        double d = 0.0;
        int n2 = 0;
        while (n2 < timeSeries.getItemCount()) {
            TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(n2);
            RegularTimePeriod regularTimePeriod = timeSeriesDataItem.getPeriod();
            d += timeSeriesDataItem.getValue().doubleValue();
            if (n2 > n - 1) {
                TimeSeriesDataItem timeSeriesDataItem2 = timeSeries.getDataItem(n2 - n);
                timeSeries2.add(regularTimePeriod, (d -= timeSeriesDataItem2.getValue().doubleValue()) / (double)n);
            } else if (n2 == n - 1) {
                timeSeries2.add(regularTimePeriod, d / (double)n);
            }
            ++n2;
        }
        return timeSeries2;
    }

    public static XYDataset createMovingAverage(XYDataset xYDataset, String string, long l, long l2) {
        return MovingAverage.createMovingAverage(xYDataset, string, (double)l, (double)l2);
    }

    public static XYDataset createMovingAverage(XYDataset xYDataset, String string, double d, double d2) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : null source (XYDataset).");
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        int n = 0;
        while (n < xYDataset.getSeriesCount()) {
            XYSeries xYSeries = MovingAverage.createMovingAverage(xYDataset, n, String.valueOf(xYDataset.getSeriesName(n)) + string, d, d2);
            xYSeriesCollection.addSeries(xYSeries);
            ++n;
        }
        return xYSeriesCollection;
    }

    public static XYSeries createMovingAverage(XYDataset xYDataset, int n, String string, double d, double d2) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : null source (XYDataset).");
        }
        if (d < Double.MIN_VALUE) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : period must be positive.");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("MovingAverage.createMovingAverage(...) : skip must be >= 0.0.");
        }
        XYSeries xYSeries = new XYSeries(string);
        if (xYDataset.getItemCount(n) > 0) {
            double d3 = xYDataset.getXValue(n, 0) + d2;
            int n2 = xYDataset.getItemCount(n) - 1;
            while (n2 >= 0) {
                double d4 = xYDataset.getXValue(n, n2);
                if (d4 >= d3) {
                    int n3 = 0;
                    double d5 = 0.0;
                    double d6 = d4 - d;
                    int n4 = 0;
                    boolean bl = false;
                    while (!bl) {
                        if (n2 - n4 >= 0) {
                            double d7 = xYDataset.getXValue(n, n2 - n4);
                            Number number = xYDataset.getY(n, n2 - n4);
                            if (d7 > d6) {
                                if (number != null) {
                                    d5 += number.doubleValue();
                                    ++n3;
                                }
                            } else {
                                bl = true;
                            }
                        } else {
                            bl = true;
                        }
                        ++n4;
                    }
                    if (n3 > 0) {
                        xYSeries.add(d4, d5 / (double)n3);
                    } else {
                        xYSeries.add(d4, (Number)null);
                    }
                }
                --n2;
            }
        }
        return xYSeries;
    }
}

