/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import org.jfree.data.Range;

public class DateRange
extends Range
implements Serializable {
    private Date lowerDate;
    private Date upperDate;

    public DateRange() {
        this(new Date(0L), new Date(1L));
    }

    public DateRange(Date date, Date date2) {
        super(date.getTime(), date2.getTime());
        this.lowerDate = date;
        this.upperDate = date2;
    }

    public DateRange(double d, double d2) {
        super(d, d2);
        this.lowerDate = new Date((long)d);
        this.upperDate = new Date((long)d2);
    }

    public DateRange(Range range) {
        this(range.getLowerBound(), range.getUpperBound());
    }

    public Date getLowerDate() {
        return this.lowerDate;
    }

    public Date getUpperDate() {
        return this.upperDate;
    }

    public String toString() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        return "[" + dateFormat.format(this.lowerDate) + " --> " + dateFormat.format(this.upperDate) + "]";
    }
}

