/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.statistics.SimpleHistogramBin;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class SimpleHistogramDataset
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
Cloneable,
PublicCloneable,
Serializable {
    private String name;
    private List bins;
    private boolean adjustForBinSize;

    public SimpleHistogramDataset(String string) {
        this.name = string;
        this.bins = new ArrayList();
        this.adjustForBinSize = true;
    }

    public boolean getAdjustForBinSize() {
        return this.adjustForBinSize;
    }

    public void setAdjustForBinSize(boolean bl) {
        this.adjustForBinSize = bl;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public int getSeriesCount() {
        return 1;
    }

    public String getSeriesName(int n) {
        return this.name;
    }

    public DomainOrder getDomainOrder() {
        return DomainOrder.ASCENDING;
    }

    public int getItemCount(int n) {
        return this.bins.size();
    }

    public void addBin(SimpleHistogramBin simpleHistogramBin) {
        Iterator iterator = this.bins.iterator();
        while (iterator.hasNext()) {
            SimpleHistogramBin simpleHistogramBin2 = (SimpleHistogramBin)iterator.next();
            if (!simpleHistogramBin.overlapsWith(simpleHistogramBin2)) continue;
            throw new RuntimeException("Overlapping bin");
        }
        this.bins.add(simpleHistogramBin);
        Collections.sort(this.bins);
    }

    public void addObservation(double d) {
        this.addObservation(d, true);
    }

    public void addObservation(double d, boolean bl) {
        boolean bl2 = false;
        Iterator iterator = this.bins.iterator();
        while (iterator.hasNext() && !bl2) {
            SimpleHistogramBin simpleHistogramBin = (SimpleHistogramBin)iterator.next();
            if (!simpleHistogramBin.accepts(d)) continue;
            simpleHistogramBin.setItemCount(simpleHistogramBin.getItemCount() + 1);
            bl2 = true;
        }
        if (!bl2) {
            throw new RuntimeException("No bin.");
        }
        if (bl) {
            this.notifyListeners(new DatasetChangeEvent(this, this));
        }
    }

    public void addObservations(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            this.addObservation(dArray[n], false);
            ++n;
        }
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public Number getX(int n, int n2) {
        return new Double(this.getXValue(n, n2));
    }

    public double getXValue(int n, int n2) {
        SimpleHistogramBin simpleHistogramBin = (SimpleHistogramBin)this.bins.get(n2);
        return (simpleHistogramBin.getLowerBound() + simpleHistogramBin.getUpperBound()) / 2.0;
    }

    public Number getY(int n, int n2) {
        return new Double(this.getYValue(n, n2));
    }

    public double getYValue(int n, int n2) {
        SimpleHistogramBin simpleHistogramBin = (SimpleHistogramBin)this.bins.get(n2);
        if (this.adjustForBinSize) {
            return (double)simpleHistogramBin.getItemCount() / (simpleHistogramBin.getUpperBound() - simpleHistogramBin.getLowerBound());
        }
        return simpleHistogramBin.getItemCount();
    }

    public Number getStartX(int n, int n2) {
        return new Double(this.getStartXValue(n, n2));
    }

    public double getStartXValue(int n, int n2) {
        SimpleHistogramBin simpleHistogramBin = (SimpleHistogramBin)this.bins.get(n2);
        return simpleHistogramBin.getLowerBound();
    }

    public Number getEndX(int n, int n2) {
        return new Double(this.getEndXValue(n, n2));
    }

    public double getEndXValue(int n, int n2) {
        SimpleHistogramBin simpleHistogramBin = (SimpleHistogramBin)this.bins.get(n2);
        return simpleHistogramBin.getUpperBound();
    }

    public Number getStartY(int n, int n2) {
        return this.getY(n, n2);
    }

    public double getStartYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public Number getEndY(int n, int n2) {
        return this.getY(n, n2);
    }

    public double getEndYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SimpleHistogramDataset)) {
            return false;
        }
        SimpleHistogramDataset simpleHistogramDataset = (SimpleHistogramDataset)object;
        if (!this.name.equals(simpleHistogramDataset.name)) {
            return false;
        }
        if (this.adjustForBinSize != simpleHistogramDataset.adjustForBinSize) {
            return false;
        }
        return this.bins.equals(simpleHistogramDataset.bins);
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleHistogramDataset simpleHistogramDataset = (SimpleHistogramDataset)super.clone();
        simpleHistogramDataset.bins = (List)ObjectUtilities.deepClone((Collection)this.bins);
        return simpleHistogramDataset;
    }
}

