/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import org.jfree.data.xy.XYDataset;

public abstract class Regression {
    public static double[] getOLSRegression(double[][] dArray) {
        int n = dArray.length;
        if (n < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d5 = dArray[n2][0];
            double d6 = dArray[n2][1];
            d += d5;
            d2 += d6;
            double d7 = d5 * d5;
            d3 += d7;
            double d8 = d5 * d6;
            d4 += d8;
            ++n2;
        }
        double d9 = d3 - d * d / (double)n;
        double d10 = d4 - d * d2 / (double)n;
        double d11 = d / (double)n;
        double d12 = d2 / (double)n;
        double[] dArray2 = new double[2];
        dArray2[1] = d10 / d9;
        dArray2[0] = d12 - dArray2[1] * d11;
        return dArray2;
    }

    public static double[] getOLSRegression(XYDataset xYDataset, int n) {
        int n2 = xYDataset.getItemCount(n);
        if (n2 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            double d5 = xYDataset.getXValue(n, n3);
            double d6 = xYDataset.getYValue(n, n3);
            d += d5;
            d2 += d6;
            double d7 = d5 * d5;
            d3 += d7;
            double d8 = d5 * d6;
            d4 += d8;
            ++n3;
        }
        double d9 = d3 - d * d / (double)n2;
        double d10 = d4 - d * d2 / (double)n2;
        double d11 = d / (double)n2;
        double d12 = d2 / (double)n2;
        double[] dArray = new double[2];
        dArray[1] = d10 / d9;
        dArray[0] = d12 - dArray[1] * d11;
        return dArray;
    }

    public static double[] getPowerRegression(double[][] dArray) {
        int n = dArray.length;
        if (n < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d5 = Math.log(dArray[n2][0]);
            double d6 = Math.log(dArray[n2][1]);
            d += d5;
            d2 += d6;
            double d7 = d5 * d5;
            d3 += d7;
            double d8 = d5 * d6;
            d4 += d8;
            ++n2;
        }
        double d9 = d3 - d * d / (double)n;
        double d10 = d4 - d * d2 / (double)n;
        double d11 = d / (double)n;
        double d12 = d2 / (double)n;
        double[] dArray2 = new double[2];
        dArray2[1] = d10 / d9;
        dArray2[0] = Math.pow(Math.exp(1.0), d12 - dArray2[1] * d11);
        return dArray2;
    }

    public static double[] getPowerRegression(XYDataset xYDataset, int n) {
        int n2 = xYDataset.getItemCount(n);
        if (n2 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            double d5 = Math.log(xYDataset.getXValue(n, n3));
            double d6 = Math.log(xYDataset.getYValue(n, n3));
            d += d5;
            d2 += d6;
            double d7 = d5 * d5;
            d3 += d7;
            double d8 = d5 * d6;
            d4 += d8;
            ++n3;
        }
        double d9 = d3 - d * d / (double)n2;
        double d10 = d4 - d * d2 / (double)n2;
        double d11 = d / (double)n2;
        double d12 = d2 / (double)n2;
        double[] dArray = new double[2];
        dArray[1] = d10 / d9;
        dArray[0] = Math.pow(Math.exp(1.0), d12 - dArray[1] * d11);
        return dArray;
    }
}

