/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.io.Serializable;

public class HistogramBin
implements Cloneable,
Serializable {
    private int count;
    private double startBoundary;
    private double endBoundary;

    public HistogramBin(double d, double d2) {
        if (d > d2) {
            throw new IllegalArgumentException("HistogramBin():  startBoundary > endBoundary.");
        }
        this.count = 0;
        this.startBoundary = d;
        this.endBoundary = d2;
    }

    public int getCount() {
        return this.count;
    }

    public void incrementCount() {
        ++this.count;
    }

    public double getStartBoundary() {
        return this.startBoundary;
    }

    public double getEndBoundary() {
        return this.endBoundary;
    }

    public double getBinWidth() {
        return this.endBoundary - this.startBoundary;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof HistogramBin) {
            boolean bl;
            HistogramBin histogramBin = (HistogramBin)object;
            boolean bl2 = histogramBin.startBoundary == this.startBoundary;
            boolean bl3 = histogramBin.endBoundary == this.endBoundary;
            boolean bl4 = bl = histogramBin.count == this.count;
            return bl2 && bl3 && bl;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

