/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.util.List;
import org.jfree.data.KeyedObjects2D;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.statistics.BoxAndWhiskerCalculator;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerItem;
import org.jfree.util.ObjectUtilities;

public class DefaultBoxAndWhiskerCategoryDataset
extends AbstractDataset
implements BoxAndWhiskerCategoryDataset,
RangeInfo {
    protected KeyedObjects2D data = new KeyedObjects2D();
    private Number minimumRangeValue = null;
    private Number maximumRangeValue = null;
    private Range rangeBounds = new Range(0.0, 0.0);

    public void add(List list, Comparable comparable, Comparable comparable2) {
        BoxAndWhiskerItem boxAndWhiskerItem = BoxAndWhiskerCalculator.calculateBoxAndWhiskerStatistics(list);
        this.add(boxAndWhiskerItem, comparable, comparable2);
    }

    public void add(BoxAndWhiskerItem boxAndWhiskerItem, Comparable comparable, Comparable comparable2) {
        this.data.addObject(boxAndWhiskerItem, comparable, comparable2);
        double d = boxAndWhiskerItem.getMinOutlier().doubleValue();
        double d2 = boxAndWhiskerItem.getMaxOutlier().doubleValue();
        if (this.maximumRangeValue == null) {
            this.maximumRangeValue = new Double(d2);
        } else if (d2 > this.maximumRangeValue.doubleValue()) {
            this.maximumRangeValue = new Double(d2);
        }
        if (this.minimumRangeValue == null) {
            this.minimumRangeValue = new Double(d);
        } else if (d < this.minimumRangeValue.doubleValue()) {
            this.minimumRangeValue = new Double(d);
        }
        this.rangeBounds = new Range(this.minimumRangeValue.doubleValue(), this.maximumRangeValue.doubleValue());
        this.fireDatasetChanged();
    }

    public Number getValue(int n, int n2) {
        return this.getMedianValue(n, n2);
    }

    public Number getValue(Comparable comparable, Comparable comparable2) {
        return this.getMedianValue(comparable, comparable2);
    }

    public Number getMeanValue(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMean();
        }
        return number;
    }

    public Number getMeanValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMean();
        }
        return number;
    }

    public Number getMedianValue(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMedian();
        }
        return number;
    }

    public Number getMedianValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMedian();
        }
        return number;
    }

    public Number getQ1Value(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ1();
        }
        return number;
    }

    public Number getQ1Value(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ1();
        }
        return number;
    }

    public Number getQ3Value(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ3();
        }
        return number;
    }

    public Number getQ3Value(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ3();
        }
        return number;
    }

    public int getColumnIndex(Comparable comparable) {
        return this.data.getColumnIndex(comparable);
    }

    public Comparable getColumnKey(int n) {
        return this.data.getColumnKey(n);
    }

    public List getColumnKeys() {
        return this.data.getColumnKeys();
    }

    public int getRowIndex(Comparable comparable) {
        return this.data.getRowIndex(comparable);
    }

    public Comparable getRowKey(int n) {
        return this.data.getRowKey(n);
    }

    public List getRowKeys() {
        return this.data.getRowKeys();
    }

    public int getRowCount() {
        return this.data.getRowCount();
    }

    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    public double getRangeLowerBound(boolean bl) {
        double d = Double.NaN;
        if (this.minimumRangeValue != null) {
            d = this.minimumRangeValue.doubleValue();
        }
        return d;
    }

    public double getRangeUpperBound(boolean bl) {
        double d = Double.NaN;
        if (this.maximumRangeValue != null) {
            d = this.maximumRangeValue.doubleValue();
        }
        return d;
    }

    public Range getRangeBounds(boolean bl) {
        return this.rangeBounds;
    }

    public Number getMinRegularValue(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinRegularValue();
        }
        return number;
    }

    public Number getMinRegularValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinRegularValue();
        }
        return number;
    }

    public Number getMaxRegularValue(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxRegularValue();
        }
        return number;
    }

    public Number getMaxRegularValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxRegularValue();
        }
        return number;
    }

    public Number getMinOutlier(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinOutlier();
        }
        return number;
    }

    public Number getMinOutlier(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinOutlier();
        }
        return number;
    }

    public Number getMaxOutlier(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxOutlier();
        }
        return number;
    }

    public Number getMaxOutlier(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxOutlier();
        }
        return number;
    }

    public List getOutliers(int n, int n2) {
        List list = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n, n2);
        if (boxAndWhiskerItem != null) {
            list = boxAndWhiskerItem.getOutliers();
        }
        return list;
    }

    public List getOutliers(Comparable comparable, Comparable comparable2) {
        List list = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            list = boxAndWhiskerItem.getOutliers();
        }
        return list;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultBoxAndWhiskerCategoryDataset) {
            DefaultBoxAndWhiskerCategoryDataset defaultBoxAndWhiskerCategoryDataset = (DefaultBoxAndWhiskerCategoryDataset)object;
            return ObjectUtilities.equal((Object)this.data, (Object)defaultBoxAndWhiskerCategoryDataset.data);
        }
        return false;
    }
}

