/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.jfree.data.category.DefaultCategoryDataset;

public class JDBCCategoryDataset
extends DefaultCategoryDataset {
    private transient Connection connection;
    private boolean transpose = true;

    public JDBCCategoryDataset(String string, String string2, String string3, String string4) throws ClassNotFoundException, SQLException {
        Class.forName(string2);
        this.connection = DriverManager.getConnection(string, string3, string4);
    }

    public JDBCCategoryDataset(Connection connection) {
        if (connection == null) {
            throw new NullPointerException("A connection must be supplied.");
        }
        this.connection = connection;
    }

    public JDBCCategoryDataset(Connection connection, String string) throws SQLException {
        this(connection);
        this.executeQuery(string);
    }

    public boolean getTranspose() {
        return this.transpose;
    }

    public void setTranspose(boolean bl) {
        this.transpose = bl;
    }

    public void executeQuery(String string) throws SQLException {
        this.executeQuery(this.connection, string);
    }

    public void executeQuery(Connection connection, String string) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            if (n < 2) {
                throw new SQLException("JDBCCategoryDataset.executeQuery() : insufficient columns returned from the database.");
            }
            int n2 = this.getRowCount();
            while (n2 > 0) {
                this.removeRow(n2);
                --n2;
            }
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                int n3 = 2;
                while (n3 <= n) {
                    String string3 = resultSetMetaData.getColumnName(n3);
                    int n4 = resultSetMetaData.getColumnType(n3);
                    switch (n4) {
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            Object object = (Number)resultSet.getObject(n3);
                            if (this.transpose) {
                                this.setValue((Number)object, (Comparable)((Object)string3), (Comparable)((Object)string2));
                                break;
                            }
                            this.setValue((Number)object, (Comparable)((Object)string2), (Comparable)((Object)string3));
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            Object object = (java.sql.Date)resultSet.getObject(n3);
                            Number number = new Long(((Date)object).getTime());
                            if (this.transpose) {
                                this.setValue(number, (Comparable)((Object)string3), (Comparable)((Object)string2));
                                break;
                            }
                            this.setValue(number, (Comparable)((Object)string2), (Comparable)((Object)string3));
                            break;
                        }
                        case -1: 
                        case 1: 
                        case 12: {
                            Number number;
                            Object object = (String)resultSet.getObject(n3);
                            try {
                                number = Double.valueOf((String)object);
                                if (this.transpose) {
                                    this.setValue(number, (Comparable)((Object)string3), (Comparable)((Object)string2));
                                    break;
                                }
                                this.setValue(number, (Comparable)((Object)string2), (Comparable)((Object)string3));
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                    }
                    ++n3;
                }
            }
            this.fireDatasetChanged();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

