/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;

public abstract class DataUtilities {
    public static Number[] createNumberArray(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        Number[] numberArray = new Number[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            numberArray[n] = new Double(dArray[n]);
            ++n;
        }
        return numberArray;
    }

    public static Number[][] createNumberArray2D(double[][] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        int n = dArray.length;
        Number[][] numberArray = new Number[n][];
        int n2 = 0;
        while (n2 < n) {
            numberArray[n2] = DataUtilities.createNumberArray(dArray[n2]);
            ++n2;
        }
        return numberArray;
    }

    public static KeyedValues getCumulativePercentages(KeyedValues keyedValues) {
        if (keyedValues == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        double d = 0.0;
        int n = 0;
        while (n < keyedValues.getItemCount()) {
            Number number = keyedValues.getValue(n);
            if (number != null) {
                d += number.doubleValue();
            }
            ++n;
        }
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < keyedValues.getItemCount()) {
            Number number = keyedValues.getValue(n2);
            if (number != null) {
                d2 += number.doubleValue();
            }
            defaultKeyedValues.addValue(keyedValues.getKey(n2), new Double(d2 / d));
            ++n2;
        }
        return defaultKeyedValues;
    }
}

